{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}

unit SqlTxtRtns;

{$I FIBPlus.inc}

interface
uses
 {$IFDEF MSWINDOWS}
  Windows,SysUtils,Classes,StrUtil
  {$IFDEF D6+}, Variants{$ENDIF}
;

 {$ENDIF}
 {$IFDEF LINUX}
  Types, SysUtils, Classes, StrUtil
  , Variants;
 {$ENDIF}

const
   space='    ';
   ForceNewStr=#13#10+space;
   QuotMarks=#39;

 function  DispositionFrom(const SQLText:string):TPoint;

 procedure AllSQLTables(SQLText:string;FTables:Tstrings);


 procedure AllTables(const SQLText:string;FTables:Tstrings);

 function  TableByAlias(const SQLText,Alias:string):string;
 function  FullFieldName(const SQLText,aFieldName:string):string;
 function  AddToWhereClause(const SQLText,NewClause:string;
  ForceCLRF:boolean {$IFDEF D4+} = True{$ENDIF}
 ):string;
 function  GetWhereClause(const SQLText:string;N:integer;var
   StartPos,EndPos:integer
 ):string;
 function  WhereCount(SQLText:string):integer;
 function  MainWhereIndex(const SQLText:string):integer;
 
 function  GetOrderInfo(const SQLText:string):variant;
 function  OrderStringTxt(const SQLText:string;
  var StartPos,EndPos:integer
 ):String;

 procedure SetOrderString(SQLText:TStrings;const OrderTxt:string);
//

 function  PrepareConstraint(Src:Tstrings):string;
 procedure DeleteEmptyStr(Src:Tstrings);
 procedure NormalizeSQLText(const SQL: string;MacroChar:Char;
  var NSQL:string
 );


 function  CountSelect(const SrcSQL:string):string;
 function  GetModifyTable(const SQLText:string;AlreadyNormal:boolean):string;

const
  CharsAfterClause =[' ',#13,#9];
  CharsBeforeClause=[' ',#10,')',#9];

implementation

const

  BeginWhere =' WHERE ';

function PosOrderBy(const SQLText:string):integer;
begin
 Result:=PosExtCI('ORDER',SQLText,CharsBeforeClause,CharsAfterClause);
end;

function PosClause(const Clause,SQLText:string):integer;
begin
 Result:=PosExtCI(Clause,SQLText,CharsBeforeClause,CharsAfterClause);
end;


procedure NormalizeSQLText(const SQL: string;MacroChar:Char;
  var NSQL:string
);
const
 endLexem=['+',')','(','*','/','|',',','=','>','<','-','!','^','~',',',';'];
 aUnceasing:array [0..12] of string  = ('||','<>','>=','<=','!=','!<','!>',
  '^=','~=','^>','~>','^<','~<'
 );

var i,j:integer;
    InQuote:boolean;
    InRemark:boolean;
    PredChar:Char;
    QuoteChar:Char;
    l:integer;
    InMacroValue,IsMacroVer1,InMacro:boolean;

function EndMacro:boolean;
begin
 if IsMacroVer1 then
  if InMacroValue then
   Result:=(SQL[i] in  [#13,' ',#9])
  else
   Result:=(SQL[i] in  [#13,' ']+endLexem)
 else
  Result:=(SQL[i]=MacroChar) and (SQL[i-1]<>MacroChar)
end;

begin
 InQuote:=false;  InRemark:=false;
 PredChar:=#0;    QuoteChar:='"';
 l:=Length(SQL);  InMacro  :=false;
 if l=0 then
 begin
  NSQL:='';  Exit;
 end ;
 if SQL[1]=' ' then
 begin
  SetLength(NSQL,l);
  j:=1;
 end
 else
 begin
  SetLength(NSQL,l+1);
  NSQL[1]:=' ';
  j:=2;
  //   
 end;
 IsMacroVer1:=false;
 for i:=1 to l do
 begin
  if not InQuote then
  if not InRemark then
  begin
   InRemark:=(SQL[i]='/')and (i<l) and (SQL[i+1]='*');
  end
  else
   InRemark:=not ((SQL[i-1]='/')and (i>2) and (SQL[i-2]='*'));

  if not InRemark  then
  if not InQuote then
  begin
   InQuote:= (SQL[i] in ['''','"']);
   if InQuote then QuoteChar:=SQL[i];
  end
  else
   InQuote:= (SQL[i] <> QuoteChar);
  if InRemark then
   // InRemark
   Continue
  else
  if InQuote then
  begin
   //InQuote
    NSQL[j]:= SQL[i];Inc(j);
  end
  else
  if (SQL[i] in endLexem) and not InMacro then
  begin
   if (PredChar<>' ') then
   begin
    if not (StringInArray(PredChar+SQL[i],aUnceasing)) then
    begin
     NSQL[j]:=' ';
     Inc(j)
    end;
     if SQL[i]=':' then
      NSQL[j]:='?'
     else
      if  (PredChar in ['!','^','~']) and (SQL[i]='=') then
      begin
       NSQL[j-1] :='<';
       NSQL[j]   :='>';
      end
      else
       NSQL[j]:=SQL[i];
    if (i<>l) and (SQL[i+1]<>' ') and
     not StringInArray(SQL[i]+SQL[i+1],aUnceasing)  then
    begin
     Inc(j);
     NSQL[j]:=' ';
    end;
    Inc(j);
   end
   else
   begin
    NSQL[j]:=SQL[i];
    Inc(j);
   end;
  end
  else
  if (SQL[i] in ['?',':',MacroChar]) and (PredChar in EndLexem+[' '])
  then
  begin
   // Start Macro or Param
   InMacroValue:=false;
   if NSQL[j-1]<>' ' then
   begin
     NSQL[j]:=' ';
     if SQL[i]=':' then
      NSQL[j+1]:='?'
     else
      NSQL[j+1]:=SQL[i];
     Inc(j,2);
   end
   else
   begin
     if SQL[i]=':' then
      NSQL[j]:='?'
     else
      if  (PredChar in ['!','^','~']) and (SQL[i]='=') then
      begin
       NSQL[j-1] :='<';
       NSQL[j]   :='>';
      end
      else
       NSQL[j]:=SQL[i];
    Inc(j,1);
   end;
   InMacro    :=SQL[i]=MacroChar;
   if InMacro and (i<l) then
    IsMacroVer1:=SQL[i+1]<>MacroChar;
  end
  else
  if InMacro then
  begin
    InMacro    :=not EndMacro;
    if InMacro then
    begin
      InMacroValue:=InMacroValue or (IsMacroVer1 and (SQL[i]='%'));
      NSQL[j]:=SQL[i];
      Inc(j);
    end
    else
    begin
      if IsMacroVer1 then
      begin
        NSQL[j]:=' ';
       if not (SQL[i] in [' ',#13,#10,#9]) then
       begin
        Inc(j);
        NSQL[j]:=SQL[i];
        Inc(j);
        NSQL[j]:=' ';
       end;
      end
      else
       if SQL[i]=':' then
        NSQL[j]:='?'
       else
        if  (PredChar in ['!','^','~']) and (SQL[i]='=') then
        begin
         NSQL[j-1] :='<';
         NSQL[j]   :='>';
        end
        else
        NSQL[j]:=SQL[i];
      Inc(j);
    end;
  end
  else
  if (SQL[i] in [' ',#13,#10,#9]) then
  begin
   // Pack space
   if (j>1) and (NSQL[j-1]<>' ') then
   begin
    NSQL[j]:=' ';
    Inc(j);
    InMacro    :=false;
   end
  end
  else
  begin
     if SQL[i]=':' then
      NSQL[j]:='?'
     else
      NSQL[j]:=UpperCase(SQL[i])[1];
    Inc(j);
  end;
  PredChar:=SQL[i] ;
  if j>=l then SetLength(NSQL,j+10);
 end;
 SetLength(NSQL,j-1);
end;


function RemoveSP(const FromStr:string):string;
var pBrIn,pBrOut:integer;
    cBrIn,cBrOut:integer;
    l:integer;
begin
 Result:=FromStr;
 pBrIn:=Pos('(',FromStr);
 if pBrIn=0 then Exit;
 l:=Length(FromStr);
 while pBrIn >0 do
 begin
  pBrOut:=pBrIn+1;
  cBrIn :=1;     cBrOut:=0;
  while (cBrOut<cBrIn)  do
  begin
   if Result[pBrOut]=')' then Inc(cBrOut)
   else
   if Result[pBrOut]='(' then Inc(cBrIn);
   Inc(pBrOut);
   if pBrOut>l then Exit;
  end;
  while (pBrIn>1) and not (Result[pBrIn] in [',']) do Dec(pBrIn);
  while (pBrOut<=Length(Result)) and not (Result[pBrOut] in [',']) do Inc(pBrOut);
  System.Delete(Result,pBrIn,pBrOut-pBrIn);
  pBrIn:=Pos('(',Result);
 end;
end;

function RemoveJoins(const FromStr:string):string;
var pON,pComa,pJOIN:integer;
    tmpStr:string;
begin
 Result:=FromStr;
 pJOIN:=PosClause('JOIN',Result);
 if pJOIN=0 then Exit;
 Result:=Copy(Result,1,pJOIN-1)+', '+Copy(Result,PJOIN+5,MaxInt);
 Result:=ReplaceCIStr(Result, ' LEFT ' , ' ');
 Result:=ReplaceCIStr(Result, ' RIGHT ', ' ');
 Result:=ReplaceCIStr(Result, ' FULL ' , ' ');
 Result:=ReplaceCIStr(Result, ' INNER ', ' ');
 Result:=ReplaceCIStr(Result, ' OUTER ', ' ');
 Result:=ReplaceCIStr(Result, ' JOIN ', ' , ');
 pON:=PosClause('ON',Result);
 tmpStr:='';
 while pOn >0 do
 begin
  DoCopy(Result,tmpStr,pOn+2,MaxInt);
  pComa:=Pos(',',tmpStr);
  SetLength(Result,pOn-1);
  if pComa>0 then
  begin
   Result:=Result+Copy(tmpStr,pComa,MaxInt)
  end;
  pON:=PosClause('ON',Result);
 end;
end;

function DispositionFrom(const SQLText:string):TPoint;
var FromText:string;
    p:Integer;
    bracket:Integer;
    i:Integer;
    L :Integer;
begin
//  FromText:=ReplaceStr(UpperCase(SQLText),#13#10,'  ');
  FromText:=UpperCase(SQLText);
  p:=Pos('SELECT',FromText);
  if p=0 then Exit;
  if not  (FromText[p+6] in [' ','(',#13,#9]) then Exit;
  p:=p+6;
  bracket:=0;
  L :=Length(FromText)-5;
  For i:=p to L do
   begin
    if (bracket=0) and(FromText[i]='F') and (FromText[i+1]='R') and
     (FromText[i+2]='O') and (FromText[i+3]='M') and
     (FromText[i+4] in [' ',#13,#9,#10]) and
     (FromText[i-1] in CharsBeforeClause)
    then
     Break;
    if FromText[i]='(' then inc(bracket);
    if FromText[i]=')' then dec(bracket);
   end;
  if i>=L then Exit;

  Result.X:=i;
  For i:=Result.X+5 to Length(FromText) do
   begin
    if (bracket=0) and (FromText[i-1] in  [' ',#10,#13,#9]) then
    if i<=Length(FromText)-6 then
    if FromText[i+5] in CharsAfterClause then
    case FromText[i] of
    'W':if (FromText[i+1]='H') and
           (FromText[i+2]='E') and
           (FromText[i+3]='R') and
           (FromText[i+4]='E')
        then Break;
    'G':if (FromText[i+1]='R') and
           (FromText[i+2]='O') and
           (FromText[i+3]='U') and
           (FromText[i+4]='P')
        then Break;
    'O':if (FromText[i+1]='R') and
           (FromText[i+2]='D') and
           (FromText[i+3]='E') and
           (FromText[i+4]='R')
        then Break;
    'P':if (FromText[i+1]='L') and
           (FromText[i+2]='A') and
           (FromText[i+3]='N') and
           (FromText[i+4] in CharsAfterClause)
        then Break;
    end;
    if FromText[i]='(' then inc(bracket);
    if FromText[i]=')' then dec(bracket);
   end;
  Result.Y:=i;
  if i<>Length(FromText) then
   begin
    Result.Y:=i-1;
    while FromText[Result.Y] in [' ',#10,#13,#9] do Dec(Result.Y)
   end
  else
   Result.Y:=i;
  Inc(Result.Y);
end;


function  CountSelect(const SrcSQL:string):string;
var fr:TPoint;
    StartWhere,EndWhere:integer;
    wh:string;
begin
 Result:='';
 if PosCI('SELECT',SrcSQL)=0 then Exit;
 fr:=DispositionFrom(SrcSQL);
 if fr.x=0 then Exit;
 Result:='Select Count(*) '+Copy(SrcSQL,fr.x,fr.y-fr.x);
 wh:=GetWhereClause(Copy(SrcSQL,fr.x,100000),1,StartWhere,EndWhere);
 if wh<>'' then
  Result:=Result+#13#10+BeginWhere+wh;
end;

function  GetModifyTable(const SQLText:string;AlreadyNormal:boolean):string;
var p:integer;
begin
 if not AlreadyNormal then
 begin
  NormalizeSQLText(SQLText,'@',Result);
  Result:=' '+Result;
 end
 else
  Result:=' '+SQLText;
 p:=Pos(' INSERT ',Result);
 if p<>0 then
 begin
   Delete(Result,1,14);
 end
 else
 begin
  p:=Pos(' UPDATE ',Result);
  if p<>0 then
  begin
   Delete(Result,1,9);
  end
  else
  begin
   p:=Pos(' DELETE ',Result);
   if p=0 then
   begin
    Result:=''; Exit;
   end;
   Delete(Result,1,14);
  end;
 end;
 if Result[1]<>'"' then
  p:=Pos( ' ',Result)-1
 else
 begin
  p:=PosInRight('"',Result,2);
 end;
 if p>0 then
  SetLength(Result,p);
end;

procedure AllSQLTables(SQLText:string;FTables:Tstrings);
var i,j:integer;
begin
 NormalizeSQLText(SQLText,'@',SQLText);
 FTables.Text:=GetModifyTable(SQLText,true);
 if FTables.Count=0 then
 begin
  AllTables(SQLText,FTables);
  for i:=0 to Pred(FTables.Count) do
  if Pos('"',FTables[i])=0 then
   FTables[i]:= ExtractWord(1,FTables[i],[' '])
  else
  begin
   for j:=Length(FTables[i]) downto 1 do
   if FTables[i][j]='"' then Break;
   FTables[i]:=Copy(FTables[i],1,j);
  end;
 end;
end;


procedure AllTables(const SQLText:string;FTables:Tstrings);
var s,FromText:string;
      i,p,p1:integer;
      DFrom       :TPoint;

begin
 FTables.Clear;
 if IsBlank(SQLText) then Exit;
 DFrom:=DispositionFrom(SQLText);
 DoCopy(SQLText,FromText,DFrom.X+4,DFrom.Y-DFrom.X-3);
 FromText:=ReplaceStr(Trim(FromText),#13#10,'  ');
 if FromText='' then Exit;
 if PosClause('JOIN',FromText) >0 then FromText:=RemoveJoins(FromText);
 if PosCI('(',FromText)>0 then FromText:=RemoveSP(FromText);
 p:=WordCount(FromText,[',']);
 for  i:=1  to p do   begin
  s:=ExtractWord(i, FromText,[',']);
  p1 := PosClause('AS',s);
  if p1>0 then
   Delete(s,p1,3);
  DoTrim(s);
  FTables.Add(s);
 end;
end;

function  TableByAlias(const SQLText,Alias:string):string;
var ts:Tstrings;
    i,p:integer;
begin
 Result:=Alias;
 ts:=TStringList.Create;
 try
  AllTables(SQLText,ts);
  for i:=0 to Pred(ts.Count) do
  begin
   p:=PosCI(' '+Alias,ts[i]);
   if p>0 then
   begin
     DoCopy(ts[i],Result,1,p-1);
     DoTrim(Result);
     Exit
   end;
  end;
 finally
  ts.Free
 end;
end;

function FullFieldName(const SQLText,aFieldName:string):string;
var   p:integer;
begin
 p:=Pos('.',aFieldName);
 if p=0 then
  Result:=aFieldName
 else
  Result:=TableByAlias(SQLText,Copy(aFieldName,1,p-1))
         +Copy(aFieldName,p,1000);
end;


function  OpenBracketCount(const Txt:string;Len:integer):integer;
type TState =(sNormal,sQuote,sComment);
var j:integer;
    State:TState;
begin
 result:=0; State:=sNormal;
 for j := 1 to Len do
 begin
  case Txt[j] of
    '(':if not (State in [sComment,sQuote]) then
          Inc(result);
    ')': if not (State in [sComment,sQuote]) then
          Dec(result);
    '"': if State<>sComment then
          if State=sQuote then
           State:=sNormal
          else
           State:=sQuote;
    '*': if State<>sQuote then
          if State=sComment then
          begin
            if (j<len) and (Txt[j+1]='/') then
              State:=sNormal
          end
          else
            if (j>1) and (Txt[j-1]='/') then State:=sComment
  end;    // case
 end;    // for
end;

function  MainWhereIndex(const SQLText:string):integer;
var i,wc:integer;
    p,Len:integer;
begin
 result:=-1;
 wc  := WhereCount(SQLText);p:=1;
 Len := Length(SQLText);
 if wc=0 then exit;
 for i := 1 to wc do    // Iterate
 begin
  p:=PosInSubstrCIExt('WHERE',SQLText,p+1,Len,
    CharsBeforeClause,CharsAfterClause);
  if OpenBracketCount(Copy(SQLText,1,p),p)=0 then
  begin
   result:=i; exit;
  end;
 end;    // for
end;

function WhereCount(SQLText:string):integer;
var p:integer;
begin
  Result:=0;
  p:=PosClause('WHERE',SQLText);
  while p>0 do
  begin
   Inc(Result);
   System.Delete(SQLText,1,p+6);
   p:=PosClause('WHERE',SQLText);
  end;
end;

function  OrderStringTxt(const SQLText:string;
 var StartPos,EndPos:integer):String;
const l=Length('ORDER');
      l1=Length('FOR UPDATE');
var p:integer;
begin
 StartPos:=PosOrderBy(SQLText);
 if StartPos=0 then
 begin
   Result:='';   Exit;
 end;
 DoCopy(SQLText,Result,StartPos+l,10000);
 p:=PosExtCI('BY',Result,[' ',#10,')'],[' ',#13]);
 if p=0 then
 begin
   Result:='';  StartPos:=0; Exit;
 end;
 Delete(Result,1,p+1);
 EndPos:=PosExtCI('FOR UPDATE',Result,[' ',#10,')'],[' ',#13]);
 if EndPos=0 then EndPos:=Length(SQLText)
 else
  SetLength(Result,EndPos-1);
end;

function  GetOrderInfo(const SQLText:string):variant;
var p,i:integer;
    wc:integer;
    bufStr,s:string;
    NSQL:string;
begin
 Result:=null;
 NSQL:=SQLText;
 NormalizeSQLText(SQLText,'@',NSQL);
 p:=PosOrderBy(NSQL);
 if p=0 then Exit;
 Delete(NSQL,1,p+5);
 p:=PosClause('BY',NSQL);
 if p=0 then Exit;
 Delete(NSQL,1,p+2);
// NSQL:=Copy(NSQL,p+3,Length(NSQL));
 wc:=WordCount(NSQL,[',']);
 if wc<1 then Exit;
 Result:=VarArrayCreate([0,wc-1,0,1],varVariant);
 for i:=1 to wc do
 begin
   bufStr:=ExtractWord(i,NSQL,[',']);
   if WordCount(bufStr,['.'])>1 then
   s:=ExtractWord(1,bufStr,['.'])+ '.'+
    Trim(ExtractWord(2,bufStr,['.']))
  else
   s:=bufStr;

  s:=ReplaceStr(s,'"','');
  p:=PosClause('COLLATE',s);
  if p>0 then
   SetLength(s,p-1);
  p:=PosClause('DESC',s);
  Result[i-1,1]:=p=0;
  if p>0 then
    SetLength(s,p-1)
  else
  begin
   p:=PosClause('ASC',s);
   if p>0 then
    SetLength(s,p-1);
  end;
  Result[i-1,0]:=Trim(s);
 end;
end;

procedure SetOrderString(SQLText:TStrings;const OrderTxt:string);
var StartPos,EndPos:integer;
    Old :string;
    OldTxt:string;
begin
  with SQLText do
  begin
   OldTxt:=Text;
   Old:=SqlTxtRtns.OrderStringTxt(OldTxt, StartPos,EndPos);
   if StartPos>0 then
    Text:=ReplaceStrInSubstr(OldTxt, Old,' '+ OrderTxt+' ',
              StartPos,EndPos
    )
   else
    Text:=OldTxt+' ORDER BY '+OrderTxt
  end;
end;

function  GetWhereClause(const SQLText:string;N:integer;var
 StartPos,EndPos:integer
):string;
var p,brOpen,WhInd,brClose:integer;
    l:integer;
    lSQLText:string;
    fixPos  :integer;
begin
//  N  where clause
// Returns N  where clause
  p:=PosClause('WHERE',SQLText);
  if p=0 then
  begin
   StartPos:=0; EndPos:=0; Result:='';  Exit;
  end;
  WhInd:=1;
  while  (p>0) and (WhInd<N) do
  begin
   p:=PosInSubstrCIExt('WHERE',SQLText,
                     p+5,10000,
       CharsBeforeClause,CharsAfterClause
      );
   if p>0 then Inc(WhInd);
  end;
  if (WhInd<N) then
  begin
   StartPos:=0; EndPos:=0; Result:='';  Exit;
  end;
  StartPos:=p+5;
  DoCopy(SQLText,lSQLText,StartPos,MaxInt);
  p:=1;
  L:=Length(lSQLText);
  FixPos:=1;
  if (p>0) then
  begin
   brOpen:=0; brClose:=0;
   // brOpen= count of '('; brClose= count of ')'

   while (p<l) and (brClose<=brOpen) do
   begin
    if lSQLText[p]='(' then Inc(brOpen)
    else
    if lSQLText[p]=')' then Inc(brClose);
    if (brClose<brOpen) then
    begin
     FixPos:=p;
     Inc(p);
    end
    else
    if brOpen=brClose then
    begin
      Inc(p);
      if ((L-P)>4) and (lSQLText[P-1] in [' ',')',#9,#13,#10]) then
       if (lSQLText[P] in ['P','p'])   and
          (lSQLText[P+1] in ['L','l']) and
          (lSQLText[P+2] in ['A','a']) and
          (lSQLText[P+3] in ['N','n'])
       then
       begin
        SetLength(lSQLText,p-1);
        Break
       end;
    end;
   end;
   if brClose>brOpen then
    SetLength(lSQLText,p-1);
  end
  else
  begin
   p:=Pos(')',lSQLText);
   if p>0 then
   begin
    SetLength(lSQLText,p-1);
   end;
  end;
  if FixPos=1 then
    Result:=''
  else
  begin
    DoCopy(lSQLText,Result,1,FixPos+1);
    Delete(lSQLText,1,FixPos+1);
  end;

  p :=PosClause('GROUP',lSQLText);
  brOpen:=PosClause('UNION',lSQLText);
  if (brOpen<>0) and (brOpen<p) then p:=brOpen;
  if p>0 then
  begin
   SetLength(lSQLText,p-1)
  end
  else
  begin
    p:=PosClause('PLAN',lSQLText);
    if p>0 then
    begin
     Result:=Result+Copy(lSQLText,1,p-1);
    end
    else
    begin
      p:=PosOrderBy(lSQLText);
      if (p>0) then
      begin
       Result:=Result+Copy(lSQLText,1,p-1);
      end
      else
       Result:=Result+lSQLText;
    end
  end;
  EndPos:=StartPos+Length(Result)-1;
  p:=0;
  while SQLText[EndPos] in [#13,#10,#9,' '] do
  begin
   Dec(EndPos); Inc(p)
  end;
  if p<>0 then
   SetLength(Result,Length(Result)-p);
  if Length(Result)=0 then Exit;
  p:=1;
  while Result[p] in [#13,#10,#9,' '] do Inc(p);
  if p>1 then  begin
   Inc(StartPos,p-1);
   Delete(Result,1,p-1);
  end;
end;

function  AddToWhereClause(const SQLText,NewClause:string;
ForceCLRF:boolean {$IFDEF D4+} = True{$ENDIF}
):string;
var p:integer;    Old:string;
    StartPos,EndPos:integer;
    CLRF :string;
begin
  CLRF :=iifStr(ForceCLRF,ForceNewStr,'');
  if IsBlank(NewClause) then
  begin
    Result:=SQLText;  Exit
  end;
  p:=MainWhereIndex(SQLText);
  if p>=0 then
  begin
   Old:=GetWhereClause(SQLText,p, StartPos,EndPos);
   Result:=
    ReplaceStrCIInSubstr(SQLText,Old,'( '+Old+' )'+CLRF+' and '+CLRF+'( '+NewClause+' )',
            StartPos,EndPos
    );
   Exit
  end
  else
  begin
   p:=PosClause('GROUP',SQLText);
   if p=0 then p:=PosClause('PLAN',SQLText);
   if p=0 then p:=PosOrderBy(SQLText);
   if p>0 then
     Result:=Copy(SQLText,1,p-1)+BeginWhere+CLRF+NewClause+CLRF+
      Copy(SQLText,p,MaxInt)
   else
     Result:=SQLText+BeginWhere+CLRF+NewClause;
  end
end;

function PrepareConstraint(Src:Tstrings):string;
var i,pos_no: integer;
begin
//      
//    
//   
    Result := Trim(Src.Text);
    pos_no := Pos('(',Result)+1;
    Result:=Copy(Result,Pos_no,Length(Result));
    pos_no :=-1;
    for i := Length(Result) downto 1 do
     if Result[i]=')' then begin pos_no := i; Break; end;
    SetLength(Result,Pos_no-1);
    Result:=
     ReplaceStr(Copy(Result,Pos_no,Length(Result)-Pos_no), '"',QuotMarks)
end;

procedure DeleteEmptyStr(Src:Tstrings);
var I:integer;
begin
 i:=0;
 while i<Src.Count do
  if Src[i]='' then Src.Delete(i)
  else Inc(i)
end;

end.


