/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Attribute;
import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.Description;
import edu.stanford.TAP.Description_XML;
import edu.stanford.TAP.Error;
import edu.stanford.TAP.Export_XML;
import edu.stanford.TAP.KB;
import edu.stanford.TAP.Request;
import edu.stanford.TAP.Restriction;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.XML_Branch;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class Export_SOAP
extends Export_XML {
    XML_Branch body = null;
    XML_Branch data = null;
    Hashtable expanded = null;
    String toptag = null;
    Request req;
    boolean partial;
    int curPos;
    int startAt;
    int stepSize;

    public Export_SOAP(Request request) {
        this.req = request;
        this.partial = false;
        this.curPos = 0;
        this.startAt = -1;
        this.stepSize = -1;
    }

    public void StartSerialize(KB kB, Object object) {
        Object object2;
        String string = kB.GetURL();
        if (string == null) {
            string = "";
        }
        this.os = (OutputStream)object;
        try {
            this.os.write((XML.header + "\n").getBytes());
            this.printLicense();
        }
        catch (IOException iOException) {
            Error.Report("Failed to write client", iOException);
        }
        this.top = new XML_Branch("Envelope");
        this.top.AddAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        if (Abbrev.GetKBLabel(string) == null && Abbrev.GetStdLabel(string) == null) {
            this.top.AddAttribute("xmlns:thiskb", string);
        }
        this.body = new XML_Branch("Body");
        this.top.AddChild(this.body);
        this.data = new XML_Branch(this.toptag != null ? this.toptag : "Data");
        this.body.AddChild(this.data);
        if (this.req != null) {
            object2 = this.req.GetParameters().elements();
            while (object2.hasMoreElements()) {
                Attribute attribute = (Attribute)object2.nextElement();
                this.data.AddAttribute(attribute.name, attribute.value);
                if (attribute.name.equals("startAt")) {
                    this.partial = true;
                    this.startAt = Integer.parseInt(attribute.value);
                    continue;
                }
                if (!attribute.name.equals("stepSize")) continue;
                this.partial = true;
                this.stepSize = Integer.parseInt(attribute.value);
            }
        }
        this.expanded = new Hashtable();
        try {
            object2 = this.top.OpenString(0, true, false, new StringBuffer()).toString() + "\n";
            this.os.write(((String)object2).getBytes());
            object2 = this.body.OpenString(2, false, false, new StringBuffer()).toString() + "\n";
            this.os.write(((String)object2).getBytes());
            object2 = this.data.OpenString(4, false, false, new StringBuffer()).toString() + "\n";
            this.os.write(((String)object2).getBytes());
        }
        catch (IOException iOException) {
            Error.Report("Failed to write to client", iOException);
        }
    }

    private Description PrepareForOne(KB kB, String string) {
        Description description = new Description(null);
        if (!kB.HasNode(string)) {
            description.AddArcTarget("oid", string);
            description.AddArcTarget("type", "Literal");
        } else {
            String string2 = string;
            if (Abbrev.NeedsNamespace(string)) {
                string2 = kB.AddNamespace(string);
            }
            description.AddArcTarget("oid", string2);
            Cursor cursor = kB.GetTargets(string, "type");
            String string3 = cursor.Next();
            while (string3 != null) {
                String string4 = string3;
                if (Abbrev.NeedsNamespace(string3)) {
                    string4 = kB.AddNamespace(string3);
                }
                description.AddArcTarget("type", string4);
                string3 = cursor.Next();
            }
            cursor.Release();
        }
        return description;
    }

    private void AddArc(KB kB, String string, String string2, Cursor cursor, Description description, boolean bl) {
        String string3 = cursor.Next();
        while (string3 != null) {
            if (!bl || !this.partial || this.curPos >= this.startAt && this.curPos - this.startAt < this.stepSize) {
                if (!kB.IsLexiconArc(string) && (kB.HasNode(string3) || string.equals("type") || string.equals("subClassOf"))) {
                    Object object;
                    if (this.expanded.get(string3) == null && (string2.startsWith("!") || !string.equals("oid") && !string.equals("type") && !string.equals("subClassOf"))) {
                        this.expanded.put(string3, string3);
                        object = kB.DescriptionFromNode(string3, true);
                        description.AddArcTarget(string2, object);
                    } else {
                        object = string3;
                        if (Abbrev.NeedsNamespace(string3)) {
                            object = kB.AddNamespace(string3);
                        }
                        description.AddArcTarget(string2, object);
                    }
                } else {
                    description.AddArcTarget(string2, string3);
                }
            }
            if (bl) {
                ++this.curPos;
            }
            string3 = cursor.Next();
        }
    }

    private void FinishOne(Description description) {
        XML_Branch xML_Branch = Description_XML.ToBranch(description);
        this.data.AddChild(xML_Branch);
        String string = xML_Branch.ToString(6, false, new StringBuffer()).toString();
        try {
            this.os.write(string.getBytes());
        }
        catch (IOException iOException) {
            Error.Report("Failed to write to client", iOException);
        }
    }

    public void SerializeOne(KB kB, String string) {
        if (!this.partial || this.curPos >= this.startAt && this.curPos - this.startAt < this.stepSize) {
            Description description = this.PrepareForOne(kB, string);
            boolean bl = false;
            Cursor cursor = kB.GetArcs(string);
            String string2 = cursor.Next();
            while (string2 != null) {
                bl = true;
                String string3 = string2;
                if (Abbrev.NeedsNamespace(string2)) {
                    string3 = kB.AddNamespace(string2);
                }
                if (!description.HasRestriction(string3)) {
                    Cursor cursor2 = kB.GetTargets(string, string2);
                    this.AddArc(kB, string2, string3, cursor2, description, false);
                    cursor2.Release();
                }
                string2 = cursor.Next();
            }
            cursor.Release();
            if (bl) {
                this.FinishOne(description);
            }
        }
        ++this.curPos;
    }

    public Object EndSerialize() {
        try {
            String string = this.data.CloseString(4, false, new StringBuffer()).toString();
            this.os.write((string + "\n").getBytes());
            string = this.body.CloseString(2, false, new StringBuffer()).toString();
            this.os.write((string + "\n").getBytes());
            string = this.top.CloseString(0, false, new StringBuffer()).toString();
            this.os.write((string + "\n").getBytes());
        }
        catch (IOException iOException) {
            Error.Report("Failed to write to client", iOException);
        }
        return null;
    }

    public static void DoSerializeNode(OutputStream outputStream, Request request, KB kB, String string) {
        new Export_SOAP(request).SerializeNode(outputStream, kB, string);
    }

    public static void DoSerializeCursor(OutputStream outputStream, Request request, Cursor cursor) {
        new Export_SOAP(request).SerializeCursor(outputStream, cursor);
    }

    public static void DoSerializeTree(OutputStream outputStream, Request request, KB kB, String string) {
        new Export_SOAP(request).SerializeTree(outputStream, kB, string);
    }

    public static void DoSerializeClasses(OutputStream outputStream, Request request, KB kB, String string) {
        new Export_SOAP(request).SerializeClasses(outputStream, kB, string);
    }

    public static void DoSerialize(OutputStream outputStream, Request request, KB kB) {
        new Export_SOAP(request).Serialize(outputStream, kB);
    }

    public static void SendResponse(OutputStream outputStream, Request request, Vector vector) {
        Export_SOAP export_SOAP = new Export_SOAP(request);
        Description description = request.GetProperties();
        Cursor cursor = (Cursor)vector.elementAt(0);
        if (description.HasRestriction("Identify")) {
            export_SOAP.SerializeCursor(outputStream, cursor);
            return;
        }
        String string = cursor.Next();
        if (string == null) {
            export_SOAP.toptag = "NotFound";
            export_SOAP.SerializeCursor(outputStream, cursor);
            return;
        }
        KB kB = cursor.GetKnowledgeBase();
        String string2 = cursor.Next();
        if (string2 != null) {
            export_SOAP.toptag = "Disambiguate";
            export_SOAP.StartSerialize(kB, outputStream);
            export_SOAP.SerializeOne(kB, string);
            export_SOAP.SerializeOne(kB, string2);
            String string3 = cursor.Next();
            while (string3 != null) {
                export_SOAP.SerializeOne(kB, string3);
                string3 = cursor.Next();
            }
            cursor.Release();
            export_SOAP.EndSerialize();
            return;
        }
        export_SOAP.toptag = "Data";
        export_SOAP.StartSerialize(kB, outputStream);
        Description description2 = export_SOAP.PrepareForOne(kB, string);
        int n = 0;
        Vector vector2 = description.GetRestrictionSet();
        vector.removeElementAt(0);
        n = 0;
        while (n < vector2.size() && n < vector.size()) {
            String string4;
            Restriction restriction = (Restriction)vector2.elementAt(n);
            String string5 = string4 = restriction.GetArc();
            boolean bl = restriction.IsFlagSet("inverse");
            if (Abbrev.NeedsNamespace(string5)) {
                string5 = kB.AddNamespace(string4);
            }
            if (bl || description2.HasRestriction(string5)) {
                if (bl) {
                    string5 = "!" + string5;
                }
                export_SOAP.AddArc(kB, string4, string5, (Cursor)vector.elementAt(n), description2, true);
            }
            ++n;
        }
        export_SOAP.FinishOne(description2);
        export_SOAP.EndSerialize();
    }
}

