/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Attribute;
import edu.stanford.TAP.NamespacedTag;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.XML_Leaf;
import java.util.Enumeration;
import java.util.Vector;

public class XML_Branch {
    String tag;
    String ntag;
    Vector children;
    Vector attrs;
    XML_Branch parent;
    int seq;
    boolean indentclose;

    public XML_Branch(String string) {
        this.tag = string;
        this.ntag = null;
        this.children = new Vector();
        this.attrs = new Vector();
        this.parent = null;
        this.seq = 0;
        this.indentclose = false;
    }

    public String GetTag() {
        return this.tag;
    }

    public void SetTag(String string) {
        this.tag = string;
    }

    public void AddChild(XML_Branch xML_Branch) {
        this.children.addElement(xML_Branch);
        xML_Branch.SetParent(this);
    }

    public void AddChild(XML_Leaf xML_Leaf) {
        this.children.addElement(xML_Leaf);
    }

    public void AddAttribute(String string, String string2) {
        Attribute attribute = new Attribute(string, string2);
        this.attrs.addElement(attribute);
    }

    public String FindAttribute(String string) {
        int n = 0;
        while (n < this.attrs.size()) {
            Attribute attribute = (Attribute)this.attrs.elementAt(n);
            if (attribute.name.equals(string)) {
                return attribute.value;
            }
            ++n;
        }
        return null;
    }

    public Vector GetAttributes() {
        return this.attrs;
    }

    public String FindLabel(String string) {
        int n = 0;
        while (n < this.attrs.size()) {
            Attribute attribute = (Attribute)this.attrs.elementAt(n);
            if (attribute.value.equals(string) && attribute.name.startsWith("xmlns:")) {
                return attribute.name.substring(6, attribute.name.length());
            }
            ++n;
        }
        if (this.parent != null) {
            return this.parent.FindLabel(string);
        }
        return Abbrev.GetStdLabel(string);
    }

    public String FindURL(String string) {
        String string2 = "xmlns:" + string;
        Enumeration enumeration = this.attrs.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.name.equals(string2)) continue;
            return attribute.value;
        }
        if (this.parent != null) {
            return this.parent.FindURL(string);
        }
        return null;
    }

    public String FindDefaultURL() {
        Enumeration enumeration = this.attrs.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.name.equals("xmlns")) continue;
            return attribute.value;
        }
        if (this.parent != null) {
            return this.parent.FindDefaultURL();
        }
        return null;
    }

    public int NextSequenceNumber() {
        if (this.parent != null) {
            return this.parent.NextSequenceNumber();
        }
        return this.seq++;
    }

    public String MakeDynamic(String string) {
        int n = this.NextSequenceNumber();
        String string2 = "n" + n;
        this.AddAttribute("xmlns:" + string2, string);
        return string2;
    }

    public Vector GetChildren() {
        return this.children;
    }

    public int ChildCount() {
        return this.children.size();
    }

    public XML_Branch GetParent() {
        return this.parent;
    }

    public void SetParent(XML_Branch xML_Branch) {
        this.parent = xML_Branch;
    }

    public XML_Branch FindChild(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XML_Branch xML_Branch;
            Object e = enumeration.nextElement();
            if (!(e instanceof XML_Branch) || !(xML_Branch = (XML_Branch)e).GetTag().equals(string)) continue;
            return xML_Branch;
        }
        return null;
    }

    public Object GetFirstChild() {
        if (this.children.size() > 0) {
            return this.children.elementAt(0);
        }
        return null;
    }

    public String ReplaceURL(String string) {
        String string2 = Abbrev.GetTagLabel(string);
        if (string2 != null) {
            return string2 + ":" + string;
        }
        NamespacedTag namespacedTag = XML.SplitNamespace(string);
        if (!namespacedTag.url.equals("")) {
            String string3 = this.FindLabel(namespacedTag.url);
            if (string3 == null && (string3 = Abbrev.GetStdLabel(namespacedTag.url)) == null) {
                string3 = this.MakeDynamic(namespacedTag.url);
            }
            return string3 + ":" + namespacedTag.tag;
        }
        return namespacedTag.tag;
    }

    public StringBuffer AttributesString(int n, boolean bl, StringBuffer stringBuffer) {
        Object object;
        Enumeration enumeration;
        String string = this.GetTag();
        Vector vector = Abbrev.GetStandardAttributes(string);
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                if (this.FindAttribute(((Attribute)object).name) != null) continue;
                this.AddAttribute(((Attribute)object).name, ((Attribute)object).value);
            }
        }
        enumeration = this.attrs.elements();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            ((Attribute)object).name = this.ReplaceURL(((Attribute)object).name);
        }
        object = this.attrs.elements();
        while (object.hasMoreElements()) {
            Attribute attribute = (Attribute)object.nextElement();
            if (!bl && this.attrs.size() != 1) {
                stringBuffer.append("\n");
                int n2 = 0;
                while (n2 < n + 4) {
                    stringBuffer.append(" ");
                    ++n2;
                }
            } else {
                stringBuffer.append(" ");
            }
            String string2 = XML.QuoteValue(attribute.value);
            stringBuffer.append(attribute.name);
            stringBuffer.append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        return stringBuffer;
    }

    public StringBuffer OpenString(int n, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        Object object;
        Object object2;
        this.indentclose = false;
        if (bl) {
            Object object3;
            Vector vector = Abbrev.GetStdLabels();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (this.FindURL((String)object) != null) continue;
                object3 = Abbrev.GetStdLabelURL((String)object);
                this.AddAttribute("xmlns:" + (String)object, (String)object3);
            }
            object = Abbrev.GetKBLabels();
            object3 = ((Vector)object).elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                if (this.FindURL(string) != null) continue;
                String string2 = Abbrev.GetKBURL(string);
                this.AddAttribute("xmlns:" + string, string2);
            }
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        object2 = this.GetTag();
        object = this.ReplaceURL((String)object2);
        this.ntag = ((String)object).replace(' ', '_');
        stringBuffer.append("<");
        stringBuffer.append(this.ntag);
        this.AttributesString(n, bl2, stringBuffer);
        if (bl2) {
            stringBuffer.append("/");
        } else {
            this.indentclose = true;
        }
        stringBuffer.append(">");
        return stringBuffer;
    }

    public StringBuffer ChildrenString(int n, boolean bl, StringBuffer stringBuffer) {
        if (!bl) {
            Object var4_4 = null;
            if (this.children.size() == 1) {
                var4_4 = this.children.elementAt(0);
            }
            if (var4_4 != null && var4_4 instanceof XML_Leaf) {
                XML_Leaf xML_Leaf = var4_4;
                stringBuffer.append(XML.QuoteValue(xML_Leaf.GetValue()));
                this.indentclose = false;
            } else {
                stringBuffer.append("\n");
                int n2 = n + 2;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object e = enumeration.nextElement();
                    if (e instanceof XML_Leaf) {
                        object = (XML_Leaf)e;
                        ((XML_Leaf)object).ToString(n2, stringBuffer);
                        continue;
                    }
                    if (!(e instanceof XML_Branch)) continue;
                    object = (XML_Branch)e;
                    ((XML_Branch)object).ToString(n2, false, stringBuffer);
                }
                this.indentclose = true;
            }
        }
        return stringBuffer;
    }

    public StringBuffer CloseString(int n, boolean bl, StringBuffer stringBuffer) {
        if (!bl) {
            if (n != 0 && this.indentclose) {
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(" ");
                    ++n2;
                }
            }
            stringBuffer.append("</");
            stringBuffer.append(this.ntag);
            stringBuffer.append(">");
        }
        return stringBuffer;
    }

    public StringBuffer ToString(int n, boolean bl, StringBuffer stringBuffer) {
        XML_Leaf xML_Leaf;
        Object e;
        boolean bl2;
        boolean bl3 = bl2 = this.children.size() == 0;
        if (this.children.size() == 1 && (e = this.children.elementAt(0)) instanceof XML_Leaf && (xML_Leaf = (XML_Leaf)e).GetValue().equals("")) {
            bl2 = true;
        }
        this.OpenString(n, bl, bl2, stringBuffer);
        this.ChildrenString(n, bl2, stringBuffer);
        this.CloseString(n, bl2, stringBuffer);
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public String SerializeToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        return this.ToString(n, true, stringBuffer).toString();
    }
}

