/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <string.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dir.h>
#include <libp.h>

extern int _uimodes[HANDLE_MAX],_uiflags[HANDLE_MAX], _uihandles[HANDLE_MAX] ;
extern char _uinames[HANDLE_MAX][256], _uidrives[HANDLE_MAX] ;

int sopen  (const char *__path, int __access, int __shmode, ... /*unsigned mode*/)
{
   va_list ap ;
   int __amode,handle ;
   int i,h = _uinewhandpos() ;
   if (h == -1)
      return h ;
   _uiflags[h] = 0 ;
   if (__path[1] == ':')
      _uidrives[h] = toupper(__path[0]) - 'A' ;
   else
      _uidrives[h] = getdisk() ;
   memcpy(&_uinames[h][0],__path,strlen(__path)) ;
   if (!(__access & O_BINARY | O_TEXT))
      __access = _fmode ;
   if (_ll_writeable(__path))
      _uiflags[h] |= UIF_WRITEABLE ;
   if (__access & O_CREAT) {
      handle = _ll_open(__path,_ll_uioflags(__access),_ll_shflags(__shmode) ) ;
      if (__access & O_EXCL) {
         if (handle) {
            _ll_close(handle) ;
            return -1 ;
         }
      }
      if (handle) {
         _uimodes[h] = __access ;
         _uihandles[h] = handle ;
         if (__access & O_TRUNC)
            chsize(h,0) ;
         _uiflags[h] |= UIF_EOF ;
      } else {
         handle = _ll_creat(__path,_ll_uioflags(__access),_ll_shflags(__shmode) ) ;
         if (handle == 0)
            return -1 ;
         _uimodes[h] = __access ;
         _uihandles[h] = handle ;
         if (__access & O_TRUNC)
            chsize(h,0) ;
         va_start(ap, __shmode) ;
         __amode = *(int *)ap ;
         if (!(__amode & S_IWRITE))
            _uiflags[h] |= UIF_RO ;
         _uiflags[h] |= UIF_EOF ;
         va_end(ap) ;
      }
   } else {
      handle = _ll_open(__path,_ll_uioflags(__access),_ll_shflags(__shmode)) ;
      if (handle == 0)
         return -1 ;
      _uimodes[h] = __access ;
      _uihandles[h] = handle ;
      if (__access & O_TRUNC)
         chsize(h,0) ;
   }
   if (_uimodes[handle] & O_APPEND) {
      if (lseek(h,0,SEEK_END)) {
         close(h) ;
         _uihandles[h] = -1 ;
         return -1 ;
      }
      _uiflags[h] |= UIF_EOF ;
   }
   return h ;
}