import sys
import os

# this script must be called from the ctocpp directory
# param 1 is the name of main c file
# param 2 is the name of the project with path without extension, without @


def main():

 
 if (len(sys.argv) < 3):
  print "This batch file requires 2 parameters..."
  print "Usage:  ctocpp mainfile project"
  print "        mainfile: the main c source file (holds 'main') with full path"
  print "        project:  the name of the project with the full path"
  print "                  without extension nor @ prefix"
  sys.exit(1)

 mainfile = sys.argv[1]
 a2 = sys.argv[2]
 project = a2 + ".prj"
 hproj = a2 + ".hpj"
 listfile = "@" + project
 listheader = "@" + hproj
 

 # Making the list of c files
 os.system("python mklist.py " + mainfile + " " + project)

 # Building or correcting header files
 os.system("python mkheader.py " + listfile  + " hpp")

 # Converting headers into class files
 os.system("python mkclass.py " + listfile)

 # Making the list of all hpp files
 os.system("python allhead.py " + mainfile + " " + hproj)

 # Converting functions into methods
 os.system("python mkcpp.py " + listfile + " " + listheader)

 return 0

main()