/*
**  CFINGR.C
**
**  Synchronous FINGER program.
**  Win32 console program.
**
**  FINGER program comparison
**
**    (1) AFINGR -- asyncronous version.
**    (2) BFINGR -- asyncronous version (using ASYNC.C functions).
**    (3) SFINGR -- synchronous version.
**    (4) CFINGR -- synchronous version (Win32 CONSOLE program).
**    (5) FINGER -- state driven version.
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR  50
#define MAX_BUF 256

#define FINGER_PORT 79

static char Temp[MAX_BUF+8];
static int  InBufLen = 0;
static char InBuffer[MAX_BUF+1];
static char UserName[MAX_STR] = "";
static char HostName[MAX_STR] = "";
static SOCKET Socket = 0;
static ULONG  HostAddr = 0;
static LPSTR  Ptr;

static HANDLE ConIn;
static HANDLE ConOut;
static DWORD OldMode;
static DWORD NewMode;

/* display error */

static void DisplayError(HANDLE Handle, int Code, LPSTR Msg)
{PutString(Handle ,"ERROR: ");
 if(Msg) PutString(Handle,Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    PutLine(Handle,(LPSTR)Temp);
   }
}

/* display error & exit (before calling wilAttach) */

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{PutLine(ConOut,"Shutting down...");
 wilRelease();
 SetConsoleMode(ConIn, OldMode);
 exit(0);
}

/*** main ***/

void main(void)
{char c;
 int  Code;
 BOOL  Success;
 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* attach WINSOCK */
 PutString(ConOut,"Attaching WINSOCK...");
 Code = wilAttach();
 PutLine(ConOut,"OK");
 if(Code<0) DisplayError(ConOut,Code,"wilAttach fails:");
 else
   {PutString(ConOut," Description: ");
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
    PutString(ConOut,"My Host Name: ");
    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
    PutString(ConOut,"My Host Addr: ");
    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
   }
 /* get next finger request from user */
 while(TRUE)
   {InBufLen = 0;
    PutLine(ConOut,"\r\nFinger Client: Type CTRL-Z to quit");
    PutString(ConOut,"Enter user@host: ");
    /* get response */
    while(TRUE)
      {/* fetch & echo character */
       c = GetChar(ConIn);
       PutChar(ConOut,c);
       /* did user type ESC ? */
       if(c==0x1b)
         {InBufLen = 0;
          PutString(ConOut,"\r\n");
          continue;
         }
       /* did user type CTRL-Z */
       if(c==0x1a) ShutDown();
       /* programmer note: need to handle BS here */
       if(c=='\r')
         {/* user has completed input */
          if(InBufLen==0) ShutDown();
          PutChar(ConOut,'\n');
          InBuffer[InBufLen++] = '\0';
          /* execute command */
          wsprintf((LPSTR)Temp,"\r\nUser@Host: %s",(LPSTR)InBuffer);
          PutLine(ConOut,(LPSTR)Temp);
          /* extract user & host names */
          Ptr = StringChar((LPSTR)InBuffer,'@');
          if(Ptr==NULL)
            {DisplayError(ConOut, Code, "Cannot recognize User@Host");
             break;
            }
          *Ptr = '\0';
          lstrcpy((LPSTR)UserName, (LPSTR)InBuffer);
          lstrcpy((LPSTR)HostName, (LPSTR)(++Ptr));
          wsprintf((LPSTR)Temp,"User ='%s'", (LPSTR)UserName);
          PutLine(ConOut,Temp);
          wsprintf((LPSTR)Temp,"Host ='%s'", (LPSTR)HostName);
          PutLine(ConOut,Temp);
          /* get host name */
          if(wilIsDotted((LPSTR)HostName))
            {/* already have IP address */
             HostAddr = wilMakeAddr((LPSTR)HostName);
            }
          else
            {/* ask DNS for IP address */
             HostAddr = wilGetHostAddr((LPSTR)HostName,0);
             if(HostAddr==0)
               {DisplayError(ConOut, 0, "Cannot get IP addess");
                break;
               }
            }
          /* display remote host address */
          PutString(ConOut,"HostAddr = ");
          wilMakeDotted(HostAddr,(LPSTR)Temp,MAX_BUF);
          PutLine(ConOut,(LPSTR)Temp);
          /* create socket */
          Socket = wilTcpSocket();
          if((int)Socket<0)
            {DisplayError(ConOut, (int)Code, NULL);
             break;
            }
          /* attempt to connect to remote host */
          Code = wilConnect(Socket,HostAddr,FINGER_PORT);
          if(Code<0)
            {DisplayError(ConOut, Code, NULL);
             break;
            }
          /* wait up to 30 seconds for connection */
          if(wilIsConnected(Socket,30000)) PutLine(ConOut,"Connected to FINGER server.");
          else
            {DisplayError(ConOut,0, "Cannot CONNECT");
             break;
            }
          /* send user name */
          wsprintf((LPSTR)Temp,"%s\r\n",(LPSTR)UserName);
          Code = wilWriteString(Socket,(LPSTR)Temp);
          if(Code<0)
            {DisplayError(ConOut, Code, NULL);
             break;
            }
          /* read socket */
          while(1)
            {Sleep(0);
             /* wait for incoming */
             wilDataIsReady(Socket,1000);
             /* read next string */
             Code = wilReadLine(Socket,(LPSTR)InBuffer,MAX_BUF);
             if(Code==WIL_EOF) break;
             if(Code<0)
               {DisplayError(ConOut,Code,"wilReadLine:");
                break;
               }
             if(Code>0)
               {wsprintf((LPSTR)Temp,"%s", (LPSTR)InBuffer);
                PutString(ConOut,(LPSTR)Temp);
               }
            } /*end-while(1)*/
          ///PutLine(ConOut,"\r\nFINGER completed.");
          wilCloseSocket(Socket,500);
          break;
         }
       else
         {/* add character to buffer */
          if(InBufLen<MAX_BUF) InBuffer[InBufLen++] = c;
         }
      } /* end-while(TRUE) */
   } /* end-while(TRUE) */
} /* end main */


