<HTML>
<HEAD>
<TITLE></TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-family: "Courrier New", Courrier, mono, Monospaced, Arial }
 .toc { font-family: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3  { font-size: 18pt; color: #333399 }
 H4  { font-size: 16pt; color: #333399 }
 H5  { font-size: 14pt; color: #333399 }
 H6  { font-size: 12pt; color: #333399 }
 H7  { font-size: 11pt; color: #333399 }
 PRE { font-size: "14pt"; font-family: "Courrier New", Courrier, mono, Monospaced, Arial;  color: "#000000" }
 A:link { text-decoration: none; color: #0000cc }
 A:visited { text-decoration: none; color: #0000ff }
 A:hover { text-decoration: none; color: #ff00ff }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_vars.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_vars.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_array.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_array.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_struc.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_struc.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_vars.php" target="_self">V Constants & variables</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_struc.php" target="_self">VII Control structures</a>

<h3><a name="title0"></a>
VI Arrays and dict</h3> <pre>

 The first artificial intelligence language, Lisp, was fully based on dynamic
list processing. This lets to understand how useful are lists in programming.
Lists are more powerful in Scriptol as they are associatives data structures.
But all the features of Lisp are implemented, and two types of list are
distinguished:
 Array: a dynamic list of objects, whose keys are integers.
 Dict:  a dynamic list of objects, whose keys are texts.
 Here we will study the power of lists, starting with arrays.

</pre>
<h4><a name="title1"></a>
  What is an array?</h4> <pre>

 The advantage of arrays is that it is possible to scan their content by
incrementing an integer variable. They don't work as C++ or Java arrays, the
order of the content is the order they are filled until a sort() or arrange()
method is called. They are dynamic and that means the size is not predefined nor
limited. They are associative and even if an array contains only three value, a
statement as a[1000] adds an element with the indice 1000!

 Example to demonstrate how the are filled...
 Declare an array and type these statements:
 a[2] = "two"
 a[1] = "one"
 a[500] = "last one"
 Type a.display() to view the content, it is displayed as that:
 array(
  [2] => two
  [1] => one
  [500] => last one
 )
 We well see further how these indices may be changed.

</pre>
<h4><a name="title2"></a>
  Declaration</h4> <pre>

 As any object in Scriptol, an array is so declared:
 array a

 The array initializer has the form:
 array(value, value, etc...)
 An empty initializer is written:
 array()

 In some case, the word array is useless and may be omitted, as it is easy for
the compiler to recognize an array initializer. This is the case for an empty
initializer or if it has two elements at least...
 Thus, you can write:
array a = array()
array a = ()       ...this is valid too
array a = array(1, 2)
array a = (1, 2)   ...valid too

 But is it valid with a sole element? Perhaps...
array a = (1)
is recognized by the compiler because it is obvious that you want to assign an
array. Inside en expression, x + (1) for example this is not the case and if you
write this statement:
a = (1)
the parser throws an error message.

</pre>
<h4><a name="title3"></a>
  Adding an item</h4> <pre>

 Once the array is created, you can perform various list processing...
a.push("item")     add an element at end of the list.
a.unshift("item")  add an element at begin of the list.
a.pop()            read and remove the last element.
a.shift()          read and remove the first element.

 You can so read and eliminate the elements of an array by successive such
statements:
 print a.shift()

</pre>
<h4><a name="title4"></a>
  Operators on array</h4> <pre>

 An item, or a group of item may be added or removed with the + and - operator.
 Example:
 array a = ("one", "two")
 array b
 b = a + ("three", "four")
 now the content b is four elements.
 a = b - ("one", "four")
 now the content of a is: ("two", "four").

 Only the + and - operator are usable on arrays. The *, / etc... have no sense.
But there is a special operator very useful too, this is the "in" operator.

</pre>
<h4><a name="title5"></a>
  The "in" operator</h4> <pre>

 This special operator may be used to test if a value is contained inside a list
(array, dict or even a text), and to scan the content too.

 The syntax is:
   if variable in array
 Example:
   if x in a :   print "inside";  /if
   if x in (1,2,3) : print "inside"; /if

 To scan the array, the syntax is:
   for variable in array
 Example:
   for x in a
     print x
   /for
 Example:
   for t in ("one", "two", "three")
     print t
   /for

</pre>
<h4><a name="title6"></a>
  Other operators on lists: intersection and union</h4> <pre>

 There are also operator usable only with dynamic lists (array or dict).
   #   intersection
   ||  union
 The intersection of two lists returns only elements that are parts of both the
two lists.
 Example:
   a = (1,2,3,4) # (3,4,5,6)
 assigns (3, 4) to a.

 The union of two lists is a new list made of the elements of the first one,
plus those of the second one minus those that are already part of the first one.
 Example:
 a = (1,2,3,4) || (3,4,5,6)
 assigns (1,2,3,4,5,6) to a.

 With these powerful operators in the pocket, you can easily perform such big
operation, as testing if a list if a part of another list with just one
statement...
 a and b are two arrays. This statement returns true if a is a part of b:
 if (a # b) = a :
 An example in the "fcat.sol" script.

</pre>
<h4><a name="title7"></a>
  Accessing a value</h4> <pre>

 Each element of an array may be accessed by an integer key.
 Examples:
 a[1]
 a[x]
 a[10 + x / 2]
 The indice may be any expression that evaluate to an integer. The expression
doesn't embed another indexing.
 For example:
 a[10 + b[5]]  is not valid.

 The indice used to retrieve an element is not necessary the one used when
entering the data. Several functions or operations can reorder or renumber the
element...
 Scriptol allows to scan an array and access a value without to know its integer
key, thanks to the empty indice [] that returns the currently pointed out
element.
 Example:
 scan a
  print a[]
 /scan
 The scan control structure points out each element successively and the []
indice designates the current one.
 We can also scan the array by the builtin iterator.

</pre>
<h4><a name="title8"></a>
  Iterator</h4> <pre>

 The iterator is a set of functions to access sequentially the elements of a
list, in ascending or descending order.
 begin()     points out the first element and returns it.
 end()       points out the last element and returns it.
 inc()       moves to the next element.
             Return the value or nil beyond the last one.
 dec()       moves to the previous element. Returns the value or nil.
 index()     returns the index of the pointed out element.
 value()     returns the value of the pointed out element.
 []          indice of the current element.
 nil         means for "not in list" and is returned by various functions
             when no value may be returned.

 Example of use
 a is an array you want to display.
 a.begin()                 ` move to the first element
 while a[] <> nil          ` test if end of list reached
   print a[]               ` print the currently pointed out element
   a.inc()                 ` move to next element
 /while

 In reverse order:
 a.end()
 while a[] <> nil
   print a[]
   a.dec()
 /while


</pre>
<h4><a name="title9"></a>
  Other operations on arrays</h4> <pre>

 You want to search the object y inside the array a.
 dyn x = a.find(y)
 If y is not found, the value of x will be "nil".
 Nil comes from the List language and means the element is not in a list.

 If you want to remove an item at position k in an array, type:
 a[k] = nil.

 To insert the value v at indice n, type: a.insert(n, v).
 You can sort either the values: a.sort() or the keys: a.kSort() in an array.

</pre>
<h4><a name="title10"></a>
  Loading a file in an array</h4> <pre>

 A file may be loaded into an array with a single function:
   a.load("filename")
 Each line of the file becomes an element of the array. The end of line codes
remain at end of line if they are presents (codes 10 and 13).
 In the chapter on the scan method, this control structure will be studied in
depth. For the moment, without to try to understand the syntax, know that you
can view the content of a file with only two statements:
 a.load("fcat.sol")
 scan a ? print a[]

</pre>
<h4><a name="title11"></a>
  What is a dict?</h4> <pre>

 A dict is a dynamic associative list whose keys are texts. With a dict, you can
store words as keys and definitions as value, and retrieve its definition for a
word.
 Example:
 dict d
 d["program"] = "what we want to write faster"
 print d["program"] should display:
 what we want to write faster

</pre>
<h4><a name="title12"></a>
  Initializing a dict</h4> <pre>

 The initializer is a set of couple "key : value" enclosed in parenthesis.
The prefix is always optional as the compiler can recognize a dict even if it is
a single element.
 Examples:
 dict d
 d = ("a" : "first", "b" = 2, etc...
 d = ("a": 1)
 The values stored may be any kind of object.
 The key can be a declared variable and the value any expression.
 Example:
 text k = "a"
 text v = "b"
 dict d = (k : v)
 dict d = (k, v + "x".dup(4) + 20.toText())
 This example stores "bxxxx20" into the dict d, with the key "a".

 An empty dict is created with this statement:
 dict d = ()
 It may be filled as array but with texts for keys:
 d[k] = "b"
 d["first"] = "element 1"

</pre>
<h4><a name="title13"></a>
  About ranges</h4> <pre>

 Now, we afford one of the most powerful features of Scriptol, the ranges.
 Ranges are used only by old classical languages in the "for" control structure,
and in other modern languages, they may be used with different syntaxes
according to the context. In Scriptol the concept is unified and the same
syntax is used for any kind of range, this is a couple of indices linked by two
points: start .. end.
 Examples:
 0..10
 x..y
 x * 2 / 4 .. y + 10
 and so ones.
 You can write also: [x..] that means: from x to the end, and [..y] that means:
from the begin to y.

 You may use range to test if a value is inside a list:
 if x in 10..100
 You may use it to scan a list:
 for x in 1..100
 You may extract a part of a list:
 array b = a[x..y]
 And finally, you may change a part of a list:
 a[x..y] = another list

 Here, we will study only subscripting of array or dict. As we have not to deal
with the keys but only with positions inside the lists, the syntax is the name.

 Creating a list:
 array a = (x0, x1, x2, x3, x4, x5, x6, x7, x8)
 Splitting the list into three ones:
 array b = a[..2]
 array c = a[3..5]
 array d = a[6..]
 Now we should have three arrays, with these contents:
 a:   (x0, x1, x2)
 b:   (x3, x4, x5)
 c:   (x6, x7, x8)
 Displaying the arrays:
 b.display()
 c.display()
 d.display()
 You should see:
 array (
   [0] => x0
   [1] => x1
   [2] => x2
 )
 and so one...

 To replace an interval by another list, a simple assignment is required:
a[3..5] = ("a", "b", "c")
 The content should become: (x0, x1, x2, "a", "b", "c", x6, x7, x8)

 A sublist may be replaced either by another list, or by a single value, the
syntax is the same:  a[3..5] = "xyz"
 The original list become: (x0, x1, x2, "xyz", x6, x7, x8)

 If we want rather to remove a sub-list from the original array, we have to
declare it "not in list" and the syntax is simply: a[3..5] = nil
 As we have removed the sub-list 3..5 that is (x3, x4, x5), the content now
becomes:
 (x0, x1, x2, x6, x7, x8)

 In the same manner we can test if a value is inside a list, we can perform the
test on a sub-list, for example:
 array a = ("one, "two", "three")
 if "two" in a[2..5] ? print "inside"

 We have sawn above how to test if a list is a part of another one, thanks to
the # operator. We can perform the same with sub-lists:
 array asub = a[2..3]
 if (asub # b[6..8]) = asub) ? print "inside"

</pre>
<h4><a name="title14"></a>
  Content of array, step by step</h4> <pre>

 Now we will study how the integer keys of array change, according to all
operations we can perform. This is important to understand and will avoid to
you lot of bugs.
 After each operation, the content is displayed.

 array a = ()
 array
 (
 )

 a.push("one")
 array
 (
  [0]=> one
 )

 a + ("two", "three", "four")
 array
 (
  [0]=> one
  [1]=> two
  [2]=> three
  [3]=> four
 )

 a.shift()
 Keys are renumbered.
 array
 (
  [0]=> two
  [1]=> three
  [2]=> four
 )

 a[1000] = "thousand"
 array
 (
  [0]=> one
  [1]=> two
  [2]=> four
  [1000]=> thousand
 )

 a.unshift("x")
 All keys are renumbered, even the 1000 one.
 array
 (
  [0]=> x
  [1]=> two
  [2]=> three
  [3]=> four
  [4]=> thousand
 )

 array a = ("one","two")
 array b = ()
 b[1000] = "thousand"
 a + b
 array
 (
  [0]=> one
  [1]=> two
  [2]=> thousand
 )
 If we replace a + b by a.push("thousand") the result will be the same.

 Retain the lesson:
 Any change in an array results in a renumbering of keys, but the direct
assignment in the form: a[key] = value

</pre>
<h4><a name="title15"></a>
  Conclusion on dynamic lists</h4> <pre>

 Apart the type of keys, integer for array, text for dict, that allows to scan
the first one by incrementing an index, and to use the second one as dictionnary,
array and dict are similar, and they the target Php code does not difference.
 You can use a list as a stack, by pushing and poping elements. Or performing
list processing as in Lisp, by adding, splitting, shifting the first element. Or
using them as sets, with the powerful operators of intersection and union,
getting the min, the max, the sum of elements. The power of lists is unlimited,
and you will can increase it again by using them along with the new control
structures designed in Scriptol.

</pre>
<br><br><table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_vars.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_vars.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_array.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_array.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_struc.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_struc.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_vars.php" target="_self">V Constants & variables</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_struc.php" target="_self">VII Control structures</a>
</BODY>
</HTML>
