
/*
  SCRIPTOL LIBRARY
  (c) 2002 by Denis G. Sureau
  http://www.scriptol.com
  http://www.scriptol.net

GENERAL PUBLIC LICENCE

Along with the free Scriptol to native compiler is
provided the libsol.a library. The library contains
the TEXT, DYN and ARRAY classes and lot of functions
compatibles with the Php library.
This library is the orginal work of Denis G. Sureau.
It has been registered at INPI 25 june 2002.
The Php compatible functions are original work. They
have nothing to do with Php sources.
The source of the library is furnished to registered
user of the compiler, enterprise edition.

The library is provided to allow the user to link it
with its Scriptol compiled program. He is allowed to
include the library in its program and distribute its
programs with the library included into, with no any
fee required and no any restriction or condition.

He is not allowed to distribute the library as it but
in the case of an open-source program. The library may
be included unchanged among other files of the open
source distribution and headers of the file to include,
libsol.hpp, text.hpp, dyn.hpp, array.hpp, fun.hpp and
other files, must be included unchanged, and must hold
my name and the address of the Scriptol site.

The source of the library is provided to licensed users
to allow them either to modify it according to their need,
or to compile it in a different file format, for a different
compiler. The registered user is not permitted to
distribute the source of the library in no any case, even
if is is modified.
*/



#ifndef _SOL_TEXT
#define _SOL_TEXT


class text
{
 public:
 int len;
 char *data;

 text *op;

 text();
 text(const char *);
 text(const text &);
 text(text *);
 text(char);
 text(int);
 text(double);
 text(bool);
 ~text();

 void set(text *);
 void set(const text &);
 void set(const char *);
 void set(int);
 void set(double);
 void set(bool);
 void set(char);

 inline int length() { return len; }
 inline int empty()  { return len == 0; }

 text upper();
 text lower();
 text capitalize();

 void cat(const char *);
// void cat(const text &);

 bool in(const char *);
 bool in(const text &);
 int find(const char *);
 int find(const char *, int);
// int find(const text &);

 void replace(const char *, const char *);

 void insert(int, const char *);

 text slice(int, int, int);
 char * substr(int, int);      // as slice, return char pointer
 char * substr(int);

 void splice(int, int, const char*, int);
 inline void splice(int a, int b, text t, int i) { splice(a,b,t.data, i); }

 text rTrim();
 text lTrim();
 text trim();

 void fill(const char *, int);
 text dup(int);

 int compare(const char *);
 int identical(const char *);

 int toInt();
 int toInteger();
 double toNumber();
 inline double toReal()     { return toNumber(); }
 inline char *toStr()       { return data; }
 inline const char *c_str() { return (const char *) data; }

 text wrap();

 bool isNumber();
 static bool isNumber(const char *);

 bool operator==(const text &);
 bool operator!=(const text &);
 bool operator<=(const text &);
 bool operator>=(const text &);
 bool operator<(const text &);
 bool operator>(const text &);
 bool operator!();
 bool operator==(const char *);
 bool operator!=(const char *);
 bool operator<=(const char *);
 bool operator>=(const char *);
 bool operator<(const char *);
 bool operator>(const char *);

 bool operator==(bool);
 bool operator!=(bool);

 void operator=(const text &);
 void operator=(const char *);
 text operator+(const text &);
 text operator+(const char *);
 void operator+=(const text &);
 void operator+=(const char *);
 text &operator[](int);
 void setAt(int, const text &);
 text operator*(int);

};

ostream& operator<< (ostream&, text);
ostream& operator<< (ostream&, text *);

template<class ANY> bool operator==(ANY a, text b) { return b == a; }
template<class ANY> bool operator!=(ANY a, text b) { return b != a; }
template<class ANY> bool operator<=(ANY a, text b) { return b > a; }
template<class ANY> bool operator>=(ANY a, text b) { return b < a; }
template<class ANY> bool operator<(ANY a, text b)  { return b > a; }
template<class ANY> bool operator>(ANY a, text b)  { return b < a; }
template<class ANY> text operator+(ANY a, text b)  { return text(a) + b; }
template<class ANY> text operator-(ANY a, text b)  { return text(a) - b; }
template<class ANY> void operator+=(ANY a, text b) { return text(a) += b; }
template<class ANY> void operator-=(ANY a, text b) { return text(a) -= b; }

#endif
