// gksPolygon.cpp : implementation of the CgksPolygon class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "OzGKS.h"
#include "gksLine.h"
#include "gksPolygon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



CgksPolygon::CgksPolygon(float* x, float* y, int num, 
				  int FillType, int FillColour, int BoundaryColour,
				  BOOL DoBoundary) :
	CgksLine(x, y, num, 1, 1, BoundaryColour)
{

	if (DoBoundary)
		m_lineType = PS_SOLID;
	else
		m_lineType = PS_NULL;
	m_objType = gksPolygon;
	m_fillType = FillType;
	m_fillColour = FillColour;
	m_minNum = 3;

}

// draw on screen.

BOOL CgksPolygon::Draw(CDC* pDC)
{
	GKSpen(pDC, m_lineType, m_lineWidth, m_lineColour);
	GKSbrush(pDC, m_fillType, m_fillColour);
	pDC->Polygon(m_screenPoint.GetData(), m_screenPoint.GetSize());

	return TRUE;
}


// update attributes

void CgksPolygon::Attributes(int FillColour)
{
		m_fillColour = FillColour;
}
