
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: polynom.h,v 1.6 1998/08/29 10:22:54 stes Exp $
 */

#ifndef __CAPOLYNOMIAL_HEADER__
#define __CAPOLYNOMIAL_HEADER__

#include "cobject.h"

@interface Polynomial : CAObject
{
  id scalarZero;
  id termZero;
  id monomialZero;
  id carrier;
  id _symbols;
  id _variables;
  id _zero;
  id _one;
  id _leadingTerm;
  id _leadingMonomial;
}

+ scalar:aScalar;
- copy;
- deepCopy;
- clear;
- empty;

- scalarZero;
- termZero;
- monomialZero;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) isRecursive;
- (BOOL) isExpanded;
- (BOOL) isVariableSparse;
- (BOOL) isVariableDense;
- (BOOL) isDegreeDense;
- (BOOL) isDegreeSparse;
- (BOOL) isUnivariate;
- (BOOL) inUnivariateDomain;
- (BOOL) isMultivariate;

- (int) intValue;
- intValue:(int)aValue;
- (float) floatValue;
- floatValue:(float)aValue;
- asScalar;
- asSymbol;
- asTerm;
- asMonomial;
- asCoefficient;
- asNumerical;
- asModp:(unsigned short)p;

- symbols;

- (int) degree;
- (int) order;

- (int) numTerms;
- (int) numMonomials;

- removeTerm;
- insertTerm:aTerm;
- removeMonomial;
- insertMonomial:aMonomial;

- eachTerm;
- eachMonomial;
- eachSequence;
- eachScalar;
- eachCoefficient;

- makeDegreeDense;
- makeDegreeSparse;
- makeRecursive;
- makeExpanded;
- makeVariableSparse;
- makeVariableDense;
- collect:symbols;

- leadingTerm;
- leadingCoefficient;
- (int) leadingSign;
- leadingMonomial;
- leadingScalar;

- (BOOL) isMonic;
- (BOOL) notMonic;
- makeMonic;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;
- addScalar:s;
- subtractScalar:s;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- multiply:b;
- square;
- inverse;
- multiplyScalar:s;
- divideScalar:s;
- multiplyCoefficient:aCoefficient;
- divideCoefficient:aCoefficient;
- multiplyTerm:aTerm;
- divideTerm:aTerm;
- multiplyMonomial:s;
- divideMonomial:s;

- remainder:b quotient:(id *)q;
- divide:b;

- pseudoRemainder:b quotient:(id *)q;
- pseudoRemainder:b;

- content;
- divideContent;
- coefficientContent;
- divideCoefficientContent;
- termContent;
- monomialContent;

- gcd:b;
- resultant:b;
- resultant:b wrt:(STR)aSymbol;
- discriminant;

- (int) numRealRoots;
- (int) varRealRoots:g;

- (BOOL) isSquareFree;
- factorSquareFree;

- truncateAtDegree:(int)d;

- frobenius;
- frobeniusInverse;

- evaluate:aScalar;
- evaluate:(STR)aSymbol at:aScalar;
- evaluateAll:cltnOfScalars;
- substitute:aPolynomial;
- substitute:(STR)aSymbol by:aPolynomial;
- substituteAll:cltnOfPolynomials;

- derive;
- deriveWrt:(STR)aSymbol;
- integrate;
- integrateWrt:(STR)aSymbol;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif				/* __CAPOLYNOMIAL_HEADER__ */

