// MiniFTP copyright 1997 Paul Gerhart pgerhart@voicenet.com
// ChoosDir.cpp : implementation file

#include "stdafx.h"
#include "miniftp.h"  // the app's .h file
#include <direct.h>
#include <dlgs.h>
#include "ChoosDir.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChooseDir

IMPLEMENT_DYNAMIC(CChooseDir, CFileDialog)

CChooseDir::CChooseDir(BOOL bOpenFileDialog, LPCTSTR lpszDefExt,
                        LPCTSTR lpszFileName, DWORD dwFlags, LPCTSTR lpszFilter, 
                        CWnd* pParentWnd) :
                        CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, 
                        dwFlags |= OFN_ENABLETEMPLATE, lpszFilter, pParentWnd)
{
    m_ofn.hInstance = AfxGetResourceHandle();
    m_ofn.lpTemplateName = MAKEINTRESOURCE(CChooseDir::IDD);

    m_ofn.Flags &= ~OFN_EXPLORER;           // Lose this for VC1.52c

    //{{AFX_DATA_INIT(CChooseDir)
	//}}AFX_DATA_INIT
}

void CChooseDir::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CChooseDir)
    DDX_Control(pDX, IDC_DIRNAME, m_CtrlDirName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CChooseDir, CFileDialog)
    //{{AFX_MSG_MAP(CChooseDir)
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
BOOL CChooseDir::OnInitDialog() 
{
	CString sTemp;

	CenterWindow();

	GetDlgItem(stc2)->ShowWindow(SW_HIDE);
	GetDlgItem(stc3)->ShowWindow(SW_HIDE);
	GetDlgItem(edt1)->ShowWindow(SW_HIDE);
	GetDlgItem(lst1)->ShowWindow(SW_HIDE);
	GetDlgItem(cmb1)->ShowWindow(SW_HIDE);
	GetDlgItem(stc1)->ShowWindow(SW_HIDE);
	GetDlgItem(chx1)->ShowWindow(SW_HIDE);  // Read only... don't have to hide this one
											// could rely onOFN_HIDEREADONLY

	GetDlgItem(psh15)->EnableWindow(FALSE); // I disable the help button

	SetDlgItemText(edt1, "Junk");

	// Need to fill in my edit control (IDC_DIRNAME)
        
    CListBox* pList = (CListBox*)GetDlgItem(lst2);
    int iIndex = pList->GetCurSel();

    m_sDirName.Empty();
    
    if (iIndex != LB_ERR)
	{
        pList->GetText(iIndex, sTemp);

        for (int i = 0; i <= iIndex; i++)
        {
			pList->GetText(i, sTemp);

			if (i > 1)
			{
				m_sDirName += "\\";
				m_sDirName += sTemp;
			}
			else
			{
				m_sDirName += sTemp;
			}
		}
		// I commented this out
        //m_sDirName.MakeUpper();      
		((CEdit*)GetDlgItem(IDC_DIRNAME))->SetWindowText(m_sDirName);
	}

    GetDlgItem(lst2)->SetFocus();
    m_bDlgJustCameUp = TRUE;
    CFileDialog::OnInitDialog();
    
    return FALSE;  // return TRUE unless you set the focus to acontrol
                  // EXCEPTION: OCX Property Pages should returnFALSE
}

/////////////////////////////////////////////////////////////////////////////
void CChooseDir::OnPaint() 
{
    CPaintDC dc(this); // device context for painting
    
    if (m_bDlgJustCameUp)
    {
		m_bDlgJustCameUp = FALSE;
		SendDlgItemMessage(lst2, LB_SETCURSEL, 0, 0L);
    }
    
    // Do not call CFileDialog::OnPaint() for painting messages
}

/////////////////////////////////////////////////////////////////////////////
void CChooseDir::OnLBSelChangedNotify(UINT nIDBox, UINT iCurSel, UINT nCode)
{
    CString sTemp;
    int i;

    CListBox* pList = (CListBox*)GetDlgItem(lst2);
    int iIndex = pList->GetCurSel();
    m_sDirName.Empty();
    
    if (iIndex != LB_ERR)
    {
		pList->GetText(iIndex, sTemp);

		for (i = 0; i <= iIndex; i++)
		{
			pList->GetText(i, sTemp);

			if (i > 1)
			{
				m_sDirName += "\\";
				m_sDirName += sTemp;
			}
			else
			{
				m_sDirName += sTemp;
			}
		}
    	((CEdit*)GetDlgItem(IDC_DIRNAME))->SetWindowText(m_sDirName);
    }
}

/////////////////////////////////////////////////////////////////////////////
BOOL CChooseDir::OnFileNameOK(void)
{
    CString sDrive;
    CString sMessage;
    int iResult;

    m_CtrlDirName.GetWindowText(m_sDirName);
    sDrive = m_sDirName.Left(3);

    // I do a basic check for Win3.11 DOS file name compatibility
    // This is set up for Win.311.
	//			To set it for Win95 change it to:
     iResult = m_sDirName.FindOneOf("*?|/<>\"");         // Win95        

    //iResult = m_sDirName.FindOneOf("*?|/<> .[]^+\"");      // Win 3.11

    if (iResult >= 0)
    {
		sMessage.Format("%s is not a valid pathname.", m_sDirName);
		AfxMessageBox(sMessage, MB_OK);
		return TRUE;
    }

	if (_chdir(m_sDirName))
    {
    sMessage.Format("Directory %s does not exist.\nCreate this directory?", 
						m_sDirName);
    iResult = AfxMessageBox(sMessage, MB_YESNO);

    if (iResult == IDYES)
    {
		// Create the new directory:
    
		iResult = _mkdir(m_sDirName);
		if (iResult)
		{
			sMessage.Format("There was a problem creating %s.\n"
				"The new directory was not created.", m_sDirName);
			AfxMessageBox(sMessage, MB_OK);
			return TRUE;
		}
    }
    else
	{
		return TRUE;
	}

    char szBuffer[MAX_PATH];
    sMessage = m_sDirName + "\\" + m_ofn.lpstrFileTitle;
    strcpy (szBuffer, (const char *)sMessage);
    strcpy(m_ofn.lpstrFile, szBuffer);

    m_pofnTemp->nFileOffset = m_sDirName.GetLength() + 1; // For 32bit
    m_pofnTemp->nFileExtension = sMessage.GetLength();     //For 32bit

    // For VC 1.52c change m_pofnTemp-> to m_ofn. in the above 2 lines:

    // m_ofn.nFileOffset = m_sDirName.GetLength() + 1;     // For 16bit
    // m_ofn.nFileExtension = szMessage.GetLength();        // For 16bit

    }
	return FALSE;
}

