/*
 *    File fontview.cpp
 *      Demonstrates the Font loading technique
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

#if defined __GNUC__ && !defined __RSXNT__
#define stricmp strcasecmp
#endif

class CaFontView : public CmCallback {
	CmShell *shell;
	CmDrawArea *drawa;
	CmOptionEdit *e_fname;
	CmEditField *e_fsize;

	CmFont *font;
	int bold;
	int italic;
public:
	CaFontView(void);
	virtual ~CaFontView(void);
	void setBold(int on_off) { bold = on_off; }
	void setItalic(int on_off) { italic = on_off; }
	void showFont(void);
	MTFont getFont(void) { return *font; }
	void closeDialog(void) { delete this; };
};

class CaShowFont : public CmDrawArea {
	CaFontView *owner;
public:
	CaShowFont(CaFontView *o, CmContainer *parent, int w, int h)
		: CmDrawArea(parent, w, h), owner(o) {};

	void onExpose(MEvent *pe);
};

/***************************************************************
 *	This callback tries to load the specified font
 ***************************************************************/
void CaFontView::
showFont(void)
{
    int size;
    char family[32];
    char buff[8];
/*
 * Get user preferences from the EDIT Objects
 */
    e_fname->getText(family);
    e_fsize->getText(buff);
    size = atoi(buff);
    delete font;
    font = new CmFont(family, size, bold, italic);
/*
 * The FIXED_MEDIUM font is returned on failure
 */
    if (MTFont(*font) != FIXED_MEDIUM)
	drawa->redraw();
    else
	MBeep();
}

/***************************************************************
 *	This callback draws strings using the selected font
 ***************************************************************/
void CaShowFont::
onExpose(MEvent *)
{
    drawText(0, 0, getWidth(), getHeight() / 2,
	      "AaBbCcDdEeFfGgHhIiJjKkLlMm",
	      owner->getFont(), black, CENTER_ALIGN);
    drawText(0, getHeight() / 2, getWidth(), getHeight() / 2,
	      "NnOoPpQqRrSsTtUuWwYyXxZz",
	      owner->getFont(), black, CENTER_ALIGN);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
CaFontView::
CaFontView(void)
{
    CmForm *form;
    CmSFile *sfile;
    CmAbsList *list;
    CmToggleButton *tb;
    CmPushButton *pb;
    const char *family;

    font = new CmFont(DEFAULT_FONT);
    bold = 0;
    italic = 0;

    shell = new CmShell("Font Browser", SF_MODAL);
	shell->setWMCloseCallback(this, (VOID_CB)&CaFontView::closeDialog);

    form = new CmColForm(shell);

/*
 * The Option Edit contains the known font families
 */
    family = CmFont::getFirstFamily();
    e_fname = new CmOptionEdit(form, family, 32, 32, 8, FIXED_MEDIUM);
    list = e_fname->getSList();
    list->setSortCallback(stricmp);
    while (family)
    {
	list->addItem(family, 0L);
	family = CmFont::getNextFamily();
    }

    e_fsize = new CmEditField(form, "18", 2, 2, FIXED_MEDIUM);
    e_fsize->setAttachment(True, True, True, False);

    tb = new CmToggleButton(form, "Bold", HELV_MEDIUM);
	tb->setCallback(this, (INT_CB)&CaFontView::setBold);
    tb->setResize(False, False);

    tb = new CmToggleButton(form, "Italic", HELV_MEDIUM);
	tb->setCallback(this, (INT_CB)&CaFontView::setItalic);
    tb->setResize(False, False);

    pb = new CmPushButton(form, "Test", TIMES_MEDIUM);
	pb->setCallback(this, (VOID_CB)&CaFontView::showFont);

    drawa = new CaShowFont(this, shell, 400, 120);
    drawa->setExposeCallback(drawa, (EVENT_CB)&CaShowFont::onExpose);
    drawa->setResize(True, False);

    sfile = new CmSFile(shell, __FILE__, FIXED_MEDIUM, 12, 60);
    sfile->setColor(darkblue, white);

    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaFontView::closeDialog);

    shell->realize();
}

CaFontView::
~CaFontView(void)
{
	delete shell;
	delete font;
}

void FontViewDemo(void)
{
	new CaFontView;
}
