;*****************************************************************************
;
;   LXT_ME.CMD - MicroEMACS MACRO FUNCTIONS FOR
;
;       LFTN (TM) LISP FUNCTION TREE NAVIGATOR
;
;   Copyright (C) Juergen Mueller (J.M.) 1992-1999
;   All rights reserved.
;
;   You are expressly prohibited from selling this software in any form,
;   distributing it with another product, or removing this notice.
;
;   This software and documentation is the confidential and proprietary 
;   information of Juergen Mueller ("Confidential Information").  
;   You shall not disclose such Confidential Information and shall use 
;   it only in accordance with the terms of the license agreement you 
;   entered into with Juergen Mueller.
;
;   Limited permission is given to registered LXT users to modify this
;   file for their own personal use only. This file may not be used for any
;   purpose other than in conjunction with the LXT software package.
;
;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
;   EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE
;   IMPLIED WARRANTIES OF MERCHANTIBILITY, FITNESS FOR A PARTICULAR
;   PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR
;   ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
;   OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. THE ENTIRE RISK
;   AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM AND DOCUMENTATION
;   IS WITH YOU.
;
;   written by: Juergen Mueller, Eastleighstrasse 14, 70806 Kornwestheim,
;               GERMANY
;
;   FILE       : LXT_ME.CMD
;   REVISION   : 01-Jun-1999
;                19:36:59
;
;*****************************************************************************

; NOTE: for OS/2 you should exchange "lftn" with "lftn4os2"
; NOTE: for DOS you should exchange "lftn" with "lftn16"

;*****************************************************************************
;**** write initial message ****
;*****************************************************************************
write-message "Loading LXT macro package"

;*****************************************************************************
;**** macro package initialization section ****
;*****************************************************************************
set %lxt_item ""                ; set internal variables
set %lxt_file ""
set %lxt_line ""
set %lxtn_cmd ""
set %char_set "-_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

set %lft_base &env "LFTNBASE"   ; get environment variables, if set

;*****************************************************************************
;**** definition of user macros ****
;*****************************************************************************

;**** find function ****
store-procedure lft
        execute-procedure _extract_item         ; get tagged item
        execute-procedure _lxt_lft
!endm

;**** find function ****
store-procedure lftmark
        execute-procedure _extract_marked_item  ; get marked item
        execute-procedure _lxt_lft
!endm

;**** find function ****
store-procedure lftfind
        set %lxt_item "LFT function name: "
        set %lxt_item @%lxt_item                ; get user input
        execute-procedure _lxt_lft
!endm

;**** set LFT database name ****
store-procedure lftbase
        set %lft_base "LFT database name: "
        set %lft_base @%lft_base                ; get user input
!endm

;**** LFT file list
store-procedure lftfile
        write-message "Extracting LFT filelist"

        !if &not &seq &len %lft_base 0
          set %tmp &cat &cat "-f" %lft_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %lxtn_cmd &cat "lftn -F " %tmp
        pipe-command %lxtn_cmd          ; perform database access, shell command
!endm

;*****************************************************************************
;**** internal macro execution functions ****
;*****************************************************************************

;*****************************************************************************
;* LFT front-end *
;*****************************************************************************
store-procedure _lxt_lft
        !if &seq &len %lxt_item 0
          write-message "No function selected"
          !return
        !endif

        write-message &cat &cat "Searching for function: '" %lxt_item "'"

        !if &not &seq &len %lft_base 0
          set %tmp &cat &cat "-f" %lft_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %lxtn_cmd &cat &cat "lftn -b " %tmp %lxt_item
        execute-procedure _lxt_search                   ; start search
!endm

;*****************************************************************************
;* the database retrieval function *
;*****************************************************************************
store-procedure _lxt_search
        set %lxt_file ""                ; clear variables
        set %lxt_line ""

!force  pipe-command %lxtn_cmd          ; perform database access, shell command
        !if &seq $status FALSE
          !return
        !endif

!force  select-buffer command           ; get result buffer from pipe-command
        !if &seq $status FALSE
          !return
        !endif

!force  beginning-of-file               ; go to file begin
        !if &seq $status FALSE
          !return
        !endif

        set-mark                        ; extract target file name

!force  search-forward " "              ; search for first blank after file name
        !if &seq $status FALSE
          !return
        !endif

        backward-character
        copy-region
        set %lxt_file $kill             ; store target file name
        forward-character
        set-mark                        ; extract target file line
        end-of-line
        copy-region
        set %lxt_line $kill             ; store target file line

!force  delete-window                   ; delete command window
!force  delete-buffer command           ; delete command buffer
!force  next-buffer                     ; switch to next buffer just to hide command buf

        !if &not &exist %lxt_file       ; test if file exists
          write-message &cat &cat "Target file ~"" %lxt_file "~" not found"
          !return
        !endif

!force  find-file %lxt_file             ; open target file

        !if &seq $status TRUE
!force    goto-line %lxt_line           ; jump to target line

          !if &seq $status FALSE
            clear-message-line
            !return
          !endif

          delete-other-windows          ; just for safety
          redraw-display                ; center target line
          clear-message-line
        !endif
!endm

;*****************************************************************************
;* read search item from current buffer *
;*****************************************************************************
store-procedure _extract_item
        set %lxt_item ""                ; clear variable

        !if &seq &sindex %char_set &chr $curchar 0
          !return                       ; not on a valid character
        !endif

!force  end-of-word

        !while TRUE
!force  previous-word
!force  backward-character
        !if &seq &sindex %char_set &chr $curchar 0
!force    forward-character
          !break
        !endif
        !endwhile

        set-mark                        ; mark first item character

        !while TRUE
!force  end-of-word                     ; goto end of item
        !if &seq &sindex %char_set &chr $curchar 0
          !break
        !endif
        !endwhile

        copy-region
        set %lxt_item $kill             ; store item name
!endm

;*****************************************************************************
;* read marked search item *
;*****************************************************************************
store-procedure _extract_marked_item
        set %lxt_item ""                                ; clear variable
!force  copy-region
        set %lxt_item $kill                             ; store item name

        !if &not &seq &len %lxt_item 0
          set %lxt_item &cat &cat "~"" %lxt_item "~""   ; quote
        !endif
!endm

;*****************************************************************************
;* bind macros to WINDOWS menu, only if MicroEMACS for WINDOWS is present *
;*****************************************************************************
!if &seq $sres "MSWIN"          ; test, if this is running under MS Windows
  ; insert separator
  bind-to-menu  nop     ">&Miscellaneous>-@5"

  ; create a new underlying pop-up menu for the LFT macros
  macro-to-menu lft     ">&Miscellaneous>L&FT macros@6>LFT &function search@0"
  macro-to-menu lftmark "LFT function search &mark"
  macro-to-menu lftfind "LFT function search &prompt"
  macro-to-menu lftfile "LFT file&list"
  macro-to-menu lftbase "LFT data&base name"
!endif

;*****************************************************************************
;**** write final message ****
;*****************************************************************************
write-message "LXT macro package loaded"

;**** THIS IS THE END THIS IS THE END THIS IS THE END THIS IS THE END ****

