/** \file CON_RetVal.h
    Return Values.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_CON_RETVAL
#define H_CON_RETVAL

enum {
  OK=0,
  NO_ZBUFFER=-1101,
  NO_3D_DEVICE=-1102,
  OBJECT_FINALIZED=-1103,
  CANNOT_CREATE_MATERIAL=-1104,
  SURFACE_UNDEFINED=-1105,
  NOT_LOCKED=-1106,
  LOCKED=-1107,
  INVALID_DC=-1108,
  INVALID_COORDS=-1109,
  CANNOT_SET_MATERIAL=-1110,
  INVALID_RGB_SELECTION=-1111,
  BITMAP_STREAM_END=-1112,
  INVALID_PIXEL_FORMAT=-1113,
  TOO_MANY_OBJECTS=-1114,
  NO_JOYSTICK=-1115,
  DIMENSION_MISMATCH=-1116,
  RESOURCESTREAM_NOT_OPEN_FOR_WRITING=-1117,
  RESOURCE_ALREADY_EXISTS=-1118,
  RESOURCE_INSUFFICIENT_DATA=-1119,
  INSUFFICIENT_MEMORY=-1120,
  CLIPPED_OUT=-1121,
  NOT_SUPPORTED=-1122,
  VIDEO_READ_ERROR=-1123,
  INVALID_WINDOW_BIT_DEPTH=-1124,
  UNDEFINED=-1199
};

inline const char* getErrorMessage(long rc)
{
  switch (rc)
  {
  case OK: return "OK";
  case NO_ZBUFFER: return "NO_ZBUFFER";
  case NO_3D_DEVICE: return "NO_3D_DEVICE";
  case OBJECT_FINALIZED: return "OBJECT_FINALIZED";
  case CANNOT_CREATE_MATERIAL: return "CANNOT_CREATE_MATERIAL";
  case SURFACE_UNDEFINED: return "SURFACE_UNDEFINED";
  case NOT_LOCKED: return "NOT_LOCKED";
  case LOCKED: return "LOCKED";
  case INVALID_DC: return "INVALID_DC";
  case INVALID_COORDS: return "INVALID_COORDS";
  case CANNOT_SET_MATERIAL: return "CANNOT_SET_MATERIAL";
  case INVALID_RGB_SELECTION: return "INVALID_RGB_SELECTION";
  case BITMAP_STREAM_END: return "BITMAP_STREAM_END";
  case INVALID_PIXEL_FORMAT: return "INVALID_PIXEL_FORMAT";
  case TOO_MANY_OBJECTS: return "TOO_MANY_OBJECTS";
  case NO_JOYSTICK: return "NO_JOYSTICK";
  case DIMENSION_MISMATCH: return "DIMENSION_MISMATCH";
  case RESOURCESTREAM_NOT_OPEN_FOR_WRITING: return "RESOURCESTREAM_NOT_OPEN_FOR_WRITING";
  case RESOURCE_ALREADY_EXISTS: return "RESOURCE_ALREADY_EXISTS";
  case RESOURCE_INSUFFICIENT_DATA: return "RESOURCE_INSUFFICIENT_DATA";
  case INSUFFICIENT_MEMORY: return "INSUFFICIENT_MEMORY";
  case CLIPPED_OUT: return "CLIPPED OUT";
  case NOT_SUPPORTED: return "NOT SUPPORTED";
  case VIDEO_READ_ERROR: return "VIDEO READ ERROR";
  case INVALID_WINDOW_BIT_DEPTH: return "INVALID_WINDOW_BIT_DEPTH";
  case UNDEFINED: return "UNDEFINED";
  }
  return "INVALID ERROR CODE";
}

////////////////////////////////////////////////////////////
// Debugging Functions
////////////////////////////////////////////////////////////
#ifndef FUNC_DEBUGGING
#define FUNC_DEBUGGING

#ifndef DLLExport
#define DLLExport __declspec( dllexport )
#endif

/** Sets the level of debugging information. 
    Defaults to 0 which outputs no log.
    Setting to a different value will create a log file 'libcon.log'
    That will be filled with printouts.
*/
DLLExport void setDebugLevel(int Level);

/** Enable a mechanizm that tracks allocated interfaces.
    If used, it must be called before creating any interfaces.
    Diagnosis will be printed (If the debug level is set) when
    the program terminates.  The printouts will contain the 
    types of interfaces that were not released.
*/
DLLExport void enableDiagnostics();

/** Can be used to append the log file with an error message. 
    rc is a return code, or any informational number.
*/
DLLExport void ReportError(long rc, const char* Message);

/** Can be used to append the log file with an warning message. 
    rc is a return code, or any informational number.
*/
DLLExport void ReportWarning(long rc, const char* Message, int MinDebug=1);

/** Can be used to append the log file with an informational message. 
*/
DLLExport void ReportInfo(const char* Message, int MinDebug=1);


#endif // FUNC_DEBUGGING

#endif // H_CON_RETVAL