############################################################################
#** interpcom-2.3    (command interpreter)                                **
#** general makefile                                                      **
#**                                                                       **
#** Copyright (C) 2001  Jean-Marc Drezet                                  **
#**                                                                       **
#**  This library is free software; you can redistribute it and/or        **
#**  modify it under the terms of the GNU Library General Public          **
#**  License as published by the Free Software Foundation; either         **
#**  version 2 of the License, or (at your option) any later version.     **
#**									  **
#**  This library is distributed in the hope that it will be useful,      **
#**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
#**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
#**  Library General Public License for more details. 			  **
#**									  **
#**  You should have received a copy of the GNU Library General Public    **
#**  License along with this library; if not, write to the Free		  **
#**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
#**                                                                       **
#** Please mail any bug reports/fixes/enhancements to me at:              **
#**      drezet@math.jussieu.fr                                           **
#** or                                                                    **
#**      Jean-Marc Drezet                                                 **
#**      Institut de Mathematiques                                        **
#**      Aile 45-55                                                       **
#**      2, place Jussieu                                                 **
#**      75251 Paris Cedex 05                                             **
#**      France			 					  **
#**                                                                       **
############################################################################

export LIBS= -lpthread -lhistory -lreadline -ltermcap

# debug version
# export CFLAGS= -Wall -g -D_ENG_LANG
# export CFLAGS= -Wall -g 
export CFLAGS= -Wall -O6 -funroll-loops -malign-double -D_ENG_LANG -D__WITH_READLINE
export CC=g++

all : libinter_cpp.a test_cpp

OBJS =  command_.o complex_.o com_sys_.o ee_.o interp_.o mem_.o objdef_.o \
int_def_.o

$(OBJS) : %_.o : %.cpp
	$(CC) -c $(CFLAGS) -I.. -D_HAVE_THREADS -D_REENTRANT $< -o $@

command.cpp : ../command.c
	cp ../command.c command.cpp

com_sys.cpp : ../com_sys.c
	cp ../com_sys.c com_sys.cpp

complex.cpp : ../complex.c
	cp ../complex.c complex.cpp

ee.cpp : ../ee.c
	cp ../ee.c ee.cpp

int_def.cpp : ../int_def.c
	cp ../int_def.c int_def.cpp

interp.cpp : ../interp.c
	cp ../interp.c interp.cpp

mem.cpp : ../mem.c
	cp ../mem.c mem.cpp

objdef.cpp : ../objdef.c
	cp ../objdef.c objdef.cpp

libinter_cpp.a : $(OBJS)
	ar cr libinter_cpp.a *_.o

test_cpp : main.o interp.ini com
	$(CC) main.o libinter_cpp.a -lm $(LIBS) -o test_cpp

interp.ini :
	ln -s ../test/interp.ini interp.ini

com :
	ln -s ../test/com com

main.o : main.cpp
	$(CC) -c $(CFLAGS) -I.. -D_HAVE_THREADS -D_REENTRANT main.cpp

main.cpp : ../test/main.c
	cp ../test/main.c main.cpp

clean-all :
	rm -f *.o *.lo *.a *.so.2.3 *% *bck *~ test_cpp

clean :
	make clean










