// ISImageDemoDoc.h : interface of the CISImageDemoDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_)
#define AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ISImage.h"

// hints for OnUpdate
enum {eHintNewImage};

class CISImageDemoDoc : public CDocument
{
protected: // create from serialization only
	CISImageDemoDoc();
	DECLARE_DYNCREATE(CISImageDemoDoc)

// Attributes
public:

// Operations
public:
	CSize			GetImageSize()			{return m_image.GetSize();}
	CSize			GetImageDPI()			{return m_image.GetDPI();}
	CBitmap *	GetImageCBitmap()		{return &m_cBmp;}
   CPalette *  GetImagePalette()    {return m_image.GetImagePalette();}

   // draw our CBitmap into a rect on a DC using m_image's palette
   // we just assume that the palette and the CBitmap were based on the
   // same image                     
   BOOL        Draw(const CDC *pDC, const CRect & outRect)  
                  {return ISrc(ISDrawHBITMAP)(pDC->m_hDC, 
                                              (HBITMAP)m_cBmp.GetSafeHandle(), 
                                              outRect.left, 
                                              outRect.top, 
                                              outRect.Width(), 
                                              outRect.Height(), 
                                              (HPALETTE)GetImagePalette()->GetSafeHandle());}

   BOOL        StretchDraw(const CDC *pDC, const CRect & outRect)  {return m_image.StretchDraw(pDC, outRect);}


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CISImageDemoDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CISImageDemoDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

   CISImage    m_image;
protected:

   
   CBitmap     m_cBmp;

// Generated message map functions
protected:
	//{{AFX_MSG(CISImageDemoDoc)
	afx_msg void OnFileOpen();
	afx_msg void OnFileSaveAs();
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnEditResize();
	afx_msg void OnUpdateEditResize(CCmdUI* pCmdUI);
	afx_msg void OnEditHorizontalflip();
	afx_msg void OnUpdateEditHorizontalflip(CCmdUI* pCmdUI);
	afx_msg void OnEditVerticalflip();
	afx_msg void OnUpdateEditVerticalflip(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()


   void  UpdateImage();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ISIMAGEDEMODOC_H__988D2F6E_FD70_11D2_A086_00500402F30B__INCLUDED_)
