#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <dpmi.h>
#include <llp.h>

extern int _stacktop;

static unsigned oldcr0;
unsigned hasfloat;

#pragma startup llfpini 149
		
static void raise16(void)
{
	__clearxcept();
		asm mov esp,[_stacktop]
  asm sti
		fprintf(stderr,"\nFloating point exception");
		exit(EXIT_FAILURE);
}
static void raise7(void)
{
	__clearxcept();
		asm mov esp,[_stacktop]
  	asm sti
		fprintf(stderr,"\nFloating point emulation not supported under DOS");
		exit(EXIT_FAILURE);
}
static void llfpini(void)
{
	short work;

	work = 0x4567;

  asm fninit
  asm fnstsw [work]	
	if (work == 0) {
		/* have fpu coprocessor */
		asm fninit
    asm fwait
		asm fstcw [work]
		work &= 0xffbb;
		asm fldcw [work]
		hasfloat++;
		__setxcept(16,raise16);
	}
	else {
		/* need emulator */
		__setxcept(7,raise7);
	}
}