// EntrySynchronizationBase.h: interface for the EntrySynchronizationBase class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ENTRYSYNCHRONIZATIONBASE_H__E7DDB6F2_7B82_4177_BF87_53D27AD1A66E__INCLUDED_)
#define AFX_ENTRYSYNCHRONIZATIONBASE_H__E7DDB6F2_7B82_4177_BF87_53D27AD1A66E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atask\TaskSynchronizationBase.h>

//////////////////////////////////////////////////////////////////////
// The base class of all entries implements the synchronization primitives

class EntrySynchronizationBase  
{
public:
	typedef EntrySynchronizationBase** EntryPtrTable;
	// NULL terminated array of EntrySynchronizationBase*

	struct RendezvousData {
		EntrySynchronizationBase *accepted_pe;
		HANDLE caller_event;
		int thread_priority;
		void *pparams;
	};

	bool entry_call(void* pparams, DWORD timeout);

	void start_simple_accept(RendezvousData &data, bool wait);
	static void start_select_accept
		(EntryPtrTable pe_table, 
		 RendezvousData &data, DWORD timeout, bool terminable);
	void end_accept(RendezvousData &data);

protected:
	enum EntryKind 
		{null_Entry, normal_Entry, msg_Entry, aio_Entry, signal_Entry};

	EntrySynchronizationBase
		(EntryKind kind = null_Entry, int sig = 0);
	~EntrySynchronizationBase();

	static void register_aio_completion(void* aio_data_ptr);

	int volatile pending_call_count;

private:
	struct CallDescr;
	struct OwnerDescr;

	void start_accept_normal_entry(RendezvousData &data, bool wait);
	void start_accept_msg_entry(RendezvousData &data, bool wait);
	void start_accept_aio_entry(RendezvousData &data, bool wait);
	void start_accept_signal_entry(RendezvousData &data, bool wait);

	static int select_entry_to_accept(EntryPtrTable pe_table, OwnerDescr &od);
	static void reset_entries(EntryPtrTable pe_table, int count);
	static bool wait_for_event(OwnerDescr &od, DWORD timeout);

	static void accept_from_entry_queue
		(EntrySynchronizationBase* pe, RendezvousData &data);
	static void accept_from_owner_descr
		(OwnerDescr &od, RendezvousData &data);
	static void accept_posted_message
		(EntrySynchronizationBase* msg_pe, RendezvousData &data);
	static void accept_aio_completion
		(EntrySynchronizationBase* aio_pe, RendezvousData &data);
	static void accept_pending_signal
		(EntrySynchronizationBase* signal_pe, RendezvousData &data);
	static void set_accept_failed(RendezvousData &data);
	static void accept_termination_and_quit(OwnerDescr &od);

	static void _cdecl signal_handler(int sig);
	static CallDescr &signal_cd(int sig);

	static int set_rendezvous_priority(int caller_thread_priority);
	static void reset_priority(int original_thread_priority);

	void append_call_to_queue(CallDescr *pcd);
	void remove_call_from_queue(CallDescr *pcd);

	bool message_available();
	bool aio_data_available();

	EntryKind kind;
	union {
	// case normal_Entry, signal_Entry
		struct {
			union {
			// case normal_Entry
				struct {
					CRITICAL_SECTION cs;
					CallDescr *volatile first_call;
					CallDescr *volatile last_call;
				};
			// case signal_Entry
				struct {
					int signal_number;
					LONG volatile signal_count;
				};
			};
			OwnerDescr *volatile waiting_owner;
		};
	// case msg_Entry
		struct {
			MSG msg;
			bool msg_pending;
		};
	// case aio_Entry
		struct {
			void *aio_data_ptr;
		};
	};
};

#endif // !defined(AFX_ENTRYSYNCHRONIZATIONBASE_H__E7DDB6F2_7B82_4177_BF87_53D27AD1A66E__INCLUDED_)
