// ***********************************************************************************************************
// *******************************************  BASIC TYPES ***************************************************
// ************************************************************************************************************
typedef unsigned int UINT;
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef unsigned long ULONG;
typedef char CHAR;
typedef char TCHAR;
typedef int BOOL;
typedef void VOID;
typedef BYTE *LPSTR;
typedef TCHAR *LPTSTR;
typedef BYTE *LPCSTR;
typedef LPCSTR LPCTSTR;
typedef void *LPVOID;
typedef void *PVOID;
typedef LPVOID LPCVOID;
typedef WORD *LPWORD;
typedef UINT *LPUINT;
typedef BYTE *LPBYTE;
typedef DWORD *LPDWORD;
typedef DWORD *PDWORD;
typedef UINT HANDLE;
typedef HANDLE HINSTANCE;
typedef HANDLE HMODULE;
typedef HANDLE HMENU;
typedef HANDLE HWND;
typedef HANDLE HGLOBAL;
typedef HANDLE HRSRC;
typedef int HFILE;
typedef DWORD LRESULT;
typedef long LONG;
typedef LONG *PLONG;
typedef UINT ATOM;
typedef struct tagPOINT
{
  int x;
  int y;
}POINT;
typedef POINT *PPOINT;
typedef POINT *NPPOINT;
typedef POINT *LPPOINT;

// ***********************************************************************************************************
// ******************************************* KERNEL32.DLL **************************************************
// ***********************************************************************************************************
typedef struct _SECURITY_ATTRIBUTES
{
	DWORD nLength;
	LPVOID lpSecurityDescriptor;
	BOOL bInheritHandle;
}SECURITY_ATTRIBUTES,*PSECURITY_ATTRIBUTES; // ,*LPSECURITY_ATTRIBUTES;
typedef SECURITY_ATTRIBUTES *LPSECURITY_ATTRIBUTES;
typedef struct _STARTUPINFOA
{
	DWORD   cb;
	LPSTR   lpReserved;
	LPSTR   lpDesktop;
	LPSTR   lpTitle;
	DWORD   dwX;
	DWORD   dwY;
	DWORD   dwXSize;
	DWORD   dwYSize;
	DWORD   dwXCountChars;
	DWORD   dwYCountChars;
	DWORD   dwFillAttribute;
	DWORD   dwFlags;
	WORD    wShowWindow;
	WORD    cbReserved2;
	LPBYTE  lpReserved2;
	HANDLE  hStdInput;
	HANDLE  hStdOutput;
	HANDLE  hStdError;
}STARTUPINFOA,*LPSTARTUPINFOA;
typedef struct _PROCESS_INFORMATION
{
	HANDLE hProcess;
	HANDLE hThread;
	DWORD dwProcessId;
	DWORD dwThreadId;
}PROCESS_INFORMATION,*PPROCESS_INFORMATION,*LPPROCESS_INFORMATION;
typedef struct _OVERLAPPED
{
	DWORD   Internal;
	DWORD   InternalHigh;
	DWORD   Offset;
	DWORD   OffsetHigh;
	HANDLE  hEvent;
}OVERLAPPED,*LPOVERLAPPED;
typedef struct tagOFSTRUCT
{
	BYTE cBytes;
	BYTE fFixedDisk;
	UINT nErrCode;
	BYTE reserved[4];
	char szPathName[128];
}OFSTRUCT,*LPOFSTRUCT;
typedef struct _MEMORY_BASIC_INFORMATION
{
	PVOID BaseAddress;
	PVOID AllocationBase;
	DWORD AllocationProtect;
	DWORD RegionSize;
	DWORD State;
	DWORD Protect;
	DWORD Type;
}MEMORY_BASIC_INFORMATION,*PMEMORY_BASIC_INFORMATION;
typedef struct _FILETIME
{
	DWORD dwLowDateTime;
  DWORD dwHighDateTime; 
}FILETIME,*LPFILETIME,*PFILETIME;
typedef struct _WIN32_FIND_DATA
{
	DWORD dwFileAttributes;
	FILETIME ftCreationTime;
	FILETIME ftLastAccessTime;
	FILETIME ftLastWriteTime;
	DWORD nFileSizeHigh;
	DWORD nFileSizeLow;
	DWORD dwReserved0;
	DWORD dwReserved1;
	TCHAR cFileName[260];
	TCHAR cAlternateFileName[14];
}WIN32_FIND_DATA,*LPWIN32_FIND_DATA;
typedef void *LPTHREAD_START_ROUTINE;
BOOL _pascal CopyFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,BOOL bFailIfExists);
BOOL _pascal CreateDirectoryA(LPCSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes);
BOOL _pascal CreateDirectoryExA(LPCTSTR lpTemplateDirectory,LPCTSTR lpNewDirectory,LPSECURITY_ATTRIBUTES lpSecurityAttributes);
HANDLE _pascal CreateEventA(LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPCSTR lpName);
HANDLE _pascal CreateFileA(LPCTSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDistribution,DWORD dwFlagsAndAttribute,HANDLE hTemplateFile);
DWORD _pascal SetFilePointer(HANDLE hFile,LONG lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod);
BOOL _pascal ReadFile(HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,LPOVERLAPPED lpOverlapped);
LONG _pascal _llseek(HFILE hFile,LONG offset,int whence);
HANDLE _pascal CreateMutexA(LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPCSTR lpName);
BOOL _pascal CreateProcessA(LPCSTR lpApplicationName,LPSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCSTR lpCurrentDirectory,LPSTARTUPINFOA lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation);
HANDLE _pascal CreateRemoteThread(HANDLE hProcess,LPSECURITY_ATTRIBUTES lpThreadAttributes,DWORD dwStackSize,LPTHREAD_START_ROUTINE lpStartAddress,LPVOID lpParameter,DWORD dwCreationFlags,LPDWORD lpThreadId);
BOOL _pascal DefineDosDeviceA(DWORD dwFlags,LPCSTR lpDeviceName,LPCSTR lpTargetPath);
BOOL _pascal DeleteFileA(LPCSTR lpFileName);
BOOL _pascal DeviceIoControl(HANDLE hDevice,DWORD dwIoControlCode,LPVOID lpInBuffer,DWORD nInBufferSize,LPVOID lpOutBuffer,DWORD nOutBufferSize,LPDWORD lpBytesReturned,LPOVERLAPPED lpOverlapped);
BOOL _pascal DisableThreadLibraryCalls(HMODULE hLibModule);
BOOL _pascal FlushInstructionCache(HANDLE hProcess,LPCVOID lpBaseAddress,DWORD dwSize);
BOOL _pascal GetComputerNameA(LPSTR lpBuffer,LPDWORD nSize);
HGLOBAL _pascal GlobalAlloc(UINT uFlags,DWORD dwBytes);
HGLOBAL _pascal GlobalFree(HGLOBAL hMem);
HANDLE _pascal HeapCreate(DWORD flOptions,DWORD dwInitialSize,DWORD dwMaximumSize);
BOOL _pascal HeapDestroy(HANDLE hHeap);

// Heap functions are used in place of operator new and delete
// in standard library and thus are called quite often.  This
// slows down the spy process significantly so I avoid them

//LPVOID _pascal HeapAlloc(HANDLE hHeap,DWORD dwFlags,DWORD dwBytes);
//BOOL _pascal HeapFree(HANDLE hHeap,DWORD dwFlags,LPVOID lpMem);
UINT _pascal HeapCompact(HANDLE hHeap,DWORD dwFlags);
HINSTANCE _pascal LoadLibraryA(LPCTSTR lpLibFileName);
HMODULE _pascal LoadLibraryExA(LPCSTR lpLibFileName,HANDLE hFile,DWORD dwFlags);
void _pascal FreeLibrary(HINSTANCE);
HINSTANCE _pascal LoadModule(LPCSTR, LPVOID);
BOOL _pascal LockFile(HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh);
BOOL _pascal UnlockFile(HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToUnlockLow,DWORD nNumberOfBytesToUnlockHigh);
BOOL _pascal LockFileEx(HANDLE hFile,DWORD dwFlags,DWORD dwReserved,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh,LPOVERLAPPED lpOverlapped);
BOOL _pascal MoveFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName);
BOOL _pascal MoveFileExA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,DWORD dwFlags);
HFILE _pascal OpenFile(LPCSTR lpFileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle);
HANDLE _pascal OpenProcess(DWORD dwDesiredAccess,BOOL bInheritHandle,DWORD dwProcessId);
DWORD _pascal QueryDosDeviceA(LPCSTR lpDeviceName,LPSTR lpTargetPath,DWORD ucchMax);
BOOL _pascal RemoveDirectoryA(LPCSTR lpPathName);
BOOL _pascal SetComputerNameA(LPCSTR lpComputerName);
LPVOID _pascal VirtualAlloc(LPVOID lpAddress,DWORD dwSize,DWORD flAllocationType,DWORD flProtect);
BOOL _pascal VirtualFree(LPVOID lpAddress,DWORD dwSize,DWORD dwFreeType);
BOOL _pascal VirtualProtect(LPVOID lpAddress,DWORD dwSize,DWORD flNewProtect,PDWORD lpflOldProtect);
DWORD _pascal VirtualQuery(LPCVOID lpAddress,PMEMORY_BASIC_INFORMATION lpBuffer,DWORD dwLength);
BOOL _pascal VirtualProtectEx(HANDLE hProcess,LPVOID lpAddress,DWORD dwSize,DWORD flNewProtect,PDWORD lpflOldProtect);
DWORD _pascal VirtualQueryEx(HANDLE hProcess,LPCVOID lpAddress,PMEMORY_BASIC_INFORMATION lpBuffer,DWORD dwLength);
BOOL _pascal VirtualLock(LPVOID lpAddress,DWORD dwSize);
BOOL _pascal VirtualUnlock(LPVOID lpAddress,DWORD dwSize);
BOOL _pascal WriteProfileStringA(LPCTSTR lpszSection,LPCTSTR lpszKey,LPCTSTR lpszString);
BOOL _pascal GetProfileStringA(LPCTSTR lpAppName,LPCTSTR lpKeyName,LPCTSTR lpDefault,LPSTR lpReturnedString,DWORD nSize);
void *_pascal GetProcAddress(HMODULE hModule,LPCSTR lpProcName);
void _pascal ExitProcess(UINT uExitCode);
UINT _pascal WinExec(LPCSTR lpszCmdLine,UINT nCmdShow);
void _pascal GetStartupInfoA(LPSTARTUPINFOA lpStartupInfo);
HMODULE _pascal GetModuleHandleA(LPCTSTR lpszModuleName);
DWORD _pascal GetModuleFileNameA(HMODULE hModule,LPTSTR lpFileName,DWORD nSize);
BOOL _pascal CloseHandle(HANDLE hObject);
HANDLE _pascal CreateFileMappingA(HANDLE hFile,LPSECURITY_ATTRIBUTES lpFileMappingAttributes,DWORD flProtect,DWORD dwMaximumSizeHigh,DWORD dwMaximumSizeLow,LPCTSTR lpName);
void _pascal FataLAppExit(UINT uAction,LPCTSTR lpMessageText);
void _pascal FatalExit(int exitCode);
HRSRC _pascal FindResourceA(HMODULE hModule,LPCTSTR lpName,LPCTSTR lpType);
HRSRC _pascal FindResourceExA(HMODULE hModule,LPCTSTR lpType,LPCTSTR lpName,WORD wLanguage);
BOOL _pascal GetDiskFreeSpaceA(LPCTSTR lpRootPathName,LPDWORD lpSectorsPerCluster,LPDWORD lpBytesPerSector,LPDWORD lpNumberOfFreeClusters,LPDWORD lpTotalNumberOfClusters);
BOOL _pascal GetFileTime(HANDLE hFile,LPFILETIME lpCreationTime,LPFILETIME lpLastAccessTime,LPFILETIME lpLastWriteTime);
DWORD _pascal GetFileSize(HANDLE hFile,LPDWORD lpFileSizeHigh);
UINT _pascal GetPrivateProfileIntA(LPCTSTR lpAppName,LPCTSTR lpKeyName,int nDefault,LPCTSTR lpFileName);
DWORD _pascal GetPrivateProfileSectionA(LPCTSTR lpAppName,LPSTR lpReturnedString,DWORD nSize,LPCTSTR lpFileName);
LPSTR _pascal GetEnvironmentStrings(void);
LPSTR _pascal GetEnvironmentStringsA(void);
DWORD _pascal GetLogicalDrives(VOID);
DWORD _pascal SearchPathA(LPCTSTR lpszPath,LPCTSTR lpszFile,LPCTSTR lpszExtension,DWORD cchReturnBuffer,LPTSTR lpszReturnBuffer,void *plpszFilePart);
DWORD _pascal GetFullPathNameA(LPCTSTR lpFileName,DWORD nBufferLength,LPTSTR lpBuffer,void *lpFilePart);

// the WIN32_FIND_DATA structure, being quite large, is time consuming
// to output.  The following three functions should be used judiciously.
//HANDLE _pascal FindFirstFileA(LPCTSTR lpFileName,LPWIN32_FIND_DATA lpFindFileData);
//BOOL _pascal FindNextFileA(HANDLE hFindFile,LPWIN32_FIND_DATA lpFindFileData);
//BOOL _pascal FindClose(HANDLE hFindFile);


// ***********************************************************************************************************
// ******************************************* USER32.DLL *****************************************************
// ***********************************************************************************************************
typedef HANDLE HBRUSH;
typedef HANDLE HBITMAP;
typedef HANDLE HICON;
typedef HANDLE HDESK;
typedef HANDLE HDC;
typedef HICON HCURSOR;
typedef void *WNDPROC;
typedef void *DLGPROC;
typedef UINT WPARAM;
typedef LONG LPARAM;
typedef struct tagWNDCLASS
{
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCSTR lpszMenuName;
	LPCSTR lpszClassName;
}WNDCLASS;
typedef struct tagWNDCLASSEXA
{
	UINT cbSize;
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCSTR lpszMenuName;
	LPCSTR lpszClassName;
	HICON hIconSm;
}WNDCLASSEXA,*PWNDCLASSEXA,*NPWNDCLASSEXA,*LPWNDCLASSEXA;
typedef struct tagRECT
{
	int left;
	int top;
	int right;
	int bottom;
}RECT;
typedef RECT *PRECT;
typedef RECT *NPRECT;
typedef RECT *LPRECT;
typedef struct tagPAINTSTRUCT
{
	HDC hdc;
	BOOL fErase;
	RECT rcPaint;
	BOOL fRestore;
	BOOL fIncUpdate;
	BYTE rgbReserved[16];
}PAINTSTRUCT;
typedef PAINTSTRUCT *PPAINTSTRUCT;
typedef PAINTSTRUCT *NPPAINTSTRUCT;
typedef PAINTSTRUCT *LPPAINTSTRUCT;

typedef struct tagDEVMODE
{
	char dmDeviceName[32];
	UINT dmSpecVersion;
	UINT dmDriverVersion;
	UINT dmSize;
	UINT dmDriverExtra;
	DWORD dmFields;
	int dmOrientation;
	int dmPaperSize;
	int dmPaperLength;
	int dmPaperWidth;
	int dmScale;
	int dmCopies;
	int dmDefaultSource;
	int dmPrintQuality;
	int dmColor;
	int dmDuplex;
	int dmYResolution;
	int dmTTOption;
}DEVMODE,*PDEVMODE,*NPDEVMODE,*LPDEVMODE;
typedef struct
{
	DWORD style;
	DWORD dwExtendedStyle;
	WORD cdit;
	short x;
	short y;
	short cx;
	short cy;
}DLGTEMPLATE,*LPDLGTEMPLATE,*PDLGTEMPLATE,*LPCDLGTEMPLATE;

BOOL _pascal MessageBeep(UINT type);
HANDLE _pascal LoadImageA(HINSTANCE hInstance,LPCTSTR lpszName,UINT uType,int cxDesired,int cyDesired,UINT fuLoad);
ATOM _pascal RegisterClassExA(WNDCLASSEXA *lpWndClassExA);
ATOM _pascal RegisterClassA(WNDCLASS *lpWndClass);
HICON _pascal LoadIconA(HINSTANCE hInstance,LPCTSTR lpszIconName);
BOOL _pascal DestroyWindow(HWND hWnd);
HWND _pascal FindWindowA(LPCTSTR lpClassName,LPCTSTR lpWindowName);
HBITMAP _pascal LoadBitmap(HINSTANCE hInstance,LPCTSTR lpBitmapName);
BOOL _pascal AttachThreadInput(DWORD idAttach,DWORD idAttachTo,BOOL fAttach);
HDC _pascal BeginPaint(HWND hWnd,LPPAINTSTRUCT lpPaint);
BOOL _pascal BringWindowToTop(HWND hWnd);
long _pascal BroadcastSystemMessage(DWORD dwFlags,LPDWORD lpdwRecipients,UINT uiMessage,WPARAM wParam,LPARAM lParam);
long _pascal ChangeDisplaySettings(LPDEVMODE lpDevMode,DWORD dwFlags);
BOOL _pascal CloseDesktop(HDESK hDeskTop);
BOOL _pascal CloseWindow(HWND hWnd);
HICON _pascal CopyIcon(HICON hIcon);
HANDLE _pascal CopyImage(HANDLE hImage,UINT uType,int cxDesired,int cyDesired,UINT fuFlags);	
BOOL _pascal DeleteMenu(HMENU hMenu,UINT uPosition,UINT uFlags);	
BOOL _pascal DestroyCaret(void);
BOOL _pascal DestroyCursor(HCURSOR hCursor);
BOOL _pascal DestroyIcon(HICON hIcon);
BOOL _pascal DestroyMenu(HMENU hMenu);
BOOL _pascal DrawAnimatedRects(HWND hWnd,int idAni,RECT *lprcFrom,RECT *lprcTo);
BOOL _pascal EndPaint(HWND hWnd,PAINTSTRUCT *lpPaint);
BOOL _pascal ExitWindowsEx(UINT uFlags,DWORD dwReserved);
BOOL _pascal FlashWindow(HWND hWnd,BOOL bInvert);
HBITMAP _pascal LoadBitmapA(HINSTANCE hInstance,LPCTSTR lpBitmapName);
BOOL _pascal PostMessageA(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
void _pascal PostQuitMessage(int nExitCode);
BOOL _pascal PostThreadMessage(DWORD dwThreadID,UINT uMsg,WPARAM wParam,LPARAM lParam);
//LRESULT _pascal SendMessageA(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
int _pascal DialogBoxA(HANDLE hInstance,LPCTSTR lpTemplate,HWND hWndParent,DLGPROC lpDialogFunc);
int _pascal DialogBoxIndirectA(HANDLE hInstance,LPDLGTEMPLATE lpTemplate,HWND hWndParent,DLGPROC lpDialogFunc);
int _pascal DialogBoxIndirectParamA(HINSTANCE hInstance,LPCDLGTEMPLATE hDialogTemplate,HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam);
int _pascal DialogBoxParamA(HINSTANCE hInstance,LPCTSTR lpTemplateName,HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam);
BOOL _pascal ScreenToClient(HWND hWnd,LPPOINT lpPoint);
BOOL _pascal WinHelpA(HWND hwnd,LPCTSTR lpszHelp,UINT uCommand,DWORD dwData);
HWND _pascal CreateDialogParamA(HINSTANCE hInstance,LPCTSTR lpTemplateName,HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam);
//int _pascal LoadStringA(HINSTANCE hInstance,UINT uID,LPTSTR lpBuffer,int nBufferMax);
BOOL _pascal SetDlgItemTextA(HWND hwndDlg,int idControl,LPCTSTR lpsz);
int _pascal GetWindowTextA(HWND hWnd,LPTSTR lpString,int nMaxCount);
BOOL _pascal SetWindowTextA(HWND hwnd,LPCTSTR lpsz);	
LPTSTR _pascal CharUpperA(LPTSTR lpsz);
HANDLE _pascal SetClipboardData(UINT uFormat,HANDLE hData);	

// ***********************************************************************************************************
// ******************************************* SHELL32.DLL *****************************************************
// ***********************************************************************************************************
typedef HANDLE HDROP;
typedef DWORD HKEY;
typedef HKEY *PHKEY;
typedef struct _SHELLEXECUTEINFOA
{
	DWORD cbSize;
	ULONG fMask;
	HWND hwnd;
	LPCSTR lpVerb;
	LPCSTR lpFile;
	LPCSTR lpParameters;
	LPCSTR lpDirectory;
	int nShow;
	HINSTANCE hInstApp;
	LPVOID lpIDList;
	LPCSTR lpClass;
	HKEY hkeyClass;
	DWORD dwHotKey;
	HANDLE hIcon;
	HANDLE hProcess;
}SHELLEXECUTEINFOA,*LPSHELLEXECUTEINFOA;
typedef struct _SHFILEINFO
{ // shfi 
    HICON hIcon; 
    int   iIcon; 
    DWORD dwAttributes; 
    char  szDisplayName[255]; 
    char  szTypeName[80]; 
}SHFILEINFO,*PSHFILEINFO; 

HINSTANCE _pascal ShellExecuteA(HWND hwnd,LPCSTR lpOperation,LPCSTR lpFile,LPCSTR lpParameters,LPCSTR lpDirectory,int iShowCmd);
UINT _pascal DragQueryFileA(HDROP hDrop,UINT iFile,LPTSTR lpszFile,UINT cch);
VOID _pascal DragFinish(HDROP hDrop);
VOID _pascal DragAcceptFiles(HWND hWnd,BOOL fAccept);
int _pascal ShellAboutA(HWND hWnd,LPCTSTR szApp,LPCTSTR szOtherStuff,HICON hIcon);
HICON _pascal ExtractAssociatedIconA(HINSTANCE hInstance,LPSTR lpIconPath,LPWORD lpiIcon);
BOOL _pascal ShellExecuteExA(LPSHELLEXECUTEINFOA lpExecInfo);
DWORD _pascal SHGetFileInfo(LPCSTR pszPath,DWORD dwFileAttributes,PSHFILEINFO psfi,UINT cbFileInfo,UINT uFlags);	

// ***********************************************************************************************************
// ******************************************* WINMM.DLL *****************************************************
// ***********************************************************************************************************
typedef HANDLE HDRVR;
typedef HANDLE HMIDI;
typedef HANDLE HMIDIIN;
typedef HANDLE HMIDIOUT;
typedef HANDLE HMIDISTRM;
typedef HANDLE HMIXEROBJ;
typedef HANDLE HMIXER;
typedef HMIXEROBJ *LPHMIXEROBJ;
typedef HMIXER *LPHMIXER;
typedef HMIDISTRM *LPHMIDISTRM;
typedef DWORD LPCWSTR;
typedef UINT MMRESULT;
typedef WORD VERSION;
typedef DWORD MCIERROR;                  // error return code, 0 means no error
typedef UINT MMVERSION;                  // major (high byte), minor (low byte)
typedef struct mmtime_tag
{
	UINT wType;                            // indicates the contents of the union
	DWORD timeData;                        // this is actually a union type
} MMTIME;
typedef struct midihdr_tag
{
	LPSTR       lpData;               // pointer to locked data block
	DWORD       dwBufferLength;       // length of data in data block
	DWORD       dwBytesRecorded;      // used for input only
	DWORD       dwUser;               // for client's use
	DWORD       dwFlags;              // assorted flags (see defines)
	midihdr_tag *lpNext;              // reserved for driver
	DWORD       reserved;             // reserved for driver
}MIDIHDR;
typedef struct midiincaps_tag
{
	UINT    wMid;                     // manufacturer ID
	UINT    wPid;                     // product ID
	VERSION vDriverVersion;           // version of the driver
	char szPname[32];                 // product name (NULL terminated string)
}MIDIINCAPS;
typedef struct midioutcaps_tag {
		UINT    wMid;                   // manufacturer ID
		UINT    wPid;                   // product ID
		VERSION vDriverVersion;         // version of the driver
		char    szPname[32];            // product name (NULL terminated string)
		UINT    wTechnology;            // type of device
		UINT    wVoices;                // # of voices (internal synth only)
		UINT    wNotes;                 // max # of notes (internal synth only)
		UINT    wChannelMask;           // channels used (internal synth only)
		DWORD   dwSupport;              // functionality supported by driver
}MIDIOUTCAPS;
typedef struct tagMIXERCAPSA
{
		WORD            wMid;                   // manufacturer id
		WORD            wPid;                   // product id
		MMVERSION       vDriverVersion;         // version of the driver
		CHAR            szPname[32];            // product name
		DWORD           fdwSupport;             // misc. support bits
		DWORD           cDestinations;          // count of destinations
}MIXERCAPSA,*PMIXERCAPSA,*LPMIXERCAPSA;
typedef struct tagMIXERCONTROLA
{
	DWORD  cbStruct;           // size in bytes of MIXERCONTROL */
	DWORD  dwControlID;        // unique control id for mixer device */
	DWORD  dwControlType;      // MIXERCONTROL_CONTROLTYPE_xxx */
	DWORD  fdwControl;         // MIXERCONTROL_CONTROLF_xxx */
	DWORD  cMultipleItems;     // if MIXERCONTROL_CONTROLF_MULTIPLE set */
	CHAR   szShortName[16];
	CHAR   szName[64];
	DWORD dwMinimum;
	DWORD dwMaximum;
	DWORD cSteps;
	DWORD cbCustomData;
	DWORD dwReserved[4];
}MIXERCONTROLA,*PMIXERCONTROLA,*LPMIXERCONTROLA;
typedef struct tMIXERCONTROLDETAILS
{
		DWORD           cbStruct;             // size in bytes of MIXERCONTROLDETAILS
		DWORD           dwControlID;          // control id to get/set details on
		DWORD           cChannels;            // number of channels in paDetails array
		DWORD hwndOwnerOrMultipleItemsUnion;  // see tMIXERCONTROLDETAILS
		DWORD           cbDetails;            // size of _one_ details_XX struct
		LPVOID          paDetails;            // pointer to array of details_XX structs
}MIXERCONTROLDETAILS,*PMIXERCONTROLDETAILS,*LPMIXERCONTROLDETAILS;
typedef struct tagMIXERLINECONTROLSA {
		DWORD           cbStruct;          // size in bytes of MIXERLINECONTROLS
		DWORD           dwLineID;          // line id (from MIXERLINE.dwLineID)
		DWORD           dwControlIDOrType; // depends on MIXR_GETLINECONTROLSF_ONEBYID
		DWORD           cControls;         // count of controls pmxctrl points to
		DWORD           cbmxctrl;          // size in bytes of _one_ MIXERCONTROL
		LPMIXERCONTROLA pamxctrl;          // pointer to first MIXERCONTROL array
}MIXERLINECONTROLSA,*PMIXERLINECONTROLSA,*LPMIXERLINECONTROLSA;

typedef struct tagMIXERLINEA
{
	DWORD       cbStruct;               // size of MIXERLINE structure
	DWORD       dwDestination;          // zero based destination index
	DWORD       dwSource;               // zero based source index (if source)
	DWORD       dwLineID;               // unique line id for mixer device
	DWORD       fdwLine;                // state/information about line
	DWORD       dwUser;                 // driver specific information
	DWORD       dwComponentType;        // component type line connects to
	DWORD       cChannels;              // number of channels line supports
	DWORD       cConnections;           // number of connections [possible]
	DWORD       cControls;              // number of controls at this line
	CHAR        szShortName[16];        // short name
	CHAR        szName[64];             // long name
	struct
	{
		DWORD   dwType;                   // MIXERLINE_TARGETTYPE_xxxx
		DWORD   dwDeviceID;               // target device ID of device type
		WORD    wMid;                     // of target device
		WORD    wPid;                     //
		MMVERSION vDriverVersion;         //
		CHAR    szPname[32];              //
	}Target;
}MIXERLINEA,*PMIXERLINEA,*LPMIXERLINEA;
typedef MIDIINCAPS *LPMIDIINCAPS;
typedef MIDIHDR *LPMIDIHDR;
typedef MMTIME *LPMMTIME;
HDRVR _pascal OpenDriver(LPCWSTR szDriverName,LPCWSTR szSectionName,LONG lParam);
LRESULT _pascal CloseDriver(HDRVR hDriver,LONG lParam1,LONG lParam2);
MMRESULT _pascal midiConnect(HMIDI hMidi,HMIDIOUT hMidiOut,LPVOID lpReserved);
MMRESULT _pascal midiDisconnect(HMIDI hMidi,HMIDIOUT hMidiOut,LPVOID lpReserved);
UINT _pascal midiInAddBuffer(HMIDIIN hMidiIn,MIDIHDR *lpMidiInHdr,UINT uSize);
UINT _pascal midiInClose(HMIDIIN hMidiIn);
UINT _pascal midiInGetDevCapsA(UINT uDeviceID,LPMIDIINCAPS lpCaps,UINT uSize);
UINT _pascal midiInGetErrorTextA(UINT uError,LPSTR lpText,UINT uSize);
UINT _pascal midiInGetID(HMIDIIN hMidiIn,UINT *lpuDeviceID);
UINT _pascal midiInGetNumDevs(void);
DWORD _pascal midiInMessage(HMIDIIN hMidiIn,UINT uMessage,DWORD dw1,DWORD dw2);
UINT _pascal midiInOpen(HMIDIIN *lphMidiIn,UINT uDeviceID,DWORD dwCallback,DWORD dwInstance,DWORD dwFlags);
UINT _pascal midiInPrepareHeader(HMIDIIN hMidiIn,MIDIHDR *lpMidiInHdr,UINT uSize);
UINT _pascal midiInReset(HMIDIIN hMidiIn);
UINT _pascal midiInStart(HMIDIIN hMidiIn);
UINT _pascal midiInStop(HMIDIIN hMidiIn);
UINT _pascal midiInUnprepareHeader(HMIDIIN hMidiIn,MIDIHDR *lpMidiInHdr,UINT uSize);
MMRESULT _pascal midiOutCachePatches(HMIDIOUT hMidiOut,UINT uBank,LPWORD pwpa,UINT fuCache);
MMRESULT _pascal midiOutCacheDrumPatches(HMIDIOUT hMidiOut,UINT uPatch,LPWORD pwkya,UINT fuCache);
MMRESULT _pascal midiOutClose(HMIDIOUT hMidiOut);
MMRESULT _pascal midiOutOpen(HMIDIOUT *lphMidiOut,UINT uDeviceID,DWORD dwCallback,DWORD dwInstance,DWORD dwFlags);
UINT _pascal midiOutLongMsg(HMIDIOUT hMidiOut,MIDIHDR *lpMidiHdrOut,UINT size);
DWORD _pascal midiOutMessage(HMIDIOUT hMidiOut,UINT uMessage,DWORD dw1,DWORD dw2);
UINT _pascal midiOutShortMsg(HMIDIOUT hMidiOut,DWORD dwMsg);
UINT _pascal midiOutGetDevCapsA(UINT uDeviceID,MIDIOUTCAPS *lpCaps,UINT uSize);
UINT _pascal midiOutGetErrorTextA(UINT uError,LPSTR lpText,UINT uSize);
UINT _pascal midiOutGetID(HMIDIOUT hMidiOut,UINT *lpuDeviceID);
UINT _pascal midiOutGetNumDevs(void);
UINT _pascal midiOutGetVolume(UINT uDeviceID,DWORD *lpdwVolume);
UINT _pascal midiOutPrepareHeader(HMIDIOUT hMidiOut,MIDIHDR *lpMidiOutHdr,UINT uSize);
UINT _pascal midiOutReset(HMIDIOUT hMidiOut);
UINT _pascal midiOutSetVolume(UINT uDeviceID,DWORD dwVolume);
UINT _pascal midiOutUnprepareHeader(HMIDIOUT hMidiOut,MIDIHDR *lpMidiOutHdr,UINT uSize);
MMRESULT _pascal midiStreamClose(HMIDISTRM hms);
MMRESULT _pascal midiStreamOpen(LPHMIDISTRM phms,LPUINT puDeviceID,DWORD cMidi,DWORD dwCallback,DWORD dwInstance,DWORD fdwOpen);
MMRESULT _pascal midiStreamOut(HMIDISTRM hms,LPMIDIHDR pmh,UINT cbmh);
MMRESULT _pascal midiStreamPause(HMIDISTRM hms);
MMRESULT _pascal midiStreamPosition(HMIDISTRM hms,LPMMTIME lpmmt,UINT cbmmt);
MMRESULT _pascal midiStreamProperty(HMIDISTRM hms,LPBYTE lppropdata, DWORD dwProperty);
MMRESULT _pascal midiStreamRestart(HMIDISTRM hms);
MMRESULT _pascal midiStreamStop(HMIDISTRM hms);
DWORD _pascal mciSendStringA(LPCSTR lpstrCommand,LPSTR lpstrReturnString,UINT uReturnLength,HWND hwndCallback);
DWORD _pascal mciSendCommandA(UINT uDeviceID,UINT uMessage,DWORD dwParam1,DWORD dwParam2);
BOOL _pascal sndPlaySoundA(LPCSTR lpszSoundName,UINT uFlags);
BOOL _pascal mciGetErrorStringA(MCIERROR mcierr,LPSTR pszText,UINT cchText);
MMRESULT _pascal mixerClose(HMIXER hmx);
UINT _pascal mixerGetNumDevs(void);
MMRESULT _pascal mixerGetDevCapsA(UINT mixerID,LPMIXERCAPSA pmxcaps,UINT cbmxcaps);
MMRESULT _pascal mixerOpen(LPHMIXER phmx,UINT mixerID,DWORD dwCallback,DWORD dwInstance,DWORD fdwOpen);
DWORD _pascal mixerMessage(HMIXER hmx,UINT uMsg,DWORD dwParam1,DWORD dwParam2);
MMRESULT _pascal mixerGetControlDetailsA(HMIXEROBJ hmxobj,LPMIXERCONTROLDETAILS pmxcd,DWORD fdwDetails);
MMRESULT _pascal mixerGetID(HMIXEROBJ hmxobj,UINT *puMxId,DWORD fdwId);
MMRESULT _pascal mixerSetControlDetails(HMIXEROBJ hmxobj,LPMIXERCONTROLDETAILS pmxcd,DWORD fdwDetails);

// the mixer line functions get called frequently, as a result they are time consuming
// to output.  The following two functions should be used judiciously.
//MMRESULT _pascal mixerGetLineControlsA(HMIXEROBJ hmxobj,LPMIXERLINECONTROLSA pmxlc,DWORD fdwControls);
//MMRESULT _pascal mixerGetLineInfoA(HMIXEROBJ hmxobj,LPMIXERLINEA pmxl,DWORD fdwInfo);

// ***********************************************************************************************************
// ******************************************* GDI32.DLL *****************************************************
// ***********************************************************************************************************
typedef DWORD COLORREF;
typedef HANDLE HGDIOBJ;
typedef HANDLE HRGN;
typedef struct _devicemodeA
{
	BYTE dmDeviceName[32];
	WORD dmSpecVersion;
	WORD dmDriverVersion;
	WORD dmSize;
	WORD dmDriverExtra;
	DWORD dmFields;
	short dmOrientation;
	short dmPaperSize;
	short dmPaperLength;
	short dmPaperWidth;
	short dmScale;
	short dmCopies;
	short dmDefaultSource;
	short dmPrintQuality;
	short dmColor;
	short dmDuplex;
	short dmYResolution;
	short dmTTOption;
	short dmCollate;
	BYTE dmFormName[32];
	WORD dmLogPixels;
	DWORD dmBitsPerPel;
	DWORD dmPelsWidth;
	DWORD dmPelsHeight;
	DWORD dmDisplayFlags;
	DWORD dmDisplayFrequency;
	DWORD dmICMMethod;
	DWORD dmICMIntent;
	DWORD dmMediaType;
	DWORD dmDitherType;
	DWORD dmReserved1;
	DWORD dmReserved2;
}DEVMODEA,*PDEVMODEA,*NPDEVMODEA,*LPDEVMODEA;
typedef struct tagPALETTEENTRY
{
	BYTE peRed;
	BYTE peGreen;
	BYTE peBlue;
	BYTE peFlags;
}PALETTEENTRY,*PPALETTEENTRY,*LPPALETTEENTRY;
typedef struct tagBITMAP
{
	LONG        bmType;
	LONG        bmWidth;
	LONG        bmHeight;
	LONG        bmWidthBytes;
	WORD        bmPlanes;
	WORD        bmBitsPixel;
	LPVOID      bmBits;
}BITMAP,*PBITMAP,*NPBITMAP,*LPBITMAP;

typedef struct tagBITMAPINFOHEADER
{
	DWORD biSize;
	LONG biWidth;
	LONG biHeight;
	WORD biPlanes;
	WORD biBitCount;
	DWORD biCompression;
	DWORD biSizeImage;
	LONG biXPelsPerMeter;
	LONG biYPelsPerMeter;
	DWORD biClrUsed;
	DWORD biClrImportant;
}BITMAPINFOHEADER,*LPBITMAPINFOHEADER,*PBITMAPINFOHEADER;
typedef struct tagRGBQUAD
{
	BYTE rgbBlue;
	BYTE rgbGreen;
	BYTE rgbRed;
	BYTE rgbReserved;
}RGBQUAD;
typedef struct tagBITMAPINFO
{
	BITMAPINFOHEADER bmiHeader;
	RGBQUAD bmiColors[1];
}BITMAPINFO,*LPBITMAPINFO,*PBITMAPINFO;
typedef struct tagLOGFONTA
{
	LONG lfHeight;
	LONG lfWidth;
	LONG lfEscapement;
	LONG lfOrientation;
	LONG lfWeight;
	BYTE lfItalic;
	BYTE lfUnderline;
	BYTE lfStrikeOut;
	BYTE lfCharSet;
	BYTE lfOutPrecision;
	BYTE lfClipPrecision;
	BYTE lfQuality;
	BYTE lfPitchAndFamily;
	CHAR lfFaceName[32];
}LOGFONTA,*PLOGFONTA,*NPLOGFONTA,*LPLOGFONTA;
typedef struct tagLOGPALETTE
{
	WORD palVersion;
	WORD palNumEntries;
	PALETTEENTRY palPalEntry[1];
}LOGPALETTE,*PLOGPALETTE,*NPLOGPALETTE,*LPLOGPALETTE;
typedef HANDLE HPALETTE;
typedef HANDLE HFONT;
typedef struct tagSIZE
{
	int cx;
	int cy;
}SIZE;
typedef SIZE *PSIZE;
typedef SIZE *NPSIZE;
typedef SIZE *LPSIZE;
int _pascal MessageBoxA(HWND hParentWnd,LPCSTR lpMessOne,LPCSTR lpMessTwo,UINT flags);
HWND _pascal CreateWindowExA(DWORD styleEx,LPSTR lpszClassName,LPSTR lpszWindowName,DWORD style,int x,int y,int width,int height,HWND hParent,HMENU hMenu,HINSTANCE hInstance,LPVOID lpCreationData);
BOOL _pascal AnimatePalette(HPALETTE hPalette,UINT entryFirst,UINT entriesInPalette,PALETTEENTRY *lpPaletteEntry);
void _pascal ByeByeGDI(DWORD someDWORD);
BOOL _pascal CancelDC(HDC hDC);
HBITMAP _pascal CreateBitmap(int nWidth,int nHeight,UINT cPlanes,UINT cBitsPerPixel,void *lpvBits);
HBITMAP _pascal CreateBitmapIndirect(BITMAP *lpBitmap);
HBITMAP _pascal CreateCompatibleBitmap(HDC hDC,int nWidth,int nHeight);
HDC _pascal CreateCompatibleDC(HDC hDC);
HDC _pascal CreateDCA(LPCSTR lpszDriver,LPCSTR lpszDevice,LPCSTR lpszOutput,DEVMODEA *lpInitData);
HBRUSH _pascal CreateDIBPatternBrush(HGLOBAL hglbDIBPacked,UINT fuColorSpace);
HBRUSH _pascal CreateDIBPatternBrushPt(void *lpPackedDIB,UINT iUsage);
HBITMAP _pascal CreateDIBSection(HDC hdc,BITMAPINFO *pbmi,UINT iUsage,void **ppvBits,HANDLE hSection,DWORD dwOffset);
HBITMAP _pascal CreateDIBitmap(HDC hdc,BITMAPINFOHEADER *lpbmih,DWORD fdwInit,VOID *lpbInit,BITMAPINFO *lpbmi,UINT fuUsage);
HBITMAP _pascal CreateDiscardableBitmap(HDC hdc,int nWidth,int nHeight);
HFONT _pascal CreateFontA(int nHeight,int nWidth,int nEscapement,int nOrientation,int fnWeight,DWORD fdwItalic,DWORD fdwUnderline,DWORD fdwStrikeOut,DWORD fdwCharSet,DWORD fdwOutputPrecision,DWORD fdwClipPrecision,DWORD fdwQuality,DWORD fdwPitchAndFamily,LPCTSTR lpszFace);
HFONT _pascal CreateFontIndirectA(LOGFONTA *lpLogFont);
HPALETTE _pascal CreatePalette(LOGPALETTE *lpLogPalette);
LONG _pascal GetBitmapBits(HBITMAP hBitmap,LONG cbBuffer,LPVOID lpvBits);
BOOL _pascal GetBitmapDimensionEx(HBITMAP hBitmap,LPSIZE lpDimension);
UINT _pascal GetDIBColorTable(HDC hDC,UINT uStartIndex,UINT uEntries,RGBQUAD *pColors);
int _pascal GetDIBits(HDC hDC,HBITMAP hBitmap,UINT uStartScan,UINT cScanLines,LPVOID lpvBits,LPBITMAPINFO lpBitmapInfo,UINT uUsage);
int _pascal GetDeviceCaps(HDC hDC,int nIndex);
BOOL _pascal GetDeviceGammaRamp(HDC hDC,LPVOID lpRamp);
COLORREF _pascal GetNearestColor(HDC hDC,COLORREF crColor);
UINT _pascal GetNearestPaletteIndex(HPALETTE hPalette,COLORREF crColor);
int _pascal GetObjectA(HGDIOBJ hgdiObj,int cbBuffer,LPVOID lpvObject);
DWORD _pascal GetObjectType(HGDIOBJ hgdiObj);
UINT _pascal GetPaletteEntries(HPALETTE hPalette,UINT uStartIndex,UINT uEntries,LPPALETTEENTRY lpPaletteEntry);
COLORREF _pascal GetPixel(HDC hDC,int nxPos,int nyPos);
int _pascal GetROP2(HDC hDC);
UINT _pascal GetSystemPaletteUse(HDC hDC);
BOOL _pascal MaskBlt(HDC hdcDest,int nXDest,int nYDest,int nWidth,int nHeight,HDC hdcSrc,int nXSrc,int nYSrc,HBITMAP hbmMask,int xMask,int yMask,DWORD dwRop);
BOOL _pascal PaintRgn(HDC hDC,HRGN hRegion);
BOOL _pascal PatBlt(HDC hdc,int nXLeft,int nYLeft,int nWidth,int nHeight,DWORD dwRop);
BOOL _pascal PlgBlt(HDC hDCDest,POINT *lpPoint,HDC hDCSrc,int nXSrc,int nYSrc,int nWidth,int nHeight,HBITMAP hbmMask,int xMask,int yMask);
UINT _pascal RealizePalette(HDC hdc);
BOOL _pascal ResizePalette(HPALETTE hPalette,UINT uEntries);
HGDIOBJ _pascal SelectObject(HDC hdc,HGDIOBJ hgdiobj);  
HPALETTE _pascal SelectPalette(HDC hDC,HPALETTE hPalette,BOOL bForceBackground);
LONG _pascal SetBitmapBits(HBITMAP hBitmap,DWORD cBytes,LPVOID lpvBits);
BOOL _pascal SetBitmapDimensionEx(HBITMAP hBitmap,int nWidth,int nHeight,LPSIZE lpSize);
UINT _pascal SetDIBColorTable(HDC hDC,UINT uStartIndex,UINT uEntries,RGBQUAD *pColors);
int _pascal SetDIBits(HDC hDC,HBITMAP hbmp,UINT uStartScan,UINT cScanLines,LPVOID lpvBits,LPBITMAPINFO lpbmi,UINT fuColorUse);	
int _pascal SetDIBitsToDevice(HDC hdc,int XDest,int YDest,DWORD dwWidth,DWORD dwHeight,int XSrc,int YSrc,UINT uStartScan,UINT cScanLines,LPVOID lpvBits,LPBITMAPINFO lpbmi,UINT fuColorUse);	
int _pascal SetROP2(HDC hDC,int fnDrawMode);
int _pascal SetStretchBltMode(HDC hDC,int stretchMode);
BOOL _pascal StretchBlt(HDC hdcDest,int nXOriginDest,int nYOriginDest,int nWidthDest,int nHeightDest,HDC hdcSrc,int nXOriginSrc,int nYOriginSrc,int nWidthSrc,int nHeightSrc,DWORD dwRop);
int _pascal StretchDIBits(HDC hdc,int XDest,int YDest,int nDestWidth,int nDestHeight,int XSrc,int YSrc,int nSrcWidth,int nSrcHeight,LPVOID lpBits,LPBITMAPINFO lpBitsInfo,UINT iUsage,DWORD dwRop);
BOOL _pascal TextOutA(HDC hdc,int nXStart,int nYStart,LPCTSTR lpString,int cbString);

// ******************************************************************************************************
// ******************************************* ADVAPI32.DLL *********************************************
// ******************************************************************************************************
typedef DWORD REGSAM;
LONG _pascal RegConnectRegistryA(LPTSTR lpszComputerName,HKEY hKey,PHKEY phkResult);
LONG _pascal RegCreateKeyA(HKEY hKey,LPCTSTR lpszSubKey,PHKEY phkResult);
LONG _pascal RegCreateKeyExA(HKEY hKey,LPCTSTR lpszSubKey,DWORD dwReserved,LPTSTR lpszClass,DWORD fdwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition);
LONG _pascal RegDeleteKeyA(HKEY hKey,LPCTSTR lpszSubKey);
LONG _pascal RegDeleteValueA(HKEY hKey,LPTSTR lpszValue);
LONG _pascal RegEnumKeyA(HKEY hKey,DWORD iSubKey,LPTSTR lpszName,DWORD cchName);
LONG _pascal RegEnumKeyExA(HKEY hKey,DWORD iSubkey,LPTSTR lpszName,LPDWORD lpcchName,LPDWORD lpdwReserved,LPTSTR lpszClass,LPDWORD lpcchClass,PFILETIME lpftLastWrite);	
LONG _pascal RegEnumValueA(HKEY hKey,DWORD iValue,LPTSTR lpszValue,LPDWORD lpcchValue,LPDWORD lpdwReserved,LPDWORD lpdwType,LPBYTE lpbData,LPDWORD lpcbData);	
LONG _pascal RegLoadKeyA(HKEY hKey,LPCTSTR lpszSubKey,LPCTSTR lpszFile);
LONG _pascal RegOpenKeyA(HKEY hKey,LPCTSTR lpszSubKey,PHKEY phkResult);	
LONG _pascal RegOpenKeyExA(HKEY hKey,LPCTSTR lpszSubKey,DWORD dwReserved,REGSAM samDesired,PHKEY phkResult);
LONG _pascal RegQueryInfoKeyA(HKEY hKey,LPTSTR lpszClass,LPDWORD lpcchClass,LPDWORD lpdwReserved,LPDWORD lpcSubKeys,LPDWORD lpcchMaxSubkey,LPDWORD lpcchMaxClass,LPDWORD lpcValues,LPDWORD lpcchMaxValueName,LPDWORD lpcbMaxValueData,LPDWORD lpcbSecurityDescriptor,PFILETIME lpftLastWriteTime);
LONG _pascal RegQueryValueA(HKEY hKey,LPCTSTR lpszSubKey,LPTSTR lpszValue,PLONG pcbValue);	
LONG _pascal RegQueryValueExA(HKEY hKey,LPTSTR lpszValueName,LPDWORD lpdwReserved,LPDWORD lpdwType,LPBYTE lpbData,LPDWORD lpcbData);
LONG _pascal RegReplaceKeyA(HKEY hKey,LPCTSTR lpSubKey,LPCTSTR lpNewFile,LPCTSTR lpOldFile);	
LONG _pascal RegRestoreKeyA(HKEY hKey,LPCTSTR lpszFile,DWORD fdw);	
LONG _pascal RegSaveKeyA(HKEY hKey,LPCTSTR lpszFile,LPSECURITY_ATTRIBUTES lpsa);	
LONG _pascal RegSetValueA(HKEY hKey,LPCTSTR lpSubKey,DWORD dwType,LPCTSTR lpData,DWORD cbData);	
LONG _pascal RegSetValueExA(HKEY hKey,LPCTSTR lpValueName,DWORD Reserved,DWORD dwType,BYTE *lpData,DWORD cbData);	
LONG _pascal RegUnLoadKeyA(HKEY hKey,LPCTSTR lpszSubKey);
LONG _pascal RegCloseKey(HKEY hKey);	

// ******************************************************************************************************
// ******************************************* OPENGL32.DLL *********************************************
// ******************************************************************************************************
typedef HANDLE HGLRC;

typedef struct tagPIXELFORMATDESCRIPTOR
{
    WORD  nSize;
    WORD  nVersion;
    DWORD dwFlags;
    BYTE  iPixelType;
    BYTE  cColorBits;
    BYTE  cRedBits;
    BYTE  cRedShift;
    BYTE  cGreenBits;
    BYTE  cGreenShift;
    BYTE  cBlueBits;
    BYTE  cBlueShift;
    BYTE  cAlphaBits;
    BYTE  cAlphaShift;
    BYTE  cAccumBits;
    BYTE  cAccumRedBits;
    BYTE  cAccumGreenBits;
    BYTE  cAccumBlueBits;
    BYTE  cAccumAlphaBits;
    BYTE  cDepthBits;
    BYTE  cStencilBits;
    BYTE  cAuxBuffers;
    BYTE  iLayerType;
    BYTE  bReserved;
    DWORD dwLayerMask;
    DWORD dwVisibleMask;
    DWORD dwDamageMask;
}PIXELFORMATDESCRIPTOR,*PPIXELFORMATDESCRIPTOR;
typedef double GLdouble;
typedef int GLint;
typedef int GLenum;
typedef int GLboolean;
typedef float GLfloat;

BOOL _pascal wglMakeCurrent(HDC hDC,HGLRC hGLRC);
void _pascal glClear(unsigned int mask);
void _pascal glBegin(int mode);
HGLRC _pascal wglCreateContext(HDC hDC);
BOOL _pascal wglDeleteContext(HGLRC hGLRC);
void _pascal glShadeModel(int mode);
void _pascal glClearColor(float red,float green,float blue,float alpha);
int _pascal ChoosePixelFormat(HDC hDC,PPIXELFORMATDESCRIPTOR pPixelFormatDescriptor);
void _pascal glMatrixMode(int mode);
void _pascal glLoadIdentity(void);
void _pascal glNewList(unsigned int list,int mode);
void _pascal glEndList(void);
void _pascal glPushMatrix(void);
void _pascal glRotatef(GLfloat angle,GLfloat x,GLfloat y,GLfloat z);
void _pascal glTranslatef(GLfloat x,GLfloat y,GLfloat z);
void _pascal glPopMatrix(void);
BOOL _pascal SwapBuffers(HDC hDC);

// ******************************************************************************************************
// ******************************************* WSOCK32.DLL *********************************************
// ******************************************************************************************************
//int _pascal socket(int af,int type,int protocol);

// ******************************************************************************************************
// ******************************************* WSOCK32.DLL *********************************************
// ******************************************************************************************************
typedef HANDLE HIMAGELIST;
HIMAGELIST _pascal ImageList_Create(int cx,int cy,UINT flags,int cInitial,int cGrow);
BOOL _pascal ImageList_DragMove(int x,int y);
BOOL _pascal ImageList_BeginDrag(HIMAGELIST himlTrack,int iTrack,int dxHotSpot,int dyHotSpot);
BOOL _pascal ImageList_DragEnter(HWND hwndLock,int x,int y);
BOOL _pascal ImageList_DragLeave(HWND hwndLock);
BOOL _pascal ImageList_DragShowNolock(BOOL fShow);
HIMAGELIST _pascal ImageList_GetDragImage(NPPOINT ppt,NPPOINT pptHotSpot);
BOOL _pascal ImageList_SetDragCursorImage(HIMAGELIST himlDrag,int iDrag,int dxHotspot,int dyHotSpot);
BOOL _pascal ImageList_EndDrag(void);
HIMAGELIST _pascal ImageList_LoadImage(HINSTANCE hProcessInstance,LPCSTR lpBmp,int cx,int cGrow,COLORREF crMask,UINT uType,UINT uFlags);
// ******************************************************************************************************
// ******************************************* COMCTL32.DLL *********************************************
// ******************************************************************************************************
//HWND CreateToolbarEx(HWND hwnd,DWORD ws,UINT wID,int nBitmaps,HINSTANCE hBMInst,UINT wBMID,void *lpButtons,int iNumButtons,int dxButton,int dyButton,int dxBitmap,int dyBitmap,UINT uStructSize);





