/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class Spinner
extends Component {
    protected int value;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected ActionListener actionListener;
    protected Polygon upArrow = new Polygon();
    protected Polygon dnArrow = new Polygon();
    protected Polygon upPressedArrow = new Polygon();
    protected Polygon dnPressedArrow = new Polygon();
    protected boolean upPressed;
    protected boolean dnPressed;
    protected boolean rollsOver = false;
    protected long oldMouseClickTime;
    private String _$6826 = "which?";
    private static long _$24449 = 150L;
    public boolean Changed = false;

    public Spinner() {
        this.enableEvents(16L);
    }

    public Spinner(int n) {
        this();
        this.value = n;
    }

    public Spinner(int n, int n2, int n3) {
        this();
        this.value = n;
        this.minValue = n2;
        this.maxValue = n3;
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.adjustSize(this.getGraphics()));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.getSize().width != 0 && this.getSize().height != 0) {
            return this.getSize();
        }
        return this.adjustSize(this.getGraphics());
    }

    public synchronized void setValue(int n) {
        this.value = n;
        this.repaint();
    }

    public synchronized void setLimits(int n, int n2) {
        this.minValue = n;
        this.maxValue = n2;
    }

    public int getValue() {
        return this.value;
    }

    public synchronized void setMinValue(int n) {
        this.minValue = n;
        this.setValue(this.minValue);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public synchronized void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setRollsOver(boolean bl) {
        this.rollsOver = bl;
    }

    public boolean getRollsOver() {
        return this.rollsOver;
    }

    public void setActionCommand(String string) {
        this._$6826 = string;
    }

    public String getActionCommand() {
        return this._$6826;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected Dimension adjustSize(Graphics graphics) {
        this.upArrow.addPoint(32, 10);
        this.upArrow.addPoint(46, 10);
        this.upArrow.addPoint(39, 3);
        this.dnArrow.addPoint(39, 19);
        this.dnArrow.addPoint(33, 13);
        this.dnArrow.addPoint(45, 13);
        this.upPressedArrow.addPoint(39, 5);
        this.upPressedArrow.addPoint(34, 11);
        this.upPressedArrow.addPoint(44, 11);
        this.dnPressedArrow.addPoint(39, 20);
        this.dnPressedArrow.addPoint(34, 14);
        this.dnPressedArrow.addPoint(44, 14);
        return new Dimension(48, 24);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getBackground().brighter();
        Color color2 = this.getBackground().darker();
        graphics.setColor(color);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(color2);
        graphics.drawLine(2, n2 - 2, n, n2 - 2);
        graphics.drawLine(1, n2 - 1, n, n2 - 1);
        graphics.drawLine(n, 0, n, n2);
        graphics.drawLine(n - 1, 1, n - 1, n2);
        Rectangle rectangle = new Rectangle(5, 4, n - 23, n2 - 9);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = n3 + n5 - 1;
        int n8 = n4 + n6 - 1;
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.fillRect(n3 - 1, n4 - 1, n5 + 2, n6 + 2);
        if (!this.upPressed) {
            graphics.fillPolygon(this.upArrow);
        } else {
            graphics.fillPolygon(this.upPressedArrow);
        }
        if (!this.dnPressed) {
            graphics.fillPolygon(this.dnArrow);
        } else {
            graphics.fillPolygon(this.dnPressedArrow);
        }
        graphics.setColor(color);
        graphics.drawLine(n3, n8 + 1, n7 + 1, n8 + 1);
        graphics.drawLine(n7 + 1, n4 + 1, n7 + 1, n8 + 1);
        graphics.setFont(new Font("Dialog", 1, 14));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = fontMetrics.stringWidth("".concat(String.valueOf(this.value)));
        int n10 = n4 + fontMetrics.getHeight() / 2 + 4;
        int n11 = n3 + (n5 - n9) / 2 + 1;
        graphics.setColor(Color.green.darker());
        graphics.drawString("".concat(String.valueOf(this.value)), n11, n10);
    }

    private void _$24711() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    public void increment() {
        if (this.value < this.maxValue) {
            ++this.value;
            this._$24711();
        } else if (this.rollsOver) {
            this.value = this.minValue;
            this._$24711();
        }
    }

    public void decrement() {
        if (this.value > this.minValue) {
            --this.value;
            this._$24711();
        } else if (this.rollsOver) {
            this.value = this.maxValue;
            this._$24711();
        }
    }

    public void spin() {
        class SpinThread
        extends Thread {
            final /* synthetic */ Spinner this$0;

            SpinThread(Spinner spinner) {
                this.this$0 = spinner;
                this.setPriority(1);
            }

            public void run() {
                try {
                    if (this.this$0.upPressed) {
                        this.this$0.increment();
                    }
                    if (this.this$0.dnPressed) {
                        this.this$0.decrement();
                    }
                    this.this$0.repaint();
                    Thread.sleep(1250L);
                    while (this.this$0.upPressed || this.this$0.dnPressed) {
                        if (this.this$0.upPressed) {
                            this.this$0.increment();
                        }
                        if (this.this$0.dnPressed) {
                            this.this$0.decrement();
                        }
                        this.this$0.repaint();
                        Thread.sleep(400L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        new SpinThread(this).start();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    long l = System.currentTimeMillis();
                    if (l - this.oldMouseClickTime > _$24449) {
                        if (this.upArrow.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
                            this.upPressed = true;
                            this.spin();
                        } else if (this.dnArrow.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
                            this.dnPressed = true;
                            this.spin();
                        }
                    }
                    this.oldMouseClickTime = l;
                    break;
                }
                case 502: {
                    if (this.upPressed) {
                        this.upPressed = false;
                    } else if (this.dnPressed) {
                        this.dnPressed = false;
                    }
                    this.repaint();
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }
}

