// DBFSampleView.cpp : implementation of the CDBFSampleView class
//

#include "stdafx.h"
#include "DBFSample.h"

#include "DBFSampleDoc.h"
#include "DBFSampleView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "EmployeeDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CDBFSampleView

IMPLEMENT_DYNCREATE(CDBFSampleView, CListView)

BEGIN_MESSAGE_MAP(CDBFSampleView, CListView)
	//{{AFX_MSG_MAP(CDBFSampleView)
	ON_WM_CREATE()
	ON_COMMAND(ID_RECORD_OPEN, OnRecordOpen)
	ON_COMMAND(ID_RECORD_NEW, OnRecordNew)
	ON_COMMAND(ID_RECORD_DELETE, OnRecordDelete)
	ON_COMMAND(ID_DBF_SHOW_DELETED, OnShowDeleted)
	ON_UPDATE_COMMAND_UI(ID_DBF_SHOW_DELETED, OnUpdateDbfShowDeleted)
	ON_UPDATE_COMMAND_UI(ID_RECORD_DELETE, OnUpdateRecordDelete)
	ON_COMMAND(ID_DBF_PACK, OnDbfPack)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDBFSampleView construction/destruction

CDBFSampleView::CDBFSampleView()
{
	CString sDBFName = GetStartDir() + "\\employee.dbf";
	if (!m_DBFTable.Open(sDBFName))
		AfxMessageBox("Unable to open file " + sDBFName);
}

CDBFSampleView::~CDBFSampleView()
{
}

BOOL CDBFSampleView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CDBFSampleView drawing

void CDBFSampleView::OnDraw(CDC* pDC)
{
	CDBFSampleDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

void CDBFSampleView::OnInitialUpdate()
{
	CListView::OnInitialUpdate();
	GetDocument()->SetTitle("Employee.dbf");
	FillRecords();
}

/////////////////////////////////////////////////////////////////////////////
// CDBFSampleView diagnostics

#ifdef _DEBUG
void CDBFSampleView::AssertValid() const
{
	CListView::AssertValid();
}

void CDBFSampleView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CDBFSampleDoc* CDBFSampleView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDBFSampleDoc)));
	return (CDBFSampleDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDBFSampleView message handlers

int CDBFSampleView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	lpCreateStruct->style |= LVS_REPORT;
	if (CListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	DWORD dwExStyle =  LVS_EX_FULLROWSELECT  | LVS_EX_HEADERDRAGDROP /*| LVS_SHOWSELALWAYS*/;
	GetListCtrl().SendMessage(LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LPARAM(dwExStyle));

	const DBFField* pFieldArray = m_DBFTable.GetFields();
	GetListCtrl().InsertColumn(0, "", LVCFMT_LEFT, 10);
	GetListCtrl().InsertColumn(1, "#", LVCFMT_LEFT, 30);
	for (int i=0; i<m_DBFTable.GetFieldCount(); i++)
		GetListCtrl().InsertColumn(i+2, pFieldArray[i].FieldName, LVCFMT_LEFT, 100);
	
	return 0;
}

void CDBFSampleView::OnRecordOpen() 
{
	int iRecNo = GetListCtrl().GetNextItem(-1, LVNI_ALL|LVIS_FOCUSED);
	if (iRecNo == -1)
	{
		AfxMessageBox("Please select a record");
		return;
	}

	iRecNo++;
	m_DBFTable.MoveTo(iRecNo);

	CEmployeeDlg dlg;
	dlg.m_iID        = m_DBFTable.GetInt("ID");
	dlg.m_sFirstName = m_DBFTable.GetStringField("FIRST_NAME");
	dlg.m_sLastName  = m_DBFTable.GetStringField("LAST_NAME");
	dlg.m_sBirthDay  = m_DBFTable.GetStringField("BIRTHDAY");
	dlg.m_dSalary    = m_DBFTable.GetFloatField("SALARY");
	dlg.m_bIsManager = m_DBFTable.GetBoolField("IS_MANAGER");

	if (dlg.DoModal() == IDOK)
	{
		m_DBFTable.Edit();
		m_DBFTable.PutInt("ID", dlg.m_iID);
		m_DBFTable.SetStringField("FIRST_NAME", dlg.m_sFirstName);
		m_DBFTable.SetStringField("LAST_NAME", dlg.m_sLastName);
		m_DBFTable.SetStringField("BIRTHDAY", dlg.m_sBirthDay);
		m_DBFTable.SetFloatField("SALARY", dlg.m_dSalary);
		m_DBFTable.SetBoolField("IS_MANAGER", dlg.m_bIsManager);
		m_DBFTable.Post();
		FillRecords();
	}
}

void CDBFSampleView::FillRecords()
{
	GetListCtrl().DeleteAllItems();
	m_DBFTable.MoveTop();

	while (!m_DBFTable.GetEOF())
	{
		CString sRecNo;
		int		i;
		sRecNo.Format("%d", m_DBFTable.GetRecNo());
		GetListCtrl().InsertItem(GetListCtrl().GetItemCount(), "");
		GetListCtrl().SetItemText(GetListCtrl().GetItemCount()-1, 1, sRecNo);
		for(i=0; i<m_DBFTable.GetFieldCount(); i++)
		{
			GetListCtrl().SetItemText(GetListCtrl().GetItemCount()-1, i+2, m_DBFTable.GetStringField(i));
		}

		if (m_DBFTable.GetDeleted())
			GetListCtrl().SetItemText(GetListCtrl().GetItemCount()-1, 0, "*");

		m_DBFTable.Skip();
	}
}

void CDBFSampleView::OnRecordNew() 
{
	CEmployeeDlg dlg;
	if (dlg.DoModal() == IDOK)
	{
		m_DBFTable.Append();
		m_DBFTable.PutInt("ID", dlg.m_iID);
		m_DBFTable.SetStringField("FIRST_NAME", dlg.m_sFirstName);
		m_DBFTable.SetStringField("LAST_NAME", dlg.m_sLastName);
		m_DBFTable.SetStringField("BIRTHDAY", dlg.m_sBirthDay);
		m_DBFTable.SetFloatField("SALARY", dlg.m_dSalary);
		m_DBFTable.SetBoolField("IS_MANAGER", dlg.m_bIsManager);
		m_DBFTable.Post();
		FillRecords();
	}
}

void CDBFSampleView::OnRecordDelete() 
{
	int iRecNo = GetListCtrl().GetNextItem(-1, LVNI_ALL|LVIS_FOCUSED);
	if (iRecNo == -1)
	{
		AfxMessageBox("Please select a record");
		return;
	}
	iRecNo++;
	m_DBFTable.MoveTo(iRecNo);
	if (!m_DBFTable.GetDeleted())
		m_DBFTable.Delete();
	else
		m_DBFTable.Recall();
	FillRecords();
}

void CDBFSampleView::OnShowDeleted() 
{
	m_DBFTable.SetShowDeleted(!m_DBFTable.GetShowDeleted());
	FillRecords();
}

void CDBFSampleView::OnUpdateDbfShowDeleted(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_DBFTable.GetShowDeleted());
}

void CDBFSampleView::OnUpdateRecordDelete(CCmdUI* pCmdUI) 
{
	int iRecNo = GetListCtrl().GetNextItem(-1, LVNI_ALL|LVIS_FOCUSED);
	if (iRecNo == -1)
		return;

	iRecNo++;
	m_DBFTable.MoveTo(iRecNo);
	if (!m_DBFTable.GetDeleted())
		pCmdUI->SetText("&Delete");
	else
		pCmdUI->SetText("&Recall");
}

void CDBFSampleView::OnDbfPack() 
{
	m_DBFTable.Pack();
	FillRecords();
}

CString CDBFSampleView::GetStartDir()
{
	char pszFileName[MAX_PATH + 1];
	CString sResult;
	int i;

//	retrieving name of EXE file
	GetModuleFileName(AfxGetApp()->m_hInstance, pszFileName, MAX_PATH);

//	removing file name
	sResult = pszFileName;
	for (i=sResult.GetLength()-1; i>=0; i--)
		if (sResult[i] == 92)
			return sResult.Left(i);
	return "";
}
