<%@ Language=VBScript %>
<% Option Explicit %>
<%
'How to make this script to work on Win9x/Me?
'1. Install Microsoft Personal Web Server (PWS) which is included on your Win9x/Me setup CD-ROM.
'	 Browse to E:\Add-ons\Pws\ (substitute your CD-ROM drive letter for E) and run Setup.exe.
'2  Assume you have installed PWS to C:\Inetpub.
'3. Create a directory called "Netscan" in C:\Inetpub and put the scanned results into it.
'   Assume you have named the scanned result of "Network A" as "ScanOut1.mdb".
'   Assume you have named the scanned result of "Network B" as "ScanOut2.mdb".
'   If not, follow the step 4 and 5.
'4. Find "ScanOut1.mdb" and "ScanOut2.mdb" in this script. Change them to the correct file names.
'5	 Find "Network A" and "Network B" in this script. Change them to some relevant descriptions.
'6. Launch Personal Web Manager of PWS and select "Advanced" tab at the lower left.
'   From the "Home" directory in the list of "Virtual Directories", click "Add".
'	 In the next dialog box popped up, fill "Directory" with "C:\Inetpub\Netscan" and type "netscan"
'	 in "Alias". By doing so, you make "C:\Inetpub\Netscan" a virtual directory called "/netscan"
'	 on PWS. Ensure the "Execute" and "Scripts" blocks are checked.
'7. Put this script into C:\Inetpub\Scripts.
'8. Start PWS. Open a browser window and go to http://localhost/scripts/netscan.asp. Nota that
'   "/scripts" is a default PWS virtual directory with "Execute" and "Scripts" enabled. If not
'	 existing, add it manually.
%>

<HTML>
<HEAD>
<META NAME="GENERATOR" Content="Microsoft Visual Studio 6.0 & NetScan">
<TITLE>Online NetScan Search</TITLE>
</HEAD>
<BODY>

<%

On Error Resume Next

' Constants
const adOpenForwardOnly = 0 ' Forward only movement through records
const adOpenKeyset      = 1 ' Movement any direction
const adOpenDynamic = 2
const adOpenStatic  = 3
const adLockOptimistic = 3

' CheckError: Checks for, and reports errors.
' Returns True if an error has occured, False otherwise
Function CheckError()
	If Err.number <> 0 Then
		Response.Write "<p><FONT color=red><I>A run-time error occurred.<BR>Error Number: " &_
                           Err.number & "<BR>Error Description: " & Err.description & "</Font></I>"
		CheckError = True
	Else
		CheckError = False
	End If
End Function

' OpenDatabase: Opens a database connection
' IN:
' - DatabaseVirtualFilename: Virtual path to database file (.mdb)
' - Username: Username
' - Password: Password
' OUT:
' - Connection: The database connection
' RETURNS:
' - True if successful, False otherwise
Function OpenDatabase(DatabaseVirtualFilename, Username, Password, byref Connection)

	' Initialise
	OpenDatabase = False

	Dim DatabaseFilename
	DatabaseFilename = Server.MapPath(DatabaseVirtualFilename)

	Dim ConnectionString
	ConnectionString = "DRIVER={Microsoft Access Driver (*.mdb)};" &_
	                   "DBQ=" & DatabaseFilename & ";DefaultDir=;" &_
	                   "UID=" & Username & ";" &_
	                   "PWD=" & Password & ";"

	Set Connection = Server.CreateObject("ADODB.Connection")
	Connection.ConnectionTimeout = 30
	Connection.CommandTimeout = 80
	Connection.Open ConnectionString

	OpenDatabase = True

End Function

' Convert wild card form from InterDev to Access SQL
Function WildCardFormInInterDev(WildCardFormInSQL)
	WildCardFormInInterDev = Replace(WildCardFormInSQL, "?", "_")
	WildCardFormInInterDev = Replace(WildCardFormInInterDev, "*", "%")
End Function

' DisplayQuery: Displays the contents of a query
' IN:
' - Connection: 	Connection to a database
' - GroupRange: 	Limit
' - ComRange:   	Limit
' - ShareRange: 	Limit
' - Category:    	Category
' - FileNameNoExtension: FileName
' - Extension:  	Extension
' - SizeHigh: 		High bound
' - SizeLow: 		Lower bound
' - PageSize: 		Number of rows per page
' - Page: 			Current page
Sub DisplayQuery(Connection, GroupRange, ComRange, ShareRange, Category, FileNameNoExtension, Extension, SizeLow, SizeHigh, PageSize, Page)

	Response.Write "<h2>Results of Search: <font size=3>(Powered by <b><a href=""http:\\www.geocities.com\xiaoshiwind\programming\download.htm"" target=""_blank"">NetScan</a><b>&nbsp;&nbsp;<a href=""http://chkpt.zdnet.com/chkpt/xlinkdownloads/http://hotfiles.zdnet.com/cgi-bin/texis/swlib/hotfiles/info.html?fcode=001BB4"" target=""_blank"">Download Now!</a>)</font></h2>" & vbCRLF

	' Various conditions
	Dim Condition1, Condition2, Condition
	Dim Condition3, Condition4, Condition5
	Dim Condition6, Condition7

	If Category <> "*" Then
		Condition1 = "(Extension.ExtensionCategory) = '" & Category & "'"
	Else
		Condition1 = ""
	End If

	If Extension <> "*" Then
		Condition2 = "(Extension.ExtensionName) LIKE '" & WildCardFormInInterDev(Extension) & "'"
	Else
		Condition2 = ""
	End If

	Dim nPosCurrent, szTemp, szToken
	If Right(GroupRange,1)=";" Then
		GroupRange=Left(GroupRange, Len(GroupRange)-1)
	End If
	' The below can be better performed using Split function.
	If GroupRange <> "*" Then
		szTemp = GroupRange
		Condition3 = "(Workgroup.WorkgroupName) In ("
		nPosCurrent = 1000
		Do
			szTemp = Left(szTemp, nPosCurrent-1)
			nPosCurrent=InStrRev(szTemp, ";")
			szToken = Right(szTemp, Len(szTemp)-nPosCurrent)
			Condition3 = Condition3 & "'" & szToken & "', "
		Loop While (nPosCurrent>0)
		Condition3 = Condition3 & "'[NA]')"
	Else
		Condition3 = ""
	End If

	If Right(ComRange,1)=";" Then
		ComRange=Left(ComRange, Len(ComRange)-1)
	End If
	If ComRange <> "*" Then
		szTemp = ComRange
		Condition4 = "(Machine.MachineName) In ("
		nPosCurrent = 1000
		Do
			szTemp = Left(szTemp, nPosCurrent-1)
			nPosCurrent=InStrRev(szTemp, ";")
			szToken = Right(szTemp, Len(szTemp)-nPosCurrent)
			Condition4 = Condition4 & "'" & szToken & "', "
		Loop While (nPosCurrent>0)
		Condition4 = Condition4 & "'[NA]')"
	Else
		Condition4 = ""
	End If

	If Right(ShareRange,1)=";" Then
		ShareRange=Left(ShareRange, Len(ShareRange)-1)
	End If
	If ShareRange <> "*" Then
		szTemp = ShareRange
		Condition5 = "(Share.ShareFolderName) In ("
		nPosCurrent = 1000
		Do
			szTemp = Left(szTemp, nPosCurrent-1)
			nPosCurrent=InStrRev(szTemp, ";")
			szToken = Right(szTemp, Len(szTemp)-nPosCurrent)
			Condition5 = Condition5 & "'" & szToken & "', "
		Loop While (nPosCurrent>0)
		Condition5 = Condition5 & "'[NA]')"
	Else
		Condition5 = ""
	End If

	If FileNameNoExtension <> "*" Then
		Condition6 = "(File.FileName) LIKE '%\" & WildCardFormInInterDev(FileNameNoExtension) & "'"
	Else
		Condition6 = ""
	End If

	Dim IsSizeLimit
	IsSizeLimit="Yes"

	If SizeLow <> -1 and SizeHigh <> -1 Then
		Condition7= "(File.FileSize) Between " & SizeLow*1024 & " And " & SizeHigh*1024
	ElseIf SizeLow <> -1 Then
		Condition7= "(File.FileSize) >= " & SizeLow*1024
	ElseIf SizeHigh <> -1 Then
		Condition7= "(File.FileSize) <= " & SizeHigh*1024
	Else
		Condition7=""
		IsSizeLimit="No"
	End If

	If (Condition1="" and Condition2="" and Condition3="" and Condition4="" and Condition5="" and Condition6="" and Condition7= "") Then
		Condition = ""
	Else
		Condition = "WHERE (("

		If (Condition1 <> "") Then
			 Condition = Condition & Condition1 & ") AND ("
		End If

		If (Condition2 <> "") Then
			 Condition = Condition & Condition2 & ") AND ("
		End If

		If (Condition3 <> "") Then
			 Condition = Condition & Condition3 & ") AND ("
		End If

		If (Condition4 <> "") Then
			 Condition = Condition & Condition4 & ") AND ("
		End If

		If (Condition5 <> "") Then
			 Condition = Condition & Condition5 & ") AND ("
		End If

		If (Condition6 <> "") Then
			 Condition = Condition & Condition6 & ") AND ("
		End If

		If (Condition7 <> "") Then
			 Condition = Condition & Condition7 & "))"
		Else
			 Condition = Left(Condition, Len(Condition)-Len(") AND (")) & "))"
		End If
	End If

	Dim SQL
	SQL = "SELECT DISTINCTROW Workgroup.WorkgroupName, Machine.MachineName, Share.ShareFolderName, File.FileName, Extension.ExtensionName, Extension.ExtensionCategory, File.FileSize FROM ((Workgroup INNER JOIN Machine ON Workgroup.WorkgroupID = Machine.WorkgroupID) INNER JOIN Share ON Machine.MachineID = Share.MachineID) INNER JOIN (Extension INNER JOIN File ON Extension.ExtensionID = File.ExtensionID) ON Share.ShareFolderID = File.ShareFolderID " & Condition & " ORDER BY Workgroup.WorkgroupName, Machine.MachineName, Share.ShareFolderName, Extension.ExtensionName, Extension.ExtensionCategory, File.FileSize"
	' Response.Write SQL & "<br>"

	' Create a RecordSet
	Dim rs
	Set rs = Server.CreateObject("ADODB.RecordSet")
	rs.CursorLocation = 3 ' adUseClient
	rs.Open SQL, Connection, adOpenForwardOnly, adLockOptimistic


	Dim nRecCount	' Number of records found
	nRecCount = rs.RecordCount


	' Summary
	Dim QueryTarget
	Select Case DatabaseVirtualFilename
		Case "/netscan/ScanOut1.mdb" QueryTarget="Network A"
		Case "/netscan/ScanOut2.mdb" QueryTarget="Network B"
		Case Else QueryTarget="Unknown Network"
	End Select
	Response.Write "<b>Total <font color=""#FF0000"">" & nRecCount & "</font> records found in ""<font color=""#FF0000"">" & QueryTarget & "</font>"" that "
	Dim QueryCategory
	If Category="*" Then
		QueryCategory="Any"
	Else
		QueryCategory=Category
	End If
	Response.Write "match Category ""<font color=""#FF0000"">" & QueryCategory & "</font>"" and match Filename ""<font color=""#FF0000"">" & FileNameNoExtension & "." & Extension & "</font>"".<br>"
	Response.Write "<font size=2>&nbsp;&nbsp;Limited to Workgroup(s): <font color=""#FF0000"">" & GroupRange & "</font><br>"
	Response.Write "&nbsp;&nbsp;Limited to Computer(s): <font color=""#FF0000"">" & ComRange & "</font><br>"
	Response.Write "&nbsp;&nbsp;Limited to Share Folder(s): <font color=""#FF0000"">" & ShareRange & "</font><br>"
	Response.Write "&nbsp;&nbsp;Limited to Size: <font color=""#FF0000"">" & IsSizeLimit & "</font>&nbsp;&nbsp;"
	If IsSizeLimit="Yes" Then
		If SizeLow <> -1 Then
			Response.Write "Lower Bound: <font color=""#FF0000"">" & SizeLow & "KB</font>&nbsp;&nbsp;"
		End If
		If SizeHigh <> -1 Then
			Response.Write "Upper Bound: <font color=""#FF0000"">" & SizeHigh & "KB</font>"
		End If
	End If
	Response.Write "</font><br>"


	If rs.EOF or rs.BOF Then
		rs.Close
		Set rs = nothing
		Exit sub
	End If

	Dim nPageCount	' Number of pages of records we have

	If PageSize < 1 Then
		rs.PageSize = nRecCount
	Else
		rs.PageSize = PageSize
	End If
   nPageCount = rs.PageCount

   If Page < 1 or Page > nPageCount Then
		Page = 1
	End If

	' Displaying Summary
	Dim EndRecord
	EndRecord=Page*PageSize
	If EndRecord>nRecCount Then
		EndRecord=nRecCount
	End If
	Response.Write "Current displaying record <font color=""#FF0000"">" & 1+(Page-1)*PageSize & "-" & EndRecord & "</font>.</b><br><br>"

	' Navigation
	Dim ScriptName
	ScriptName = Request.ServerVariables("SCRIPT_NAME")

	DisplayNavigation ScriptName, DatabaseVirtualFilename, GroupRange, ComRange, ShareRange, Category, FileNameNoExtension, Extension, SizeLow, SizeHigh, PageSize, Page, nPageCount, nRecCount

	' Start the table
	Response.Write "<table width='100%' border=1>" & vbCRLF

	' Write field headings
	Response.Write "<tr>"

	Dim item
	For each item In rs.Fields
		Dim itemname
		Select Case item.Name
			Case "WorkgroupName" itemname="Group"
			Case "MachineName" itemname="Computer"
			Case "ShareFolderName" itemname="Folder"
			Case "FileName" itemname="FileName"
			Case "ExtensionCategory" itemname="Category"
			Case "ExtensionName" itemname="Ext"
			Case "FileSize" itemname="Size"
			Case Else itemname=item.Name
		End Select
		Response.Write "<td valign=top><b>" & itemname & "</b></td>"
	Next
	Response.Write "</tr>" & vbCRLF

	rs.AbsolutePage = Page
	' Write out records
	Do While Not (rs.EOF OR rs.AbsolutePage <> Page)
		Response.Write "<tr>"
		For each item In rs.Fields
			Dim ItemValue, Computer, Folder
			ItemValue=LCase(item.Value)

			If (item.Name = "MachineName") Then
				Computer= ItemValue
			End If
			If (item.Name = "ShareFolderName") Then
				Folder= ItemValue
			End If

			If (item.Name = "FileSize") Then
				Dim nSize, nCount
				nSize=CLng(ItemValue)
				nCount=0
				Do While (nSize>=1024)
					nSize = nSize/1024
					nCount = nCount+1
				Loop
				nSize=CInt(nSize)
				Select Case nCount
					Case 0: ItemValue=nSize&"b"
					Case 1: ItemValue=nSize&"Kb"
					Case 2: ItemValue=nSize&"Mb"
					Case 3: ItemValue=nSize&"Gb"
					default: ItemValue=nSize&"#b"
				End Select
			End If

			If (item.Name = "FileName") Then
				Dim nPos1, nPos2, nPos, PartialFileName, Link
				nPos1 = InStrRev(ItemValue, "\")

				If (nPos1 > 1) Then
					nPos2 = InStrRev(ItemValue, "\", nPos1-1)
					nPos = nPos2
				Else
					nPos = nPos1
				End If

				PartialFileName = Right(ItemValue, Len(ItemValue)-nPos)

				If Len(PartialFileName)>55 Then
					PartialFileName = "..." & Right(PartialFileName, 55)
				End If
				Link = """file:\\" & Computer & "\" & Folder & Left(ItemValue, nPos1) & """"
				Response.Write "<td valign=top><a href=" & Link & " target=""_blank"">" & PartialFileName & "</a></td>"
			ElseIf (item.Name = "FileSize") Then
				Response.Write "<td valign=top align=right>" & ItemValue & "</td>"
			Else
				Response.Write "<td valign=top>" & ItemValue & "</td>"
			End If
		Next
		Response.Write "</tr>" & vbCRLF
		rs.MoveNext
	Loop

	' End the table
	Response.Write "</table>" & vbCRLF

	rs.Close
	Set rs = nothing

	DisplayNavigation ScriptName, DatabaseVirtualFilename, GroupRange, ComRange, ShareRange, Category, FileNameNoExtension, Extension, SizeLow, SizeHigh, PageSize, Page, nPageCount, nRecCount

End Sub


Sub DisplayNavigation(ScriptName, DatabaseVirtualFilename, GroupRange, ComRange, ShareRange, Category, FileNameNoExtension, Extension, SizeLow, SizeHigh, PageSize, Page, nPageCount, nRecCount)

	' First Page
	Response.Write 	"<A HREF=""" & ScriptName & _
				"?database=" & DatabaseVirtualFilename & _
				"&grouprange=" & GroupRange & _
				"&comrange=" & ComRange & _
				"&sharerange=" & ShareRange & _
				"&category=" & Category & _
				"&filename=" & FileNameNoExtension & "." & Extension & _
				"&sizelow=" & SizeLow & _
				"&sizehigh=" & SizeHigh & _
				"&pagesize=" & PageSize & _
				"&page=" & 1 & _
				""">First Page</A>"
	Response.Write "&nbsp;&nbsp;&nbsp;"

	' Previous Page
	Response.Write 	"<A HREF=""" & ScriptName & _
				"?database=" & DatabaseVirtualFilename & _
				"&grouprange=" & GroupRange & _
				"&comrange=" & ComRange & _
				"&sharerange=" & ShareRange & _
				"&category=" & Category & _
				"&filename=" & FileNameNoExtension & "." & Extension & _
				"&sizelow=" & SizeLow & _
				"&sizehigh=" & SizeHigh & _
				"&pagesize=" & PageSize & _
				"&page=" & Page - 1 & _
				""">Previous Page</A>"
	Response.Write "&nbsp;&nbsp;&nbsp;Page "& Page & "/" & nPageCount & "&nbsp;&nbsp;&nbsp;"

	' Next Page
	Response.Write 	"<A HREF=""" & ScriptName & _
				"?database=" & DatabaseVirtualFilename & _
				"&grouprange=" & GroupRange & _
				"&comrange=" & ComRange & _
				"&sharerange=" & ShareRange & _
				"&category=" & Category & _
				"&filename=" & FileNameNoExtension & "." & Extension & _
				"&sizelow=" & SizeLow & _
				"&sizehigh=" & SizeHigh & _
				"&pagesize=" & PageSize & _
				"&page=" & Page + 1 & _
				""">Next Page</A>"
	Response.Write "&nbsp;&nbsp;&nbsp"

	' Last Page
	Response.Write 	"<A HREF=""" & ScriptName & _
				"?database=" & DatabaseVirtualFilename & _
				"&grouprange=" & GroupRange & _
				"&comrange=" & ComRange & _
				"&sharerange=" & ShareRange & _
				"&category=" & Category & _
				"&filename=" & FileNameNoExtension & "." & Extension & _
				"&sizelow=" & SizeLow & _
				"&sizehigh=" & SizeHigh & _
				"&pagesize=" & PageSize & _
				"&page=" & nPageCount & _
				""">Last Page</A>"
	Response.Write "&nbsp;&nbsp;&nbsp"

	' Show Me All
	Response.Write 	"<A HREF=""" & ScriptName & _
				"?database=" & DatabaseVirtualFilename & _
				"&grouprange=" & GroupRange & _
				"&comrange=" & ComRange & _
				"&sharerange=" & ShareRange & _
				"&category=" & Category & _
				"&filename=" & FileNameNoExtension & "." & Extension & _
				"&sizelow=" & SizeLow & _
				"&sizehigh=" & SizeHigh & _
				"&pagesize=" & nRecCount & _
				"&page=1" & _
				""">Show Me All</A>"
End Sub

' ////////////////////////////////////////////////////////////
' Main

' Get the database and SQL parameters. If non-null then display the
' details, otherwise just display the input form.

Dim DatabaseVirtualFilename, GroupRange, ComRange, ShareRange
Dim Category, FullFileName, FileNameNoExtension, Extension
Dim SizeLow, SizeHigh, PageSize, Page

DatabaseVirtualFilename = Request("database")

GroupRange = Request("grouprange")
ComRange = Request("comrange")
ShareRange = Request("sharerange")

Category = Request("category")
FullFileName = Request("filename") ' Split to FileNameNoExtension and Extension later

SizeLow = CLng(Request("sizelow"))
SizeHigh = CLng(Request("sizehigh"))

PageSize = CLng(Request("pagesize"))
Page = CLng(Request("page"))

Dim nPos
nPos = InStrRev(FullFileName, ".")
If nPos>1 Then
	FileNameNoExtension = Left(FullFileName, nPos-1)
	Extension=Right(FullFileName, Len(FullFileName)-nPos)
ElseIf nPos=1 Then
	FileNameNoExtension = "*"
	Extension=Right(FullFileName, Len(FullFileName)-1)
Else
	FileNameNoExtension = FullFileName
	Extension="*"
End If

If (DatabaseVirtualFilename<>"" and GroupRange<>"" and ComRange<>"" and ShareRange<>"" and FileNameNoExtension<>"" and Extension<>"") Then

	Dim Connection
	If (OpenDatabase(DatabaseVirtualFilename, "", "", Connection)) Then
		DisplayQuery Connection, GroupRange, ComRange, ShareRange, Category, FileNameNoExtension, Extension, SizeLow, SizeHigh, PageSize, Page
	End If

	Connection.Close
	Set Connection = nothing

	CheckError
End If

%>

<font face="Verdana, Arial, Helvetica, sans-serif">
<form action="<%=Request.ServerVariables("SCRIPT_NAME")%>">
	<table>
	<tr>
		<td nowrap><h3>Online NetScan Search:</h3></td>
		<td>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Search Target:</b></td>
		<td>
			<INPUT type="radio" name=database value="/netscan/ScanOut1.mdb" checked>Network A&nbsp;&nbsp;
			<INPUT type="radio" name=database value="/netscan/ScanOut2.mdb">Network B<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Limted to Workgroup(s): </b></td>
		<td>
			<input type="text" size=40 name=grouprange value="*">(* for all, ; for separation of exact name)<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Limted to Computer(s): </b></td>
		<td>
			<input type="text" size=40 name=comrange value="*">(* for all, ; for separation of exact name)<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Limted to Share Folder(s): </b></td>
		<td>
			<input type="text" size=40 name=sharerange value="*">(* for all, ; for separation of exact name)<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Match Category:</b></td>
		<td>
			<select name=category>
    			<option value="*" selected>Any</option>
    			<option value="Image">Image</option>
    			<option value="Movie">Movie</option>
    			<option value="Music">Music</option>
    			<option value="Customised">Customised</option>
    			<option value="Text">Text</option>
    			<option value="Compressed">Compressed</option>
    			<option value="Script">Script</option>
    			<option value="Coding">Coding</option>
    			<option value="MSAccess">MSAccess</option>
    			<option value="MSExcel">MSExcel</option>
    			<option value="MSPowerPoint">MSPowerPoint</option>
    			<option value="MSVisio">MSVisio</option>
    			<option value="Executable">Executable</option>
    			<option value="Others">Others</option>
  			</select>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Match Filename: </b></td>
		<td>
			<input type="text" size=40 name=filename value="*">(* for any, wild cards "*" and "?" supported)<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Limited to Certain Size: </b></td>
		<td>
			Lower Bound: <input type="text" size=10 name=sizelow value="-1">KB (-1 for n/a)<br>
			Upper Bound: <input type="text" size=10 name=sizehigh value="-1">KB (-1 for n/a)<br>
		</td>
	</tr>
	<tr>
		<td nowrap><b>Display Number of Rows:</b></td>
		<td>
			<input type="text" size=8 name=pagesize value="400"><br>
		</td>
	</tr>
	<tr>
		<td nowrap></td>
		<td>
			<input type="submit" value="Search Now!">
			<input type="hidden" size=5 name=page value="1">
		</td>
	</tr>
	</table>
</form>
</font>
</BODY>
</HTML>