/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import stec.iws.SessionContext;
import stec.iws.iws;

public class Session
implements HttpSession {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private Hashtable sessionData;
    private SessionContext context;
    protected String id;
    private long creationTime;
    private long lastAccessedTime;
    private long sessionTimeout;
    private boolean isValid;
    private boolean isNew;

    public Session(String string, SessionContext sessionContext) {
        this.id = string;
        this.context = sessionContext;
        this.sessionData = new Hashtable();
        this.sessionTimeout = iws.sessionTimeout;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.isValid = true;
        this.isNew = true;
    }

    private void _invalidate() {
        this.isValid = false;
        this.context.removeSession(this);
        Enumeration enumeration = this.sessionData.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.sessionData.get(string);
            if (!(v instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    protected synchronized void access() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    private void checkSession() {
        if (!this.isValid()) {
            StringBuffer stringBuffer = new StringBuffer("Session ID is not valid: ");
            stringBuffer.append(this.id);
            throw new IllegalStateException(stringBuffer.toString());
        }
    }

    public synchronized void clear() {
        this.sessionData.clear();
    }

    protected static String encodeURL(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(iws.sessionName);
        stringBuffer.append('=');
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        int n = string.indexOf(63);
        if (n == -1) {
            stringBuffer.append(string);
            stringBuffer.append('?');
            stringBuffer.append(string3);
        } else {
            String string4 = String.valueOf(iws.sessionName) + "=";
            int n2 = string.indexOf("?" + string4);
            if (n2 == -1) {
                stringBuffer.append(string.substring(0, n2 + 1));
                stringBuffer.append(string3);
                int n3 = string3.indexOf(38, n2 + string4.length() + 1);
                if (n3 != -1) {
                    stringBuffer.append(string.substring(n3));
                }
            } else {
                n2 = string.indexOf("&" + string4);
                if (n2 != -1) {
                    stringBuffer.append(string.substring(0, n2 + 1));
                    stringBuffer.append(string3);
                    int n4 = string3.indexOf(38, n2 + string4.length() + 1);
                    if (n4 != -1) {
                        stringBuffer.append(string.substring(n4));
                    }
                } else {
                    stringBuffer.append(string);
                    stringBuffer.append('&');
                    stringBuffer.append(string3);
                }
            }
        }
        return stringBuffer.toString();
    }

    public synchronized long getCreationTime() {
        this.checkSession();
        return this.creationTime;
    }

    public synchronized String getId() {
        this.checkSession();
        return this.id;
    }

    public synchronized long getLastAccessedTime() {
        this.checkSession();
        return this.lastAccessedTime;
    }

    public synchronized int getMaxInactiveInterval() {
        if (this.sessionTimeout == -1L) {
            return -1;
        }
        return (int)(this.sessionTimeout / 1000L);
    }

    public synchronized HttpSessionContext getSessionContext() {
        this.checkSession();
        return this.context;
    }

    public synchronized Object getValue(String string) {
        this.checkSession();
        return this.sessionData.get(string);
    }

    public synchronized String[] getValueNames() {
        this.checkSession();
        int n = 0;
        String[] stringArray = new String[this.sessionData.size()];
        Enumeration enumeration = this.sessionData.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = enumeration.nextElement().toString();
        }
        return stringArray;
    }

    public synchronized void invalidate() {
        this.checkSession();
        this._invalidate();
    }

    public synchronized boolean isNew() {
        this.checkSession();
        return this.isNew;
    }

    public synchronized boolean isValid() {
        if (this.sessionTimeout != -1L && System.currentTimeMillis() > this.lastAccessedTime + this.sessionTimeout) {
            this._invalidate();
        }
        return this.isValid;
    }

    public synchronized Enumeration keys() {
        return this.sessionData.keys();
    }

    public synchronized void putValue(String string, Object object) {
        this.checkSession();
        this.sessionData.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized void removeValue(String string) {
        this.checkSession();
        Object v = this.sessionData.remove(string);
        if (v instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized void setMaxInactiveInterval(int n) {
        if (n == -1) {
            n = -1;
            return;
        }
        this.sessionTimeout = (long)n * 1000L;
    }
}

