/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.iws;

public abstract class Logger
implements Runnable {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private Log log = new Log();
    private Hashtable parameters;
    private int interval;

    private synchronized void _output(Object object) {
        try {
            if (object instanceof AccessLogEntry) {
                this.output((AccessLogEntry)object);
                return;
            }
            if (object instanceof EventLogEntry) {
                this.output((EventLogEntry)object);
                return;
            }
            this.output((ErrorLogEntry)object);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
    }

    public void destroy() {
        this.outputAll();
    }

    public void init(Hashtable hashtable) throws Exception {
        this.parameters = hashtable;
        Object v = hashtable.get("interval");
        if (v == null) {
            this.interval = 0;
            return;
        }
        try {
            this.interval = Integer.parseInt(((String[])v)[0]);
            if (this.interval < 50 && this.interval != 0) {
                this.interval = 50;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.interval = 0;
            return;
        }
    }

    public void log(String string) {
        if (!iws.logEvents) {
            return;
        }
        EventLogEntry eventLogEntry = new EventLogEntry();
        eventLogEntry.timestamp = System.currentTimeMillis();
        eventLogEntry.message = string;
        if (this.interval == 0) {
            this._output(eventLogEntry);
            return;
        }
        this.log.add(eventLogEntry);
    }

    public void log(Throwable throwable) {
        this.log(throwable, "");
    }

    /*
     * Unable to fully structure code
     */
    public void log(Throwable var1_1, String var2_2) {
        if (iws.logErrors) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = ((InvocationTargetException)var1_1).getTargetException();
lbl4:
            // 2 sources

            ** while (var1_1 instanceof InvocationTargetException)
        }
lbl5:
        // 1 sources

        var3_3 = new ErrorLogEntry();
        var3_3.timestamp = System.currentTimeMillis();
        var3_3.error = var1_1;
        var3_3.message = var2_2;
        if (this.interval == 0) {
            this._output(var3_3);
            return;
        }
        this.log.add(var3_3);
    }

    public void log(AccessLogEntry accessLogEntry) {
        if (!iws.logAccess) {
            return;
        }
        if (this.interval == 0) {
            this._output(accessLogEntry);
            return;
        }
        this.log.add(accessLogEntry);
    }

    public abstract void output(AccessLogEntry var1) throws Exception;

    public abstract void output(ErrorLogEntry var1) throws Exception;

    public abstract void output(EventLogEntry var1) throws Exception;

    private synchronized void outputAll() {
        try {
            Object object;
            while ((object = this.log.next()) != null) {
                this._output(object);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.interval != 0) ** GOTO lbl12
        return;
        {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException v0) {}
            do {
                if (this.log.size() == 0) continue block2;
                if (iws.shutdown) {
                    return;
                }
                this.outputAll();
lbl12:
                // 2 sources

            } while (!iws.shutdown);
        }
    }

    class Log {
        private Vector items = new Vector();

        Log() {
        }

        synchronized void add(Object object) {
            this.items.addElement(object);
        }

        synchronized Object next() {
            if (this.items.size() > 0) {
                Object e = this.items.elementAt(0);
                this.items.removeElementAt(0);
                return e;
            }
            return null;
        }

        synchronized int size() {
            return this.items.size();
        }
    }
}

