/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import stec.iws.ClusterClient;
import stec.iws.iws;
import stec.lang.DString;

public class ClusterMonitor
implements Runnable {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private int interval;
    private ClusterClient[] clients;
    private int nextHost;
    private boolean useBest;
    private long lastRefresh;
    private static final int PORT = 8080;
    private static final String SPORT = "8080";
    private static final String FILE = "/status";

    ClusterMonitor(String[] stringArray, int n, boolean bl) {
        this.interval = n;
        this.useBest = bl;
        if (this.interval > 0) {
            this.nextHost = 0;
        }
        this.clients = new ClusterClient[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            this.clients[n2] = new ClusterClient();
            String string = DString.extract(stringArray[n2], ":", 0);
            String string2 = DString.extract(stringArray[n2], ":", 1);
            if (string2 == null) {
                string2 = SPORT;
            } else if (string2.length() == 0) {
                string2 = SPORT;
            }
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 8080;
            }
            this.clients[n2].hostname = string;
            this.clients[n2].port = n3;
            ++n2;
        }
    }

    private void clear() {
        if (System.currentTimeMillis() - this.lastRefresh < 50L) {
            return;
        }
        int n = 0;
        while (n < this.clients.length) {
            ClusterClient clusterClient = this.clients[n];
            synchronized (clusterClient) {
                this.clients[n].responseTime = 0L;
            }
            ++n;
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    protected ClusterClient find(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.clients.length) {
            stringBuffer.setLength(0);
            stringBuffer.append(this.clients[n].hostname);
            stringBuffer.append(':');
            stringBuffer.append(this.clients[n].port);
            if (string.equalsIgnoreCase(stringBuffer.toString())) {
                return this.clients[n];
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getResponseTime(ClusterClient clusterClient) {
        long l = -1L;
        Socket socket = null;
        try {
            try {
                socket = new Socket(clusterClient.hostname, clusterClient.port);
                socket.setSoTimeout(60000);
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeBytes("GET ");
                dataOutputStream.writeBytes(FILE);
                dataOutputStream.writeBytes(" HTTP/1.0\n");
                dataOutputStream.writeBytes("Connection: Close\n");
                dataOutputStream.writeBytes("\n");
                dataOutputStream.flush();
                String string = dataInputStream.readLine();
                if (string != null) {
                    long l2;
                    l = l2 = Long.parseLong(string);
                }
            }
            catch (Exception exception) {
            }
            Object var5_7 = null;
            if (socket == null) return l;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            socket.close();
            return l;
        }
        catch (Exception exception) {}
        return l;
    }

    protected ClusterClient next() {
        ClusterClient clusterClient = null;
        if (this.useBest) {
            if (this.interval < 1) {
                this.refresh();
            }
            int n = 0;
            while (n < this.clients.length) {
                ClusterClient clusterClient2 = this.clients[n];
                synchronized (clusterClient2) {
                    if (this.clients[n].responseTime != -1L) {
                        if (clusterClient == null) {
                            clusterClient = this.clients[n];
                        } else if (clusterClient.responseTime > this.clients[n].responseTime) {
                            clusterClient = this.clients[n];
                        }
                    }
                }
                ++n;
            }
            return clusterClient;
        }
        if (this.interval < 1) {
            this.clear();
        }
        int n = 0;
        while (n < this.clients.length) {
            ClusterClient clusterClient3 = this.clients[n];
            synchronized (clusterClient3) {
                if (this.clients[this.nextHost].responseTime != -1L) {
                    clusterClient = this.clients[this.nextHost];
                    ++this.nextHost;
                    if (this.nextHost == this.clients.length) {
                        this.nextHost = 0;
                    }
                    ClusterClient clusterClient4 = clusterClient;
                    Object var5_7 = null;
                    return clusterClient4;
                }
                ++this.nextHost;
                if (this.nextHost == this.clients.length) {
                    this.nextHost = 0;
                }
            }
            ++n;
        }
        return null;
    }

    private void refresh() {
        if (System.currentTimeMillis() - this.lastRefresh < 50L) {
            return;
        }
        int n = 0;
        while (n < this.clients.length) {
            ClusterClient clusterClient = this.clients[n];
            synchronized (clusterClient) {
                this.clients[n].responseTime = ClusterMonitor.getResponseTime(this.clients[n]);
            }
            ++n;
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.interval >= 1) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            if (this.useBest) {
                this.refresh();
            } else {
                this.clear();
            }
            try {
                Thread.sleep(this.interval);
                continue;
            }
            catch (InterruptedException v0) {}
lbl11:
            // 3 sources

            ** while (!iws.shutdown)
        }
lbl12:
        // 1 sources

    }
}

