/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminUsers {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayUserEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("user_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("username");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%username%", (String)object);
        object = hashtable.get("password");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%password%", (String)object);
        string = DString.replace(string, "%vpassword%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayUsers(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("users");
        AdminUtils.displayList(adminContext);
    }

    protected static void doUserEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("user_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminUsers.verifyUserEntry(adminContext)) {
                AdminUsers.updateUserEntry(adminContext);
                adminContext.setForm("users");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "users", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminUsers.verifyUserEntry(adminContext)) {
                    AdminUsers.updateUserEntry(adminContext);
                    adminContext.setForm("users");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("users");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminUsers.displayUserEntry(adminContext);
    }

    protected static void doUsers(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("users");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminUsers.displayUserEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminUsers.parseUserEntry(adminContext);
                AdminUsers.displayUserEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("change")) {
                AdminUtils.changeRealm(adminContext);
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getUserEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("username", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("password", string2);
        return hashtable;
    }

    protected static void parseUserEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminUsers.getUserEntry(adminContext, hashtable);
    }

    protected static void updateUserEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("username");
        String string2 = "";
        Object v = hashtable.get("password");
        if (v != null) {
            string2 = (String)v;
        }
        hashtable = AdminUtils.getSessionData(adminContext, "users");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "users", hashtable);
    }

    protected static boolean verifyUserEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = AdminUsers.getUserEntry(adminContext, AdminUtils.getFormData(adminContext, "users"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string = "";
        String string2 = adminContext.request.getParameter("key");
        if (string2 != null) {
            string = string2;
            hashtable2.put("key", string);
        }
        if ((string2 = adminContext.request.getParameter("username")) == null) {
            adminContext.error_message.append("Username is required.<br>");
            string2 = hashtable.get("username");
            if (string2 != null) {
                hashtable2.put("username", string2);
            }
        } else {
            String string3 = DString.trim(string2);
            if (string3.length() == 0) {
                adminContext.error_message.append("Username is required.<br>");
                string2 = hashtable.get("username");
                if (string2 != null) {
                    hashtable2.put("username", string2);
                }
            } else if (string.equals(string3)) {
                hashtable2.put("username", string3);
            } else if (AdminUtils.getFormEntry(adminContext, "users", string3) != null) {
                adminContext.error_message.append("User already exists.<br>");
                string2 = hashtable.get("username");
                if (string2 != null) {
                    hashtable2.put("username", string2);
                }
            } else {
                hashtable2.put("username", string3);
            }
        }
        String string4 = null;
        string2 = adminContext.request.getParameter("password");
        if (string2 != null) {
            string4 = string2;
        }
        string2 = adminContext.request.getParameter("vpassword");
        if (string4 == null && string2 == null) {
            adminContext.error_message.append("Password is required.<br>");
            string2 = hashtable.get("password");
            if (string2 != null) {
                hashtable2.put("password", string2);
            }
        } else if (string4 == null || string2 == null) {
            adminContext.error_message.append("Password mismatch.<br>");
            string2 = hashtable.get("password");
            if (string2 != null) {
                hashtable2.put("password", string2);
            }
        } else {
            String string5 = string2;
            if (string4.length() == 0 && string5.length() == 0) {
                adminContext.error_message.append("Password is required.<br>");
                string2 = hashtable.get("password");
                if (string2 != null) {
                    hashtable2.put("password", string2);
                }
            } else if (string4.length() == 0 || string5.length() == 0) {
                adminContext.error_message.append("Password mismatch.<br>");
                string2 = hashtable.get("password");
                if (string2 != null) {
                    hashtable2.put("password", string2);
                }
            } else if (string4.equals(string5)) {
                hashtable2.put("password", string4);
                hashtable2.put("vpassword", string5);
            } else {
                adminContext.error_message.append("Password mismatch.<br>");
                string2 = hashtable.get("password");
                if (string2 != null) {
                    hashtable2.put("password", string2);
                }
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

