/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.AdminACLs;
import stec.iws.AdminAliases;
import stec.iws.AdminCPanel;
import stec.iws.AdminComputers;
import stec.iws.AdminContext;
import stec.iws.AdminGroups;
import stec.iws.AdminHosts;
import stec.iws.AdminLogger;
import stec.iws.AdminLogin;
import stec.iws.AdminMessages;
import stec.iws.AdminMimeTypes;
import stec.iws.AdminMonitor;
import stec.iws.AdminPools;
import stec.iws.AdminRealms;
import stec.iws.AdminResources;
import stec.iws.AdminRights;
import stec.iws.AdminServer;
import stec.iws.AdminServlets;
import stec.iws.AdminSession;
import stec.iws.AdminTemplates;
import stec.iws.AdminUsers;
import stec.iws.AdminUtils;
import stec.iws.AdminWorkGroup;
import stec.iws.IOManager;
import stec.iws.Request;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminServlet
extends HttpServlet {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    protected static boolean admin_shutdown;
    protected static String monitor_template;
    protected static int interval;
    protected static String[][] servers;
    protected static Hashtable adminRealmContexts;

    public synchronized void destroy() {
        admin_shutdown = true;
        AdminUtils.destroyAdminRealms();
    }

    public String getServletInfo() {
        return "Servertec (R) Application/Web Server Version 1.7.0 01/09/2000 Preview Release\nCopyright (C) Servertec 1998-2000. All rights reserved.\n\nAdminServlet";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            String string = servletConfig.getInitParameter("interval");
            if (string == null) {
                interval = 30;
            } else {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 30;
                }
                if (n < 1) {
                    n = 30;
                }
                interval = n;
            }
            Hashtable hashtable = Utils.load("./config/workgroup.ini", false);
            if (hashtable.size() != 0) {
                servers = new String[hashtable.size()][4];
                int n = 0;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)hashtable.get(string2);
                    AdminServlet.servers[n][0] = "0";
                    AdminServlet.servers[n][1] = Utils.decodeURL(string2);
                    AdminServlet.servers[n][2] = DString.extract(string3, ",", 0);
                    AdminServlet.servers[n][3] = DString.extract(string3, ",", 1);
                    ++n;
                }
            }
            monitor_template = Utils.getItem(IOManager.getHandler(iws.basedir, "/admin/monitor.html"));
            adminRealmContexts = new Hashtable();
            return;
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage());
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2;
        AdminContext adminContext = new AdminContext(httpServletRequest, httpServletResponse);
        if (!(iws.remote_admin || (string2 = httpServletRequest.getRemoteAddr()).equals(string = ((Request)httpServletRequest).getLocalAddr()) || string2.equals("127.0.0.1"))) {
            String string3;
            adminContext.error_message.append("This server cannot be administered remotely.");
            String string4 = adminContext.request.getParameter("url");
            if (string4 == null) {
                AdminLogin.displayLogin(adminContext);
                return;
            }
            adminContext.response.sendRedirect(String.valueOf(string4) + "&error_message=" + ((string3 = adminContext.error_message.toString()) == null ? null : URLEncoder.encode(string3)));
            ((Session)adminContext.session).clear();
            return;
        }
        string2 = adminContext.request.getParameter("form_name");
        if (string2 == null) {
            AdminLogin.displayLogin(adminContext);
            return;
        }
        if (string2.equals("login")) {
            AdminLogin.doLogin(adminContext);
            return;
        }
        if (adminContext.session.isNew() || !((Session)adminContext.session).isValid()) {
            adminContext.error_message.append("Invalid session please login.");
            AdminLogin.displayLogin(adminContext);
            return;
        }
        if (string2.equals("navbar")) {
            AdminUtils.doNavbar(adminContext);
            return;
        }
        if (string2.equals("monitor")) {
            AdminMonitor.doMonitor(adminContext);
            return;
        }
        if (string2.equals("cpanel")) {
            AdminCPanel.doCPanel(adminContext);
            return;
        }
        if (string2.equals("server")) {
            AdminServer.doServer(adminContext);
            return;
        }
        if (string2.equals("workgroup")) {
            AdminWorkGroup.doWorkGroup(adminContext);
            return;
        }
        if (string2.equals("aliases")) {
            AdminAliases.doAliases(adminContext);
            return;
        }
        if (string2.equals("servlets")) {
            AdminServlets.doServlets(adminContext);
            return;
        }
        if (string2.equals("messages")) {
            AdminMessages.doMessages(adminContext);
            return;
        }
        if (string2.equals("mimetypes")) {
            AdminMimeTypes.doMimeTypes(adminContext);
            return;
        }
        if (string2.equals("hosts")) {
            AdminHosts.doHosts(adminContext);
            return;
        }
        if (string2.equals("pools")) {
            AdminPools.doPools(adminContext);
            return;
        }
        if (string2.equals("users")) {
            AdminUsers.doUsers(adminContext);
            return;
        }
        if (string2.equals("computers")) {
            AdminComputers.doComputers(adminContext);
            return;
        }
        if (string2.equals("groups")) {
            AdminGroups.doGroups(adminContext);
            return;
        }
        if (string2.equals("resources")) {
            AdminResources.doResources(adminContext);
            return;
        }
        if (string2.equals("realms")) {
            AdminRealms.doRealms(adminContext);
            return;
        }
        if (string2.equals("rights")) {
            AdminRights.doRights(adminContext);
            return;
        }
        if (string2.equals("acls")) {
            AdminACLs.doACLs(adminContext);
            return;
        }
        if (string2.equals("logger")) {
            AdminLogger.doLogger(adminContext);
            return;
        }
        if (string2.equals("templates")) {
            AdminTemplates.doTemplates(adminContext);
            return;
        }
        if (string2.equals("session")) {
            AdminSession.doSession(adminContext);
            return;
        }
        if (string2.equals("workgroup_entry")) {
            AdminWorkGroup.doWorkGroupEntry(adminContext);
            return;
        }
        if (string2.equals("alias_entry")) {
            AdminAliases.doAliasEntry(adminContext);
            return;
        }
        if (string2.equals("servlet_entry")) {
            AdminServlets.doServletEntry(adminContext);
            return;
        }
        if (string2.equals("message_entry")) {
            AdminMessages.doMessageEntry(adminContext);
            return;
        }
        if (string2.equals("template_entry")) {
            AdminTemplates.doTemplateEntry(adminContext);
            return;
        }
        if (string2.equals("mimetype_entry")) {
            AdminMimeTypes.doMimeTypeEntry(adminContext);
            return;
        }
        if (string2.equals("host_entry")) {
            AdminHosts.doHostEntry(adminContext);
            return;
        }
        if (string2.equals("pool_entry")) {
            AdminPools.doPoolEntry(adminContext);
            return;
        }
        if (string2.equals("user_entry")) {
            AdminUsers.doUserEntry(adminContext);
            return;
        }
        if (string2.equals("computer_entry")) {
            AdminComputers.doComputerEntry(adminContext);
            return;
        }
        if (string2.equals("group_entry")) {
            AdminGroups.doGroupEntry(adminContext);
            return;
        }
        if (string2.equals("resource_entry")) {
            AdminResources.doResourceEntry(adminContext);
            return;
        }
        if (string2.equals("realm_entry")) {
            AdminRealms.doRealmEntry(adminContext);
            return;
        }
        if (string2.equals("right_entry")) {
            AdminRights.doRightEntry(adminContext);
            return;
        }
        if (string2.equals("acl_entry")) {
            AdminACLs.doACLEntry(adminContext);
            return;
        }
        AdminLogin.displayLogin(adminContext);
    }
}

