/*
 * Decompiled with CFR 0.152.
 */
package bigbrother;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class ImageFactory {
    public static final double JAVA_VERSION = new Double(System.getProperty("java.version").substring(0, 3));
    private static final Hashtable imageHash = new Hashtable();
    private static final boolean SHOULD_HASH = true;

    private ImageFactory() {
    }

    public static Image createImage(String string, Component component) {
        return ImageFactory.createImage(string, null, component);
    }

    public static Image createImage(String string, String string2, Component component) {
        Image image = null;
        if (imageHash.containsKey(string)) {
            image = (Image)imageHash.get(string);
        } else {
            Object object;
            if (JAVA_VERSION < 1.2 && string2 != null) {
                throw new IllegalArgumentException("Can't load from a JAR in pre-v1.2 Java! Current version is: " + JAVA_VERSION);
            }
            if (component instanceof Applet) {
                object = (Applet)component;
                URL uRL = ((Applet)object).getCodeBase();
                if (uRL == null) {
                    throw new IllegalArgumentException("Applet has null code base! \n\nDon't load images in constructors; do all image-handling no \nearlier than in the applet's init() method.");
                }
                try {
                    URL uRL2 = string2 != null ? ImageFactory.getJarFileURL(uRL, string2, string) : new URL(uRL, string);
                    image = ((Applet)object).getImage(uRL2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad URL loading applet image from " + string + " : " + malformedURLException);
                }
            } else {
                object = Toolkit.getDefaultToolkit();
                if (string2 != null) {
                    URL uRL = ImageFactory.getJarFileURL(System.getProperty("user.dir") + File.separatorChar + string2, string);
                    image = ((Toolkit)object).getImage(uRL);
                } else {
                    image = ((Toolkit)object).getImage(string);
                }
            }
            if (image == null) {
                throw new IllegalArgumentException("Image was null; something must have gone wrong!");
            }
            object = new MediaTracker(component);
            ((MediaTracker)object).addImage(image, 0);
            try {
                ((MediaTracker)object).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            imageHash.put(string, image);
        }
        return image;
    }

    private static URL getJarFileURL(URL uRL, String string, String string2) {
        try {
            URL uRL2 = new URL("jar:" + uRL + string + "!/" + string2);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.toString());
        }
    }

    private static URL getJarFileURL(String string, String string2) {
        try {
            URL uRL = new URL("jar:file:" + string + "!/" + string2);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.toString());
        }
    }
}

