/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.HtmlProducer;
import photoorganizer.IrdControllable;
import photoorganizer.Resources;
import photoorganizer.courier.FTPCourier;
import photoorganizer.courier.FileCourier;
import photoorganizer.courier.HTTPCourier;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.formats.Thumbnail;
import photoorganizer.media.ContentMatcher;
import photoorganizer.media.PlaybackRequest;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.BaseConfigurableTableModel;
import photoorganizer.renderer.CollectionThumbnailsPanel;
import photoorganizer.renderer.Id3TagEditor;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PlaybackProperties;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.SendEmailFrame;
import photoorganizer.renderer.StatusBar;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class PhotoCollectionPanel
extends JTable
implements ActionListener,
Persistable,
IrdControllable {
    static final String SECNAME = "PhotoCollectionPanel";
    static final String COLWIDTH = "ColumnWidthes";
    static final int TOO_MANY_WINDOWS = 20;
    private Controller controller;
    private Point lastmouse;
    private CollectionThumbnailsPanel thumbnailspanel;
    private AlbumPane albumpane;
    private StatusBar statusbar;
    private Class fclass;
    private boolean keeporigmarkers;
    private boolean transformmove;
    private boolean transformaddsel;
    public static final String DEFTNMASK = "tumbnail%00c.jpg";
    public static String LastHtmlName = "??";
    static /* synthetic */ Class class$photoorganizer$formats$Exif;
    static /* synthetic */ Class class$photoorganizer$formats$CIFF;
    static /* synthetic */ Class class$photoorganizer$formats$JFXX;
    static /* synthetic */ Class class$photoorganizer$formats$AbstractImageInfo;

    public PhotoCollectionPanel(Controller controller) {
        this.setSelectionMode(2);
        this.controller = controller;
        this.statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
        this.thumbnailspanel = (CollectionThumbnailsPanel)controller.component(Controller.COMP_THUMBCOLLCTPANEL);
        if (this.thumbnailspanel != null) {
            this.thumbnailspanel.setCollection(this);
        }
        this.albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.albumpane.setCollectionPanel(this);
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                PhotoCollectionPanel.this.lastmouse = new Point(mouseEvent.getX(), mouseEvent.getY());
                if ((n & 4) > 0) {
                    PhotoCollectionPanel.this.getRMouseMenu().show(PhotoCollectionPanel.this, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2) {
                    PhotoCollectionPanel.this.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                }
            }
        });
        this.setModel(new CollectionModel(controller));
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                int n2 = listSelectionEvent.getFirstIndex();
                if (n2 > (n = listSelectionEvent.getLastIndex())) {
                    n = listSelectionEvent.getFirstIndex();
                    n2 = listSelectionEvent.getLastIndex();
                }
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                boolean bl = false;
                int n3 = n2;
                while (n3 <= n) {
                    Thumbnail thumbnail = (Thumbnail)collectionModel.getElementAt(n3);
                    if (thumbnail != null) {
                        boolean bl2 = PhotoCollectionPanel.this.isRowSelected(n3);
                        thumbnail.select(bl2);
                        bl |= bl2;
                    }
                    ++n3;
                }
                if (!bl) {
                    bl = PhotoCollectionPanel.this.getSelectedRowCount() > 0;
                }
                PhotoCollectionPanel.this.controller.getUiUpdater().notify(bl, 2);
                PhotoCollectionPanel.this.controller.getUiUpdater().notify(bl, 6);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    PhotoCollectionPanel.this.delete(PhotoCollectionPanel.this.getSelectedRows());
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){

            public boolean importData(JComponent jComponent, Transferable transferable) {
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    PhotoCollectionPanel.this.add(list.toArray(new File[list.size()]));
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                int n = 0;
                while (n < dataFlavorArray.length) {
                    if (dataFlavorArray[n].isFlavorJavaFileListType()) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
        });
        this.setDragEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int[] nArray = this.getSelectedRows();
        nArray = (int[])nArray.clone();
        if (string.equals("Invert selection")) {
            int n = this.rowAtPoint(this.lastmouse);
            if (n >= 0) {
                if (this.isRowSelected(n)) {
                    this.removeRowSelectionInterval(n, n);
                } else {
                    this.addRowSelectionInterval(n, n);
                }
                this.controller.getUiUpdater().notify(this.getSelectedRowCount() > 0, 2);
            }
        } else if (string.equals("Select all")) {
            this.selectAll();
        } else if (string.equals("Get CF") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("Get CF")) {
            String string2 = (String)this.controller.getSerializer().getProperty((Object)"MiscellaneousOptions", (Object)"FlashCardDirectory");
            if (string2 != null && string2.length() > 0) {
                this.add(new File[]{new File(string2)});
            }
        } else if (string.equals("Extract markers")) {
            this.extractMarkers(nArray);
        } else if (string.equals("To album")) {
            AlbumSelectionDialog albumSelectionDialog = this.albumpane.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + nArray.length);
            albumSelectionDialog.setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                Serializer serializer = this.controller.getSerializer();
                boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"MoveToAlbum"), (int)0) == 1 && Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumFolders"), (int)0) == 1;
                AbstractFormat[] abstractFormatArray = new AbstractFormat[nArray.length];
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n3 < nArray.length) {
                    abstractFormatArray[n3] = ((Thumbnail)collectionModel.getElementAt(nArray[n3])).getFormat();
                    if (bl) {
                        ((Thumbnail)collectionModel.getElementAt(nArray[n3])).select(false);
                        collectionModel.markDelete(nArray[n3]);
                        if (nArray[n3] > n2) {
                            n2 = nArray[n3];
                        }
                        if (nArray[n3] < n) {
                            n = nArray[n3];
                        }
                    }
                    ++n3;
                }
                this.albumpane.addToAlbum(abstractFormatArray, treePathArray);
                if (bl) {
                    collectionModel.removeAllMarked();
                    collectionModel.fireTableRowsDeleted(n, n2);
                    this.controller.getUiUpdater().notify(false, 2);
                } else {
                    collectionModel.fireTableRowsUpdated(n, n2);
                }
            }
        } else if (string.equals("Rename")) {
            this.rename(nArray);
        } else if (string.equals("To ripper")) {
            this.copyToRipper(nArray);
        } else if (string.equals("Delete")) {
            this.delete(nArray);
        } else if (string.equals("Show/Play")) {
            int n = this.rowAtPoint(this.lastmouse);
            if (n >= 0) {
                AbstractFormat abstractFormat = ((Thumbnail)collectionModel.getElementAt(n)).getFormat();
                if (abstractFormat != null && abstractFormat instanceof BasicJpeg) {
                    ((PhotoImagePanel)this.controller.component(Controller.COMP_IMAGECOLLCTPANEL)).updateView(abstractFormat);
                    return;
                }
                this.show(nArray);
            }
        } else if (string.equals("Properties...")) {
            int n = 0;
            while (n < nArray.length && n < 20) {
                Thumbnail thumbnail = (Thumbnail)collectionModel.getElementAt(nArray[n]);
                if (thumbnail != null) {
                    PropertiesPanel.showProperties(thumbnail.getFormat(), this.controller);
                }
                ++n;
            }
        } else if (string.equals("Extract thumbs")) {
            String string3;
            Serializer serializer = this.controller.getSerializer();
            String string4 = (String)serializer.getProperty((Object)"RenameOptions", (Object)"DestinationFolder");
            if (string4 == null || string4.length() == 0) {
                string4 = this.controller.getSerializer().getHomeDirectory();
            }
            if ((string3 = (String)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"FileMask")) == null || string3.length() == 0) {
                string3 = DEFTNMASK;
            }
            FileNameFormat fileNameFormat = new FileNameFormat(string3, true);
            int n = 0;
            while (n < nArray.length) {
                BasicJpeg basicJpeg = (BasicJpeg)((Thumbnail)collectionModel.getElementAt(nArray[n])).getFormat();
                AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
                try {
                    if (abstractImageInfo != null) {
                        abstractImageInfo.saveThumbnailImage(basicJpeg, new FileOutputStream(new File(string4, FileNameFormat.makeValidPathName(fileNameFormat.format(basicJpeg), abstractImageInfo.getThumbnailExtension()))));
                    }
                }
                catch (IOException iOException) {
                    System.err.println("" + iOException);
                }
                ++n;
            }
        } else if (string.equals("Web publishing")) {
            if (nArray.length == 0) {
                return;
            }
            final Serializer serializer = this.controller.getSerializer();
            final boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"CopyWebContent"), (int)1) == 0;
            String string5 = "";
            if (!bl && (string5 = (String)JOptionPane.showInputDialog(this, "Name of HTML file", "Web publishing", 3, null, null, "")) != null) {
                LastHtmlName = string5;
            }
            if (string5 != null) {
                if (string5.indexOf(46) < 0) {
                    string5 = string5 + ".html";
                }
                final String string6 = string5;
                final File[] fileArray = this.selectionsToFiles(nArray);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block14: {
                            try {
                                Courier courier = null;
                                switch (Serializer.getInt((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"PublishingMode"), (int)0)) {
                                    case 1: {
                                        courier = new FTPCourier(PhotoCollectionPanel.this.controller);
                                        break;
                                    }
                                    case 2: {
                                        courier = new HTTPCourier(PhotoCollectionPanel.this.controller);
                                        break;
                                    }
                                    case 3: {
                                        new SendEmailFrame(PhotoCollectionPanel.this.controller, fileArray);
                                        return;
                                    }
                                    case 4: {
                                        break;
                                    }
                                    default: {
                                        courier = new FileCourier(PhotoCollectionPanel.this.controller);
                                    }
                                }
                                if (bl) {
                                    try {
                                        PhotoCollectionPanel.this.statusbar.displayInfo("Connecting");
                                        courier.init();
                                        String string = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"ImagePath");
                                        if (string == null) {
                                            string = "";
                                        } else {
                                            courier.checkForDestPath(string);
                                        }
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        PhotoCollectionPanel.this.statusbar.displayInfo("Copying");
                                        PhotoCollectionPanel.this.statusbar.setProgress(fileArray.length);
                                        int n = 0;
                                        while (n < fileArray.length) {
                                            courier.deliver(fileArray[n].getPath(), string);
                                            PhotoCollectionPanel.this.statusbar.tickProgress();
                                            ++n;
                                        }
                                        Object var5_5 = null;
                                        PhotoCollectionPanel.this.statusbar.clearInfo();
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        courier.done();
                                        break block14;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_6 = null;
                                        PhotoCollectionPanel.this.statusbar.clearInfo();
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        courier.done();
                                        throw throwable;
                                    }
                                }
                                new HtmlProducer(PhotoCollectionPanel.this.controller).produce(string6, fileArray, courier, null);
                            }
                            catch (IOException iOException) {
                                PhotoCollectionPanel.this.statusbar.flashInfo("Exception in Web publishing, see log for details.");
                                System.err.println("Exception in Web publishing " + iOException);
                                iOException.printStackTrace();
                            }
                        }
                    }
                }, "WebPublishing").start();
            }
        } else if (string.equals("Upload to print shop")) {
            if (nArray.length == 0) {
                return;
            }
            final Serializer serializer = this.controller.getSerializer();
            final String string7 = (String)JOptionPane.showInputDialog(this, "Name of album add to", "Select name of existing or new album", 3, null, null, "");
            if (string7 != null) {
                final File[] fileArray = this.selectionsToFiles(nArray);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HTTPCourier hTTPCourier = null;
                        try {
                            try {
                                hTTPCourier = new HTTPCourier(PhotoCollectionPanel.this.controller, string7);
                                PhotoCollectionPanel.this.statusbar.displayInfo("Connecting");
                                hTTPCourier.init();
                                String string = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"ImagePath");
                                if (string == null) {
                                    string = "";
                                } else {
                                    hTTPCourier.checkForDestPath(string);
                                }
                                PhotoCollectionPanel.this.statusbar.clearProgress();
                                PhotoCollectionPanel.this.statusbar.displayInfo("Copying");
                                PhotoCollectionPanel.this.statusbar.setProgress(fileArray.length);
                                int n = 0;
                                while (n < fileArray.length) {
                                    hTTPCourier.deliver(fileArray[n].getPath(), string);
                                    PhotoCollectionPanel.this.statusbar.tickProgress();
                                    ++n;
                                }
                                PhotoCollectionPanel.this.statusbar.clearInfo();
                            }
                            catch (IOException iOException) {
                                PhotoCollectionPanel.this.statusbar.flashInfo("Exception in Web publishing, see log for details.");
                                System.err.println("Exception in Web publishing " + iOException);
                                iOException.printStackTrace();
                                Object var5_6 = null;
                                PhotoCollectionPanel.this.statusbar.clearProgress();
                                if (hTTPCourier != null) {
                                    hTTPCourier.done();
                                }
                            }
                            Object var5_5 = null;
                            PhotoCollectionPanel.this.statusbar.clearProgress();
                            if (hTTPCourier != null) {
                                hTTPCourier.done();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            PhotoCollectionPanel.this.statusbar.clearProgress();
                            if (hTTPCourier != null) {
                                hTTPCourier.done();
                            }
                            throw throwable;
                        }
                    }
                }, "HTTPUpload").start();
            }
        } else if (string.equals("Print")) {
            this.controller.print(this.selectionsToFiles(nArray));
        } else if (string.equals("Send by e-mail")) {
            new SendEmailFrame(this.controller, this.selectionsToFiles(nArray));
        } else if (string.equals("Show/play list")) {
            this.showList(this.getSelectedRow());
        } else {
            int n = Controller.convertCmdToTrnasformOp(string);
            if (n != -1) {
                this.transform(nArray, n);
            }
        }
    }

    public int add(PlaybackRequest playbackRequest) {
        return this.add((File[])playbackRequest.playbackList, playbackRequest, null);
    }

    public int add(File[] fileArray) {
        return this.add(fileArray, null, null);
    }

    public int add(File[] fileArray, PlaybackRequest playbackRequest, PlaybackProperties playbackProperties) {
        int n;
        this.controller.setWaitCursor(this, true);
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n2 = n = collectionModel.getRowCount();
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (fileArray[n3].isFile()) {
                AbstractFormat abstractFormat = MediaFormatFactory.createMediaFormat(fileArray[n3]);
                if (abstractFormat != null && abstractFormat.isValid()) {
                    if (abstractFormat.getType() != "MP3") {
                        this.thumbnailspanel.addImage(abstractFormat);
                        ++n2;
                    } else if (playbackRequest == null || !playbackRequest.requestOnCopy) {
                        this.thumbnailspanel.addImage(abstractFormat);
                    } else {
                        ContentMatcher contentMatcher;
                        if (playbackProperties == null) {
                            playbackProperties = PlaybackProperties.doPropertiesDialog(this.controller, null);
                        }
                        if ((contentMatcher = playbackProperties.getMatcher()) != null && contentMatcher.match(abstractFormat)) {
                            this.thumbnailspanel.addImage(abstractFormat);
                        }
                    }
                }
            } else if (fileArray[n3].isDirectory() && (fileArray.length == 1 || playbackRequest != null && playbackRequest.recursive)) {
                n2 += this.add(fileArray[n3].listFiles(), playbackRequest, playbackProperties);
            }
            ++n3;
        }
        collectionModel.fireTableRowsInserted(n, n2);
        this.controller.setWaitCursor(this, false);
        this.updateStatusBar();
        return n2;
    }

    public void add(AbstractFormat abstractFormat) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = collectionModel.getRowCount();
        this.thumbnailspanel.addImage(abstractFormat);
        collectionModel.fireTableRowsInserted(n, n + 1);
        this.updateStatusBar();
    }

    protected void updateStatusBar() {
        Serializer serializer = this.controller.getSerializer();
        if (Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"ListLimitType"), (int)1) == 1) {
            this.statusbar.displayMetric(MP3.convertTime(this.thumbnailspanel.getTime()));
        } else {
            this.statusbar.displayMetric(BasicIo.convertLength(this.thumbnailspanel.getLength()));
        }
    }

    String transformName(File file, int n) {
        AbstractFormat abstractFormat;
        String string;
        Serializer serializer = this.controller.getSerializer();
        String string2 = (String)serializer.getProperty((Object)"RenameOptions", (Object)"DestinationFolder");
        if (string2 == null || string2.length() == 0) {
            string2 = this.controller.getSerializer().getHomeDirectory();
        }
        if ((string = (String)serializer.getProperty((Object)"TransformOptions", (Object)"Mask")) != null && (abstractFormat = MediaFormatFactory.createMediaFormat(file)) != null && abstractFormat.isValid()) {
            return string2 + File.separatorChar + FileNameFormat.makeValidPathName(new FileNameFormat(string, n, true).format(abstractFormat));
        }
        return string2 + File.separatorChar + file.getName();
    }

    int findIndexOf(Thumbnail thumbnail) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < collectionModel.getRowCount()) {
            if (collectionModel.getElementAt(n) == thumbnail) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    File[] selectionsToFiles(int[] nArray) {
        File[] fileArray = new File[nArray.length];
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < nArray.length) {
            Thumbnail thumbnail = (Thumbnail)collectionModel.getElementAt(nArray[n]);
            if (thumbnail != null) {
                fileArray[n] = thumbnail.getFormat().getFile();
            }
            ++n;
        }
        return fileArray;
    }

    void extractMarkers(int[] nArray) {
        Serializer serializer = this.controller.getSerializer();
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < nArray.length) {
            BasicJpeg basicJpeg = (BasicJpeg)((Thumbnail)collectionModel.getElementAt(nArray[n])).getFormat();
            AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
            if (abstractImageInfo != null) {
                String string = abstractImageInfo.getName();
                int n2 = string.lastIndexOf(46);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                }
                string = FileNameFormat.makeValidPathName(string, abstractImageInfo.getFormat());
                try {
                    basicJpeg.saveMarkers(new FileOutputStream(new File(basicJpeg.getParentPath(), string)));
                }
                catch (IOException iOException) {
                    System.err.println("Exception in markers extraction " + iOException);
                }
            }
            ++n;
        }
    }

    void rename(final int[] nArray) {
        String string;
        Serializer serializer = this.controller.getSerializer();
        String string2 = (String)serializer.getProperty((Object)"RenameOptions", (Object)"DestinationFolder");
        if (string2 == null || string2.length() == 0) {
            string2 = this.controller.getSerializer().getHomeDirectory();
        }
        if ((string = PhotoCollectionPanel.getRenameMask(this, serializer, " " + string2)) == null) {
            return;
        }
        final String string3 = string2;
        this.statusbar.displayInfo("Renaming");
        this.statusbar.setProgress(nArray.length);
        final boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"RenameOptions", (Object)"RemoveAfterRename"), (int)0) == 1;
        new Thread(new Runnable(){

            public void run() {
                int n = 0;
                int n2 = 0;
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                FileNameFormat fileNameFormat = new FileNameFormat(string, true);
                int n3 = 0;
                while (n3 < nArray.length) {
                    File file;
                    AbstractFormat abstractFormat = ((Thumbnail)collectionModel.getElementAt(nArray[n3])).getFormat();
                    if (abstractFormat.renameTo(file = new File(string3, FileNameFormat.makeValidPathName(fileNameFormat.format(abstractFormat))))) {
                        if (nArray[n3] > n2) {
                            n2 = nArray[n3];
                        }
                        if (nArray[n3] < n) {
                            n = nArray[n3];
                        }
                    }
                    if (bl) {
                        ((Thumbnail)collectionModel.getElementAt(nArray[n3])).select(false);
                        collectionModel.markDelete(nArray[n3]);
                    }
                    PhotoCollectionPanel.this.statusbar.tickProgress();
                    ++n3;
                }
                if (bl) {
                    collectionModel.removeAllMarked();
                    collectionModel.fireTableRowsDeleted(n, n2);
                    PhotoCollectionPanel.this.controller.getUiUpdater().notify(false, 2);
                } else {
                    collectionModel.fireTableRowsUpdated(n, n2);
                }
                PhotoCollectionPanel.this.statusbar.clearInfo();
                PhotoCollectionPanel.this.statusbar.clearProgress();
            }
        }, "Renaming").start();
    }

    void copyToRipper(final int[] nArray) {
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty((Object)"MediaOptions", (Object)"RipperFolder");
        if (string == null) {
            return;
        }
        final File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                int n = 0;
                while (n < nArray.length) {
                    AbstractFormat abstractFormat = ((Thumbnail)collectionModel.getElementAt(nArray[n])).getFormat();
                    String string = abstractFormat.getName();
                    int n2 = string.lastIndexOf(46);
                    if (n2 > 0) {
                        string = string.substring(0, n2) + ".wav";
                    }
                    File file2 = new File(file, string);
                    try {
                        Controller.convertToWav(abstractFormat, file2.getPath(), PhotoCollectionPanel.this.statusbar);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception at convertion of " + abstractFormat + " to " + file2 + ':' + exception);
                    }
                    ++n;
                }
            }
        }, "Convert to wav").start();
    }

    static String getRenameMask(Component component, Serializer serializer, String string) {
        Object object = serializer.getProperty((Object)"RenameOptions", (Object)"Mask");
        Object[] objectArray = null;
        objectArray = object == null ? new String[]{} : (object instanceof Object[] ? (Object[])object : new String[]{object.toString()});
        if (objectArray.length == 0 || objectArray.length == 1 && objectArray[0].toString().length() == 0 || objectArray.length > 1 || Serializer.getInt((Object)serializer.getProperty((Object)"RenameOptions", (Object)"AskEdit"), (int)0) == 1) {
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            jComboBox.setEditable(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JLabel("New name"), "Center");
            jPanel.add(jComboBox, "South");
            if (JOptionPane.showOptionDialog(component, jPanel, "Rename" + string, 2, 3, null, null, null) == 0) {
                return jComboBox.getEditor().getItem().toString();
            }
        } else {
            return objectArray[0].toString();
        }
        return null;
    }

    void delete(int[] nArray) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        this.statusbar.displayInfo("Removing");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            ((Thumbnail)collectionModel.getElementAt(nArray[n3])).select(false);
            collectionModel.markDelete(nArray[n3]);
            if (nArray[n3] > n2) {
                n2 = nArray[n3];
            }
            if (nArray[n3] < n) {
                n = nArray[n3];
            }
            ++n3;
        }
        collectionModel.removeAllMarked();
        collectionModel.fireTableRowsDeleted(n, n2);
        this.tableChanged(new TableModelEvent(collectionModel, n, n2, -1, -1));
        this.controller.getUiUpdater().notify(false, 2);
        this.statusbar.clearInfo();
        this.updateStatusBar();
    }

    void show(int[] nArray) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < nArray.length) {
            arrayList.add(((Thumbnail)collectionModel.getElementAt(nArray[n])).getFormat().getFile());
            ++n;
        }
        new PlaybackRequest(arrayList.toArray(new File[arrayList.size()]), this.controller.getSerializer(), false).playList(this.controller);
    }

    void showList(int n) {
        if (n < 0) {
            n = 0;
        }
        new PlaybackRequest((ListModel)((Object)this.getModel()), this.controller.getSerializer()).playList(n, this.controller);
    }

    void transform(final int[] nArray, final int n) {
        this.statusbar.displayInfo("Transforming");
        this.statusbar.setProgress(nArray.length);
        this.loadTransformOptions();
        new Thread(new Runnable(){

            public void run() {
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                int n5 = 0;
                int n2 = 0;
                int n3 = collectionModel.getRowCount();
                int n4 = 0;
                while (n4 < nArray.length) {
                    block10: {
                        String string;
                        AbstractFormat abstractFormat;
                        block8: {
                            block9: {
                                abstractFormat = ((Thumbnail)collectionModel.getElementAt(nArray[n4])).getFormat();
                                string = PhotoCollectionPanel.this.transformName(abstractFormat.getFile(), n);
                                if (n != 8) break block8;
                                if (!(abstractFormat instanceof BasicJpeg)) break block9;
                                String string2 = ((BasicJpeg)abstractFormat).getComment();
                                if ((string2 = (String)JOptionPane.showInputDialog(PhotoCollectionPanel.this, "Type a commentary", "Commentary", 3, null, null, string2)) == null) break block10;
                                ((BasicJpeg)abstractFormat).setComment(string2);
                                break block8;
                            }
                            Id3TagEditor.editTag(PhotoCollectionPanel.this.controller, abstractFormat);
                            break block10;
                        }
                        if (abstractFormat instanceof BasicJpeg && ((BasicJpeg)abstractFormat).transform(string, n, PhotoCollectionPanel.this.keeporigmarkers, PhotoCollectionPanel.this.fclass)) {
                            if (PhotoCollectionPanel.this.transformmove && abstractFormat.getFile().delete()) {
                                collectionModel.removeElementAt(nArray[n4]);
                                if (nArray[n4] > n2) {
                                    n2 = nArray[n4];
                                }
                                if (nArray[n4] < n5) {
                                    n5 = nArray[n4];
                                }
                            }
                            if (PhotoCollectionPanel.this.transformaddsel) {
                                PhotoCollectionPanel.this.add(new File[]{new File(string)});
                            }
                            PhotoCollectionPanel.this.statusbar.tickProgress();
                        }
                    }
                    ++n4;
                }
                if (PhotoCollectionPanel.this.transformaddsel) {
                    collectionModel.fireTableRowsInserted(n3 - 1, n3 + nArray.length - 1);
                    PhotoCollectionPanel.this.tableChanged(new TableModelEvent(collectionModel, n3 - 1, n3 + nArray.length - 1, -1, 1));
                }
                if (PhotoCollectionPanel.this.transformmove) {
                    collectionModel.fireTableRowsDeleted(n5, n2);
                    PhotoCollectionPanel.this.tableChanged(new TableModelEvent(collectionModel, n5, n2, -1, -1));
                    PhotoCollectionPanel.this.controller.getUiUpdater().notify(false, 2);
                }
                PhotoCollectionPanel.this.statusbar.clearInfo();
                PhotoCollectionPanel.this.statusbar.clearProgress();
            }
        }, "Transforming").start();
    }

    void loadTransformOptions() {
        Serializer serializer = this.controller.getSerializer();
        this.keeporigmarkers = Serializer.getInt((Object)serializer.getProperty((Object)"TransformOptions", (Object)"Keep"), (int)0) == 1;
        this.transformmove = Serializer.getInt((Object)serializer.getProperty((Object)"TransformOptions", (Object)"Move"), (int)0) == 0;
        this.transformaddsel = Serializer.getInt((Object)serializer.getProperty((Object)"TransformOptions", (Object)"TransformedToSelection"), (int)1) == 1;
        String string = (String)serializer.getProperty((Object)"TransformOptions", (Object)"Format");
        this.fclass = null;
        if (string != null && !this.keeporigmarkers) {
            if ("Exif".equals(string)) {
                this.fclass = class$photoorganizer$formats$Exif == null ? (class$photoorganizer$formats$Exif = PhotoCollectionPanel.class$("photoorganizer.formats.Exif")) : class$photoorganizer$formats$Exif;
            } else if ("CIFF".equals(string)) {
                this.fclass = class$photoorganizer$formats$CIFF == null ? (class$photoorganizer$formats$CIFF = PhotoCollectionPanel.class$("photoorganizer.formats.CIFF")) : class$photoorganizer$formats$CIFF;
            } else if ("JFXX".equals(string)) {
                this.fclass = class$photoorganizer$formats$JFXX == null ? (class$photoorganizer$formats$JFXX = PhotoCollectionPanel.class$("photoorganizer.formats.JFXX")) : class$photoorganizer$formats$JFXX;
            } else if ("From ext file".equals(string)) {
                this.fclass = class$photoorganizer$formats$AbstractImageInfo == null ? (class$photoorganizer$formats$AbstractImageInfo = PhotoCollectionPanel.class$("photoorganizer.formats.AbstractImageInfo")) : class$photoorganizer$formats$AbstractImageInfo;
            }
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Integer[] integerArray = new Integer[this.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            try {
                integerArray[n] = new Integer(this.getColumn(this.getColumnName(n)).getWidth());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                integerArray[n] = Resources.I_NO;
            }
            ++n;
        }
        serializer.setProperty((Object)SECNAME, (Object)COLWIDTH, (Object)integerArray);
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray = (Object[])serializer.getProperty((Object)SECNAME, (Object)COLWIDTH);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.getColumn(this.getColumnName(n)).setWidth((Integer)objectArray[n]);
            this.getColumn(this.getColumnName(n)).setPreferredWidth((Integer)objectArray[n]);
            ++n;
        }
    }

    JPopupMenu getRMouseMenu() {
        return new RButtonMenu();
    }

    public String getName() {
        return "Selection";
    }

    public String toString() {
        return this.getName();
    }

    public Iterator getKeyMnemonics() {
        return Arrays.asList(new Object[0]).iterator();
    }

    public boolean doAction(String string) {
        return false;
    }

    public void bringOnTop() {
        this.controller.selectTab("Selection");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CollectionModel
    extends BaseConfigurableTableModel
    implements ListModel {
        Vector collection;
        Vector marked = new Vector(10);

        CollectionModel(Controller controller) {
            this.updateView(controller.getSerializer());
        }

        protected int getDescriptionIndex() {
            return 1;
        }

        public int getRowCount() {
            return PhotoCollectionPanel.this.thumbnailspanel.getComponentCount();
        }

        public Object getValueAt(int n, int n2) {
            AbstractFormat abstractFormat = ((Thumbnail)((Object)PhotoCollectionPanel.this.thumbnailspanel.getComponent(n))).getFormat();
            if (abstractFormat == null) {
                return null;
            }
            return this.getValueAt(abstractFormat.getFile(), abstractFormat.getInfo(), n2);
        }

        public Object getElementAt(int n) {
            try {
                return PhotoCollectionPanel.this.thumbnailspanel.getComponent(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        void removeElementAt(int n) {
            PhotoCollectionPanel.this.thumbnailspanel.remove(n);
        }

        void markDelete(int n) {
            this.marked.addElement(PhotoCollectionPanel.this.thumbnailspanel.getComponent(n));
        }

        void removeAllMarked() {
            int n = 0;
            while (n < this.marked.size()) {
                PhotoCollectionPanel.this.thumbnailspanel.remove((Component)this.marked.elementAt(n));
                ++n;
            }
            this.marked.removeAllElements();
            PhotoCollectionPanel.this.thumbnailspanel.adjustDimension();
        }

        public void fireTableRowsUpdated(int n, int n2) {
            super.fireTableRowsUpdated(n, n2);
            int n3 = n;
            while (n3 <= n2) {
                ((Thumbnail)((Object)PhotoCollectionPanel.this.thumbnailspanel.getComponent(n3))).update();
                ++n3;
            }
        }

        public int getSize() {
            return this.getRowCount();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    class RButtonMenu
    extends JPopupMenu {
        RButtonMenu() {
            JMenuItem jMenuItem = new JMenuItem("Invert selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem = new JMenuItem("Select all");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            this.addSeparator();
            jMenuItem = new JMenuItem("Show/Play");
            this.add(jMenuItem);
            this.addSeparator();
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("To album");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("To ripper");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("Extract markers");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            this.addSeparator();
            jMenuItem = new JMenuItem("Rename");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            this.addSeparator();
            jMenuItem = new JMenuItem("Print");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            this.addSeparator();
            JMenu jMenu = Controller.createTransformMenu(PhotoCollectionPanel.this);
            this.add(jMenu);
            jMenu.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(2));
        }
    }
}

