/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import photoorganizer.formats.BasicIo;

class Header
extends BasicIo {
    int minorVersion;
    int dllVersion;
    boolean intelByteOrder;
    int sectorSize;
    static final int SECTORSIZEOFF = 30;
    int miniSectorSize;
    static final int MINISECTORSIZEOFF = 32;
    int sectsFat;
    static final int SECTSFATOFF = 44;
    int sectDirStart;
    static final int SECTDIRSTARTOFF = 48;
    int miniSectorCutoff;
    static final int MINISECTORCUTOFFOFF = 56;
    int sectMiniFatStart;
    static final int SECTMINIFATSTARTOFF = 60;
    int sectsMiniFat;
    static final int SECTSMINIFATOFF = 64;
    int sectDifStart;
    static final int SECTDIFSTARTOFF = 68;
    int sectsDif;
    static final int SECTSDIFOFF = 72;
    int[] fat;
    static final int FATOFF = 76;
    static final int FIRST_FAT_SIZE = 109;

    Header() {
    }

    void fill(byte[] byArray, int n) {
        this.data = byArray;
        this.intel = true;
        this.intelByteOrder = true;
        this.sectorSize = 1 << this.s2n(30 + n, 2);
        this.miniSectorSize = 1 << this.s2n(32 + n, 2);
        this.sectsFat = this.s2n(44 + n, 4);
        this.sectDirStart = this.s2n(48 + n, 4);
        this.miniSectorCutoff = this.s2n(56 + n, 4);
        this.sectMiniFatStart = this.s2n(60 + n, 4);
        this.sectsMiniFat = this.s2n(64 + n, 4);
        this.sectDifStart = this.s2n(68 + n, 4);
        this.sectsDif = this.s2n(72 + n, 4);
        this.fat = new int[109];
        int n2 = 0;
        while (n2 < 109) {
            this.fat[n2] = this.s2n(76 + n + 4 * n2, 4);
            ++n2;
        }
    }

    public String toString() {
        String string = "Sector size " + this.sectorSize + ", mini sector size " + this.miniSectorSize + ", sectors in FAT " + this.sectsFat + ", directory sector " + this.sectDirStart + ", max size of mini stream " + this.miniSectorCutoff + ", mini FAT starts " + this.sectMiniFatStart + ", sectors in mini FAT " + this.sectsMiniFat + ", first DIF and numbers " + this.sectDifStart + ':' + this.sectsDif;
        return string;
    }
}

