/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class KunststoffListUI
extends BasicListUI {
    private boolean isToolkitTrueColor = false;
    private Color colBg;
    private Color col1;
    private Color col2;
    private int shadow = 48;

    public KunststoffListUI(JComponent list) {
        this.isToolkitTrueColor = this.isToolkitTrueColor(list);
    }

    public static ComponentUI createUI(JComponent list) {
        return new KunststoffListUI(list);
    }

    private boolean isToolkitTrueColor(Component c) {
        int pixelsize = c.getToolkit().getColorModel().getPixelSize();
        return pixelsize >= 24;
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g2D = (Graphics2D)g;
            this.colBg = c.getBackground();
            int red = this.colBg.getRed();
            int green = this.colBg.getGreen();
            int blue = this.colBg.getBlue();
            g2D.setColor(this.colBg);
            g2D.fill(g.getClipBounds());
            this.col1 = new Color(red >= this.shadow ? red - this.shadow : 0, green >= this.shadow ? green - this.shadow : 0, blue >= this.shadow ? blue - this.shadow : 0);
            this.col2 = KunststoffListUI.getTranslucentColor(this.col1, 0);
            Rectangle cb = g.getClipBounds();
            if (this.isToolkitTrueColor) {
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.colBg, this.list.getWidth(), 0.0f, new Color(224, 224, 224));
                g2D.setPaint(gradient);
                g2D.fill(cb);
            } else {
                g2D.setColor(this.colBg);
                g2D.fill(cb);
                GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, this.col1, 0.0f, 5.0f, this.col2);
                g2D.setPaint(gradientTop);
                g2D.fill(new Rectangle(cb.x, cb.y, cb.width, 20));
                GradientPaint gradientLeft = new GradientPaint(0.0f, 0.0f, this.col1, 5.0f, 0.0f, this.col2);
                g2D.setPaint(gradientLeft);
                g2D.fill(new Rectangle(cb.x, cb.y, 20, cb.height));
            }
        }
        this.paint(g, c);
    }

    private static Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }
}

