/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AP_Player.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



import java.io.*;
import java.applet.Applet;



/**
 * The <code>AP_Player</code> class implements a simple player for playback
 * of an MPEG audio stream.
 *
 */

public class AP_Player extends AudioDecoder implements Runnable
{
	/**
	 * The MPEG audio bitstream.
	 */
	/*final*/ private BufferedBitStream bitstream;

	/**
	 * The MPEG audio decoder.
	 */
	/*final*/ private AD_Decoder		decoder;

	/**
	 * The AP_AudioDevice the audio samples are written to.
	 */
	private AP_AudioDevice	audio;

    // Audio header
	private final AD_Header			header = new AD_Header();
	private AD_Crc16[]					crc = new AD_Crc16[1];

	private volatile Thread audio_thread;		// The audio decoder runs as thread




	/**
	 * Creates a new <code>AP_Player</code> instance.
	 */
	public AP_Player()
	{
	}


        public Thread getThread() {
          return audio_thread;
        }

        public void init(BufferedBitStream stream) {
		bitstream = stream;
		decoder = new AD_Decoder();

		try {
			AP_FactoryRegistry r = AP_FactoryRegistry.systemRegistry();
			audio = r.createAudioDevice();
			audio.open(decoder);
		} catch (AD_JavaLayerException ex) {
			System.err.println("Problem playing audio: " + ex);
		}

		// Tell decoder to downconvert?
		if (audio.isEightBitEightKhzMuLaw()) {
			decoder.getParams().setDownconvert();
		}
        }

	public void start() {
		audio_thread = new Thread(this, "Audio Decoder");
		audio_thread.start();
	}

	public void run() {

		Thread thisThread = Thread.currentThread();
		try {
			while ((thisThread == audio_thread) &&  decodeFrame()); // dont use showCode...dumps audiodata, showBits semms to works instead
			// Last frame, ensure all data flushed to the audio device.
			AP_AudioDevice out = audio;
			//if (out != null) out.flush(); // Why use this?!?! (seems to lead to a loop in JavaSoundAudioDevice, so skipped)
		} catch (AD_JavaLayerException ex) {
			System.err.println("Problem playing audio: " + ex);
		} catch (InterruptedException ex) {
			// System.out.println("audio.player.AP_Player() stopped -- exiting run()");
		}
		audio.stop();
		audio.close();
		audio = null;
	}

	/**
	 * Turns on audio output device
	 *
	 */
	public void play() {
          if (audio!=null) audio.play(); // if no audio, run may have set audio to null already
	}

	/**
	 * Cloases this player. Any audio currently playing is stopped
	 * immediately.
	 */
	public void stop() {
		///bitstream.stop();
               // if (audio!=null) {
                if (audio_thread!=null) {
                  try {
                    audio_thread.interrupt(); // Verkar bli exception hr nr man kr i browser!!! (men nd funkar interrupten...?!)
                  } catch (Exception e) {}
                }
                //audio.stop();
               // }


		//bitstream.reset();
		//bitstream = null;

		/*Thread moribund = audio_thread;
                audio_thread = null;
		moribund.interrupt();

		// Wait until audio dead
		try { moribund.join(); } catch (InterruptedException ex) { System.out.println("strange---interrupted"); }
                */
	}



	/**
	 * Is buffer full enough to start decoding video?
	 *
	 * @return true if output buffer is full enough
	 */
	public boolean isStoked() {
		// If buffer's 25% full, turn on video decoding!
		if (audio.getFillRatio() > 0.30) {
			return true;
		}
		return false;
	}

	/**
	 * Decodes a single frame.
	 *
	 * @return true if there are no more frames to decode, false otherwise.
	 */

        private long lastPTS;
	private boolean decodeFrame() throws AD_JavaLayerException, InterruptedException {
		if (audio == null || bitstream.isStopped()) return false;

		header.read_header(bitstream, crc);

		// sample buffer set when decoder constructed
		AD_Obuffer output = decoder.decodeFrame(header, bitstream);
                long pts = 0;
                if (bitstream.getPTS()>lastPTS) {
                  pts = lastPTS = bitstream.getPTS();
                }

		synchronized (this) {
			AP_AudioDevice out = audio;
			if (out != null) {
				out.write(output.getBuffer(), 0, output.getBufferLength(), pts, bitstream.getSysDecoder());
			}
		}

		return true;
	}
}
