/*
 * Decompiled with CFR 0.152.
 */
package rogatkin;

import java.util.HashMap;

public class HttpUtils {
    static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "+", "!", "%22", "%23", "$", "%25", "%26", "'", "(", ")", "*", "%2b", ",", "-", ".", "%2f", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%5b", "%5c", "%5d", "%5e", "_", "%60", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
    static HashMap htmlEscMap = new HashMap(4);

    public static String urlEncode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            stringBuffer.append(hex[n2]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String urlEncode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2) & 0xFF;
            stringBuffer.append(hex[n3]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String urlHexEncode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '.' || cArray[n] >= 'A' && cArray[n] <= 'Z' || cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= '0' && cArray[n] <= '9') {
                stringBuffer.append(cArray[n]);
            } else if (cArray[n] < '\u0010') {
                stringBuffer.append('%').append('0').append(Integer.toHexString(cArray[n] & 0xFF));
            } else {
                stringBuffer.append('%').append(Integer.toHexString(cArray[n] & 0xFF));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String urlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '%' && n2 + 2 < n) {
                int n3 = Character.digit(string.charAt(n2 + 1), 16);
                int n4 = Character.digit(string.charAt(n2 + 2), 16);
                if (n3 != -1 && n4 != -1) {
                    stringBuffer.append((char)((n3 << 4) + n4));
                }
                n2 += 2;
            } else if (string.charAt(n2) == '+') {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String htmlEncode(String string) {
        return HttpUtils.htmlEncode(string, false, false);
    }

    public static String htmlEncode(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        boolean bl3 = true;
        int n2 = 0;
        while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '<': {
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append("&lt;");
                    n = n2 + 1;
                    break;
                }
                case '>': {
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append("&gt;");
                    n = n2 + 1;
                    break;
                }
                case '\"': {
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append("&quot;");
                    n = n2 + 1;
                    break;
                }
                case '&': {
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append("&amp;");
                    n = n2 + 1;
                    break;
                }
                case ' ': {
                    if (bl3 && (bl || bl2)) {
                        stringBuffer.append(cArray, n, n2 - n);
                        stringBuffer.append("&nbsp;");
                        n = n2 + 1;
                        break;
                    }
                    bl3 = true;
                    break;
                }
                case '\n': {
                    if (!bl2) break;
                    stringBuffer.append(cArray, n, n2 - n);
                    stringBuffer.append("<BR>");
                    n = n2 + 1;
                    break;
                }
                default: {
                    bl3 = false;
                    bl = false;
                }
            }
            ++n2;
        }
        if (n < cArray.length) {
            stringBuffer.append(cArray, n, cArray.length - n);
        }
        return stringBuffer.toString();
    }

    public static String htmlDecode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        do {
            int n3;
            if ((n3 = string.indexOf(38, n2)) < 0) {
                stringBuffer.append(string.substring(n2, n));
                break;
            }
            stringBuffer.append(string.substring(n2, n3));
            int n4 = string.indexOf(59, n3 + 1);
            if (n3 > 0) {
                String string2 = (String)htmlEscMap.get(string.substring(n3 + 1, n4));
                if (string2 != null) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append('?');
                }
            } else {
                stringBuffer.append(string.substring(n2, n));
                break;
            }
            n2 = n4 + 1;
        } while (n2 < n);
        return stringBuffer.toString();
    }

    static {
        htmlEscMap.put("lt", "<");
        htmlEscMap.put("gt", ">");
        htmlEscMap.put("quot", "\"");
        htmlEscMap.put("amp", "&");
        htmlEscMap.put("reg", "\u00ae");
        htmlEscMap.put("copy", "\u00a9");
        htmlEscMap.put("nbsp", " ");
    }
}

