/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.renderer.MediaList;
import rogatkin.HttpUtils;
import rogatkin.XmlExposable;
import rogatkin.XmlHelper;

class VirtualFolder
extends ArrayList
implements XmlExposable {
    String name;
    MediaList medias;

    VirtualFolder(String string) {
        this.name = string;
    }

    void addMedia(AbstractFormat abstractFormat) {
        if (this.medias == null) {
            this.medias = new MediaList();
        }
        this.medias.add(abstractFormat);
    }

    void addMedia(File file) {
        if (this.medias == null) {
            this.medias = new MediaList();
        }
        this.medias.add(file);
    }

    void addMedia(Object object) {
        if (this.medias == null) {
            this.medias = new MediaList();
        }
        this.medias.add(object);
    }

    List getContent() {
        return this.medias;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public long getLength() {
        return this.medias != null ? this.medias.getLength() : 0L;
    }

    public int getTime() {
        return this.medias != null ? this.medias.getTime() : 0;
    }

    public String toXmlString() {
        Object e;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.medias != null) {
            iterator = this.medias.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e instanceof XmlExposable) {
                    stringBuffer.append(((XmlExposable)e).toXmlString());
                    continue;
                }
                if (e instanceof AbstractFormat) {
                    XmlHelper.appendTag((StringBuffer)stringBuffer, (String)"media", (String)XmlHelper.appendAttr((String)XmlHelper.appendAttr(null, (String)"media_type", (String)((AbstractFormat)e).getType()), (String)"name", (String)((AbstractFormat)e).getType()), (String)HttpUtils.htmlEncode((String)((AbstractFormat)e).getFile().getPath()), (String)this.getNameSpacePrefix());
                    continue;
                }
                if (!(e instanceof File)) continue;
                XmlHelper.appendTag((StringBuffer)stringBuffer, (String)"file", null, (String)HttpUtils.htmlEncode((String)((File)e).getPath()), (String)this.getNameSpacePrefix());
            }
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof XmlExposable)) continue;
            stringBuffer.append(((XmlExposable)e).toXmlString());
        }
        return XmlHelper.getTag((String)"folder", (String)XmlHelper.appendAttr(null, (String)"name", (String)this.name), (String)(stringBuffer == null ? null : stringBuffer.toString()), (String)this.getNameSpacePrefix());
    }

    public String getNameSpacePrefix() {
        return "MediaChest";
    }

    public String getNameSpaceUri() {
        return "http://mediachest.sourceforge.net/";
    }

    public DefaultHandler getXmlHandler(final ContentHandler contentHandler, String string, String string2, String string3, Attributes attributes) {
        return new DefaultHandler(){
            ContentHandler handler;
            ContentHandler parentHandler;
            String file;
            boolean open;
            {
                this.parentHandler = contentHandler;
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (this.handler != null) {
                    this.handler.startElement(string, string2, string3, attributes);
                } else if ((VirtualFolder.this.getNameSpacePrefix() + ':' + "folder").equals(string3)) {
                    if (!this.open) {
                        VirtualFolder.this.setName(attributes.getValue("name"));
                        this.open = true;
                    } else {
                        VirtualFolder virtualFolder = new VirtualFolder(attributes.getValue("name"));
                        VirtualFolder.this.add(virtualFolder);
                        this.handler = virtualFolder.getXmlHandler(this, string, string2, string3, attributes);
                        this.handler.startElement(string, string2, string3, attributes);
                    }
                } else if ((VirtualFolder.this.getNameSpacePrefix() + ':' + "file").equals(string3)) {
                    this.file = null;
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (this.handler != null) {
                    this.handler.endElement(string, string2, string3);
                } else if ((VirtualFolder.this.getNameSpacePrefix() + ':' + "folder").equals(string3)) {
                    if (this.parentHandler != null) {
                        this.parentHandler.endDocument();
                    }
                    this.open = false;
                } else if ((VirtualFolder.this.getNameSpacePrefix() + ':' + "file").equals(string3)) {
                    if (this.handler != null) {
                        this.handler.endElement(string, string2, string3);
                    } else {
                        VirtualFolder.this.addMedia(new File(HttpUtils.htmlDecode((String)this.file)));
                    }
                }
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                if (this.handler != null) {
                    this.handler.characters(cArray, n, n2);
                } else {
                    this.file = this.file == null ? new String(cArray, n, n2) : this.file + new String(cArray, n, n2);
                }
            }

            public void endDocument() throws SAXException {
                this.handler = null;
            }
        };
    }
}

