/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import addressbook.AddressBookFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.HtmlProducer;
import photoorganizer.courier.MailCourier;
import photoorganizer.renderer.MiscellaneousOptionsTab;
import rogatkin.ActionPerformer;
import rogatkin.BaseController;
import rogatkin.GranulatedLayout;
import rogatkin.LocalizedInputTextArea;
import rogatkin.Serializer;

public class SendEmailFrame
extends JFrame
implements ActionListener,
ActionPerformer {
    static final int MAX_SUBJECT_LENGTH = 100;
    Controller controller;
    static AddressBookFrame ab;
    File[] files_to_send;
    JTextField tf_to;
    JTextArea ta;

    public SendEmailFrame(Controller controller, File[] fileArray) {
        super("Send E-mail");
        this.controller = controller;
        this.setIconImage(controller.getMainIcon());
        this.files_to_send = fileArray;
        this.getContentPane().add((Component)new SendEmail(), "Center");
        this.getContentPane().add((Component)new AcionButtons(), "South");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Address Book")) {
            ActionPerformer actionPerformer = (ActionPerformer)this.controller.component(AddressBookFrame.COMP_ACTIONPERFORMER);
            if (actionPerformer == null) {
                this.controller.add(this, AddressBookFrame.COMP_ACTIONPERFORMER);
            }
            if (ab == null || !ab.isShowing()) {
                ab = new AddressBookFrame((BaseController)this.controller);
            } else {
                if (ab.getState() == 1) {
                    ab.setState(0);
                }
                ab.requestFocus();
            }
            return;
        }
        if (string.equals("OK")) {
            new Thread(new Runnable(){

                public void run() {
                    SendEmailFrame.this.send();
                }
            }, "E-Mail sender").start();
        }
        this.controller.add(null, AddressBookFrame.COMP_ACTIONPERFORMER);
        this.dispose();
    }

    public void act(int n, Object object) {
        if (n == 1) {
            String string = this.tf_to.getText();
            if (string.length() > 0) {
                this.tf_to.setText(string + ',' + (String)object);
            } else {
                this.tf_to.setText((String)object);
            }
        }
    }

    void send() {
        Properties properties = System.getProperties();
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"SMTPServer");
        if (string != null && string.length() > 0) {
            properties.put("mail.smtp.host", string);
        }
        try {
            Session session = Session.getDefaultInstance((Properties)properties, null);
            session.setDebug(true);
            String string2 = MiscellaneousOptionsTab.getEncoding(this.controller);
            MimeMessage mimeMessage = new MimeMessage(session);
            string = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"E-MailAddress");
            String string3 = Serializer.arrayToString((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"SMTPUser"));
            if (string != null) {
                if (string2 != null && string2.length() > 0) {
                    mimeMessage.setFrom((Address)(string3 != null ? new InternetAddress(string, string3, string2) : new InternetAddress(string)));
                } else {
                    mimeMessage.setFrom((Address)(string3 != null ? new InternetAddress(string, string3) : new InternetAddress(string)));
                }
            } else {
                mimeMessage.setFrom();
            }
            string = (String)serializer.getProperty((Object)"WebPublishOptions", (Object)"Reply");
            if (string != null && string.length() > 0) {
                mimeMessage.setReplyTo((Address[])InternetAddress.parse((String)string));
            }
            string = this.tf_to.getText();
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string, (boolean)false));
            MimeMultipart mimeMultipart = new MimeMultipart("related");
            MimeMultipart mimeMultipart2 = new MimeMultipart("alternative");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Multipart)mimeMultipart2);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            string = this.ta.getText();
            if (string.length() > 0) {
                String string4 = new StringTokenizer(string, "\n\r").nextToken();
                if (string4.length() > 100) {
                    string4 = string4.substring(0, 99);
                }
                mimeBodyPart = new MimeBodyPart();
                if (string2 != null && string2.length() > 0) {
                    mimeBodyPart.setContent((Object)string, "text/plain; charset=" + string2);
                    mimeMessage.setSubject(string4, string2);
                } else {
                    mimeBodyPart.setContent((Object)string, "text/plain");
                    mimeMessage.setSubject(string4);
                }
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            } else {
                mimeMessage.setSubject("Information you've requested");
            }
            new HtmlProducer(this.controller).produce((Courier)new MailCourier(this.controller, (Multipart)mimeMultipart, (Multipart)mimeMultipart2), this.files_to_send, string);
            mimeMessage.setHeader("X-Mailer", "MediaChest (http://mediachest.sourceforge.net/MediaChest.html)");
            mimeMessage.setHeader("Organization", Serializer.arrayToString((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"Organization")));
            mimeMessage.setDescription(Serializer.arrayToString((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"Organization")));
            mimeMessage.setSentDate(new Date());
            mimeMessage.setContent((Multipart)mimeMultipart);
            Transport.send((Message)mimeMessage);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "E-Mail sending failed, check e-mail settings.\n" + iOException, "Error", 0);
            iOException.printStackTrace();
        }
        catch (MessagingException messagingException) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "E-Mail sending failed, check e-mail settings.\n" + (Object)((Object)messagingException), "Error", 0);
            messagingException.printStackTrace();
        }
    }

    class AcionButtons
    extends JPanel {
        AcionButtons() {
            this.setLayout(new FlowLayout(2));
            JButton jButton = new JButton("OK");
            this.add(jButton);
            jButton.addActionListener(SendEmailFrame.this);
            jButton = new JButton("Cancel");
            this.add(jButton);
            jButton.addActionListener(SendEmailFrame.this);
        }
    }

    class SendEmail
    extends JPanel {
        SendEmail() {
            this.setLayout((LayoutManager)new GranulatedLayout(5, 7, 20, 4, 8, 8));
            this.setBorder(new BevelBorder(0));
            this.add((Component)new JLabel("Send by e-mail"), "0,0,2");
            SendEmailFrame.this.tf_to = new JTextField();
            this.add((Component)SendEmailFrame.this.tf_to, "0,1,3");
            JButton jButton = new JButton("Address Book");
            this.add((Component)jButton, "3,1,2");
            jButton.addActionListener(SendEmailFrame.this);
            SendEmailFrame.this.ta = new LocalizedInputTextArea();
            this.add((Component)new JScrollPane(SendEmailFrame.this.ta), "0,2,5,-1");
        }
    }
}

