/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.Locale;

public final class TypeConverter {
    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, 2, false, false, false, false);
    }

    public static String toString(Object object, int n) {
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, n, false, false, false, false);
    }

    public static String toString(Object object, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, n, bl, bl2, bl3, bl4);
    }

    public static String double2String(double d) {
        return TypeConverter.double2String(d, 2, false, false, false, false);
    }

    public static String double2String(double d, int n) {
        return TypeConverter.double2String(d, n, false, false, false, false);
    }

    public static String double2String(double d, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        char[] cArray;
        int n4;
        String string;
        boolean bl5;
        if (Math.abs(d) < 1.0E-10) {
            String string2 = "0";
            if (!bl4 && n != 0) {
                char[] cArray2 = new char[n];
                int n5 = 0;
                while (n5 < n) {
                    cArray2[n5] = 48;
                    ++n5;
                }
                string2 = String.valueOf(string2) + "." + new String(cArray2);
            }
            return String.valueOf(bl3 ? "+" : (bl ? "-" : "")) + string2;
        }
        boolean bl6 = bl5 = d >= 0.0;
        if (!bl5) {
            d = -d;
        }
        if (n < 0) {
            if (n < -100) {
                n = -100;
            }
            double d2 = Math.pow(10.0, n);
            d = (double)Math.round(d * d2) / d2;
            n = 0;
        }
        if ((string = Double.toString(d)).indexOf(69) != -1) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(n + 1);
            numberFormat.setGroupingUsed(false);
            string = numberFormat.format(d);
        }
        if ((n4 = string.indexOf(46)) != -1 && string.length() > n4 + n + 1) {
            cArray = new char[n4 + n + 1];
            n3 = string.charAt(n4 + n + 1) < '5' ? 0 : 1;
            n2 = n4 + n;
            while (n2 >= 0) {
                char c = string.charAt(n2);
                if (c < '0' || c > '9') {
                    cArray[n2] = c;
                } else if (n3 == 0) {
                    cArray[n2] = c;
                } else if (c == '9') {
                    cArray[n2] = 48;
                    n3 = 1;
                } else {
                    cArray[n2] = (char)(c + '\u0001');
                    n3 = 0;
                }
                --n2;
            }
            string = new String(cArray);
            if (n3 != 0) {
                string = "1" + string;
                ++n4;
            }
        }
        if (n4 != -1) {
            int n6 = string.length() - 1;
            while (n6 >= 0) {
                if (string.charAt(n6) != '0') break;
                --n6;
            }
            if (n6 != n4) {
                ++n6;
            }
            string = string.substring(0, n6);
        }
        if (!bl4 && n != 0) {
            cArray = new char[n];
            n3 = 0;
            while (n3 < n) {
                cArray[n3] = 48;
                ++n3;
            }
            n2 = string.indexOf(46);
            string = n2 == -1 ? String.valueOf(string) + '.' + new String(cArray, 0, n) : String.valueOf(string) + new String(cArray, 0, n - (string.length() - n2 - 1));
        }
        if (bl5) {
            if (bl) {
                string = "-" + string;
            } else if (bl3) {
                string = "+" + string;
            }
        } else if (bl2) {
            string = "(-" + string + ")";
            if (bl) {
                string = "-" + string;
            } else if (bl3) {
                string = "+" + string;
            }
        } else if (!bl) {
            string = "-" + string;
        } else if (bl3) {
            string = "+" + string;
        }
        return string;
    }

    public static double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        try {
            return Double.valueOf(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static int toInteger(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return 1;
            }
            return 0;
        }
        try {
            return Double.valueOf(object.toString().trim()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() > 0;
        }
        return Boolean.valueOf(object.toString().trim());
    }

    public static Color toColor(Object object) {
        if (object == null) {
            return Color.black;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        return TypeConverter.parseColor(object.toString(), Color.black);
    }

    public static Color parseColor(String string, Color color) {
        if (string == null) {
            return color;
        }
        String string2 = string.toLowerCase().trim();
        if (string2.startsWith("#")) {
            try {
                int n = Integer.parseInt(string2.substring(1), 16);
                return new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        if (string2.equals("null")) {
            return null;
        }
        if (string2.equals("red")) {
            return Color.red;
        }
        if (string2.equals("green")) {
            return Color.green;
        }
        if (string2.equals("blue")) {
            return Color.blue;
        }
        if (string2.equals("pink")) {
            return Color.pink;
        }
        if (string2.equals("orange")) {
            return Color.orange;
        }
        if (string2.equals("magenta")) {
            return Color.magenta;
        }
        if (string2.equals("cyan")) {
            return Color.cyan;
        }
        if (string2.equals("white")) {
            return Color.white;
        }
        if (string2.equals("yellow")) {
            return Color.yellow;
        }
        if (string2.equals("gray")) {
            return Color.gray;
        }
        if (string2.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string2.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string2.equals("black")) {
            return Color.black;
        }
        return color;
    }
}

