/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import tools.GraphXY;
import tools.TypeConverter;
import tools.XY;

public final class Axes {
    public boolean dynamic = false;
    public double beg = -1.0;
    public double end = 1.0;
    public boolean axes = true;
    public String text;
    public int width = 1;
    public boolean arrow = true;
    public int arrowWidth = 3;
    public int arrowLength = 17;
    public Color color = Color.black;
    public boolean ticksAuto = true;
    public boolean ticksAxes = true;
    public boolean ticksBeg = false;
    public boolean ticksEnd = false;
    public boolean ticksNet = false;
    public boolean ticksDigAxes = true;
    public boolean ticksDigBeg = false;
    public boolean ticksDigEnd = false;
    public int ticks1 = 4;
    public int ticks2 = 2;
    public int ticks3 = 2;
    public Color ticksColor = Color.black;
    public String txtFontName = "TimesRoman";
    public boolean txtFontBold = true;
    public boolean txtFontItalic = true;
    public int txtFontSize = 14;
    public String digFontName = "Courier";
    public boolean digFontBold = false;
    public boolean digFontItalic = false;
    public int digFontSize = 10;

    public static void auto(GraphXY graphXY) {
        double d;
        Axes axes = graphXY.xAxes;
        Axes axes2 = graphXY.yAxes;
        if (axes.beg > axes.end) {
            d = axes.beg;
            axes.beg = axes.end;
            axes.end = d;
        }
        if (axes2.beg > axes2.end) {
            d = axes2.beg;
            axes2.beg = axes2.end;
            axes2.end = d;
        }
        if (axes.beg == axes.end) {
            axes.beg -= 1.0;
            axes.end += 1.0;
        }
        if (axes2.beg == axes2.end) {
            axes2.beg -= 1.0;
            axes2.end += 1.0;
        }
        if (axes.ticksAuto) {
            if (axes2.beg > 0.0) {
                axes.ticksBeg = true;
                axes.ticksEnd = false;
                axes.ticksAxes = false;
            } else if (axes2.end < 0.0) {
                axes.ticksBeg = false;
                axes.ticksEnd = true;
                axes.ticksAxes = false;
            } else {
                axes.ticksBeg = false;
                axes.ticksEnd = false;
                axes.ticksAxes = true;
            }
            axes.ticksDigBeg = axes.ticksBeg;
            axes.ticksDigEnd = axes.ticksEnd;
            axes.ticksDigAxes = axes.ticksAxes;
        }
        if (axes2.ticksAuto) {
            if (axes.beg > 0.0) {
                axes2.ticksBeg = true;
                axes2.ticksEnd = false;
                axes2.ticksAxes = false;
            } else if (axes.end < 0.0) {
                axes2.ticksBeg = false;
                axes2.ticksEnd = true;
                axes2.ticksAxes = false;
            } else {
                axes2.ticksBeg = false;
                axes2.ticksEnd = false;
                axes2.ticksAxes = true;
            }
            axes2.ticksDigBeg = axes2.ticksBeg;
            axes2.ticksDigEnd = axes2.ticksEnd;
            axes2.ticksDigAxes = axes2.ticksAxes;
        }
    }

    void drawXAxes(Graphics graphics, GraphXY graphXY) {
        int n = graphXY.w;
        Font font = graphics.getFont();
        int n2 = 0;
        if (this.txtFontBold) {
            n2 |= 1;
        }
        if (this.txtFontItalic) {
            n2 |= 2;
        }
        Font font2 = new Font(this.txtFontName, n2, this.txtFontSize);
        graphics.setFont(font2);
        graphics.getFontMetrics().getHeight();
        n2 = 0;
        if (this.digFontBold) {
            n2 |= 1;
        }
        if (this.digFontItalic) {
            n2 |= 2;
        }
        Font font3 = new Font(this.digFontName, n2, this.digFontSize);
        graphics.setFont(font3);
        int n3 = graphics.getFontMetrics().getHeight();
        Point point = graphXY.XY2Point(new XY());
        if (this.axes) {
            Object object;
            graphics.setColor(this.color);
            int n4 = this.arrow && this.arrowWidth > 0 && this.arrowLength > 0 ? this.arrowLength : 0;
            graphics.drawLine(0, point.y, n - n4, point.y);
            int n5 = 0;
            while (n5 < this.width / 2) {
                graphics.drawLine(0, point.y + 1 + n5, n - n4, point.y + 1 + n5);
                graphics.drawLine(0, point.y - 1 - n5, n - n4, point.y - 1 - n5);
                ++n5;
            }
            if (this.arrow && this.arrowWidth > 0 && this.arrowLength > 0) {
                object = new int[3];
                int[] nArray = new int[3];
                object[0] = n - 1;
                nArray[0] = point.y;
                object[1] = n - this.arrowLength;
                nArray[1] = point.y - this.arrowWidth;
                object[2] = n - this.arrowLength;
                nArray[2] = point.y + this.arrowWidth + 1;
                graphics.drawPolygon((int[])object, nArray, 3);
                graphics.fillPolygon((int[])object, nArray, 3);
            }
            object = "X";
            if (this.text != null) {
                object = this.text;
            }
            graphics.setFont(font2);
            graphics.drawString((String)object, n - graphics.getFontMetrics().stringWidth((String)object) - 4 - (graphXY.yAxes.ticksEnd || graphXY.yAxes.ticksNet ? n3 : 0), point.y - (this.arrow ? this.arrowWidth : 0) - 3);
        }
        graphics.setFont(font);
    }

    void drawXAxesTicks(Graphics graphics, GraphXY graphXY) {
        int n = graphXY.h;
        Font font = graphics.getFont();
        int n2 = 0;
        if (this.digFontBold) {
            n2 |= 1;
        }
        if (this.digFontItalic) {
            n2 |= 2;
        }
        Font font2 = new Font(this.digFontName, n2, this.digFontSize);
        graphics.setFont(font2);
        int n3 = graphics.getFontMetrics().getHeight();
        Point point = graphXY.XY2Point(new XY());
        if ((this.ticksBeg || this.ticksEnd || this.ticksAxes || this.ticksNet) && this.ticks1 > 1) {
            graphics.setColor(this.ticksColor);
            XY xY = new XY();
            double d = (this.end - this.beg) / (double)this.ticks1;
            int n4 = 0;
            while (n4 < this.ticks1) {
                double d2;
                xY.x = d2 = this.beg + (double)n4 * d;
                point = graphXY.XY2Point(xY);
                if (n4 > 0) {
                    if (this.ticksNet) {
                        graphics.drawLine(point.x, 0, point.x, n);
                    } else {
                        if (this.ticksBeg) {
                            graphics.drawLine(point.x, n, point.x, n - n3);
                        }
                        if (this.ticksEnd) {
                            graphics.drawLine(point.x, 0, point.x, n3);
                        }
                        if (this.axes && this.ticksAxes && graphXY.yAxes.beg * graphXY.yAxes.end < 0.0) {
                            graphics.drawLine(point.x, point.y, point.x, point.y + n3);
                        }
                    }
                    String string = TypeConverter.double2String(d2, 2, false, false, false, true);
                    graphics.setFont(font2);
                    if (this.ticksBeg && this.ticksDigBeg) {
                        graphics.drawString(string, point.x + 2, n - n3 / 3 - 2);
                    }
                    if (this.ticksEnd && this.ticksDigEnd && (!graphXY.yAxes.arrow || graphXY.yAxes.arrowWidth == 0 || Math.abs(d2) > 1.0E-5)) {
                        graphics.drawString(string, point.x + 2, n3 + n3 / 3);
                    }
                    if (this.axes && this.ticksAxes && this.ticksDigAxes && graphXY.yAxes.beg * graphXY.yAxes.end < 0.0) {
                        graphics.drawString(string, point.x + 2, point.y + n3 + n3 / 3);
                    }
                }
                if (this.ticks2 > 1) {
                    double d3 = d / (double)this.ticks2;
                    int n5 = 0;
                    while (n5 < this.ticks2) {
                        double d4;
                        xY.x = d4 = d2 + (double)n5 * d3;
                        point = graphXY.XY2Point(xY);
                        if (n5 > 0) {
                            if (this.ticksBeg) {
                                graphics.drawLine(point.x, n, point.x, n - 2 * n3 / 3);
                            }
                            if (this.ticksEnd) {
                                graphics.drawLine(point.x, 0, point.x, 2 * n3 / 3);
                            }
                            if (this.axes && this.ticksAxes && graphXY.yAxes.beg * graphXY.yAxes.end < 0.0) {
                                graphics.drawLine(point.x, point.y, point.x, point.y + 2 * n3 / 3);
                            }
                        }
                        if (this.ticks3 > 1) {
                            double d5 = d3 / (double)this.ticks3;
                            int n6 = 0;
                            while (n6 < this.ticks3) {
                                double d6;
                                xY.x = d6 = d4 + (double)n6 * d5;
                                point = graphXY.XY2Point(xY);
                                if (n6 > 0) {
                                    if (this.ticksBeg) {
                                        graphics.drawLine(point.x, n, point.x, n - n3 / 3);
                                    }
                                    if (this.ticksEnd) {
                                        graphics.drawLine(point.x, 0, point.x, n3 / 3);
                                    }
                                    if (this.axes && this.ticksAxes && graphXY.yAxes.beg * graphXY.yAxes.end < 0.0) {
                                        graphics.drawLine(point.x, point.y, point.x, point.y + n3 / 3);
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
        }
        graphics.setFont(font);
    }

    void drawYAxes(Graphics graphics, GraphXY graphXY) {
        int n = graphXY.h;
        Font font = graphics.getFont();
        int n2 = 0;
        if (this.txtFontBold) {
            n2 |= 1;
        }
        if (this.txtFontItalic) {
            n2 |= 2;
        }
        Font font2 = new Font(this.txtFontName, n2, this.txtFontSize);
        graphics.setFont(font2);
        int n3 = graphics.getFontMetrics().getHeight();
        n2 = 0;
        if (this.digFontBold) {
            n2 |= 1;
        }
        if (this.digFontItalic) {
            n2 |= 2;
        }
        Font font3 = new Font(this.digFontName, n2, this.digFontSize);
        graphics.setFont(font3);
        int n4 = graphics.getFontMetrics().getHeight();
        Point point = graphXY.XY2Point(new XY());
        if (this.axes) {
            Object object;
            graphics.setColor(this.color);
            int n5 = this.arrow && this.arrowWidth > 0 && this.arrowLength > 0 ? this.arrowLength - 1 : 0;
            graphics.drawLine(point.x, n5, point.x, n);
            int n6 = 0;
            while (n6 < this.width / 2) {
                graphics.drawLine(point.x + 1 + n6, n5, point.x + 1 + n6, n);
                graphics.drawLine(point.x - 1 - n6, n5, point.x - 1 - n6, n);
                ++n6;
            }
            if (this.arrow && this.arrowWidth > 0 && this.arrowLength > 0) {
                object = new int[3];
                int[] nArray = new int[3];
                object[0] = point.x;
                nArray[0] = 0;
                object[1] = point.x - this.arrowWidth;
                nArray[1] = this.arrowLength;
                object[2] = point.x + this.arrowWidth + 1;
                nArray[2] = this.arrowLength;
                graphics.drawPolygon((int[])object, nArray, 3);
                graphics.fillPolygon((int[])object, nArray, 3);
            }
            object = "Y";
            if (this.text != null) {
                object = this.text;
            }
            graphics.setFont(font2);
            graphics.drawString((String)object, point.x + (this.arrow ? this.arrowWidth : 0) + 3, n3 + (graphXY.xAxes.ticksEnd || graphXY.xAxes.ticksNet ? n4 : 0));
        }
        graphics.setFont(font);
    }

    void drawYAxesTicks(Graphics graphics, GraphXY graphXY) {
        int n = graphXY.w;
        Font font = graphics.getFont();
        int n2 = 0;
        if (this.digFontBold) {
            n2 |= 1;
        }
        if (this.digFontItalic) {
            n2 |= 2;
        }
        Font font2 = new Font(this.digFontName, n2, this.digFontSize);
        graphics.setFont(font2);
        int n3 = graphics.getFontMetrics().getHeight();
        Point point = graphXY.XY2Point(new XY());
        if ((this.ticksBeg || this.ticksEnd || this.ticksAxes || this.ticksNet) && this.ticks1 > 1) {
            graphics.setColor(this.ticksColor);
            XY xY = new XY();
            double d = (this.end - this.beg) / (double)this.ticks1;
            int n4 = 0;
            while (n4 < this.ticks1) {
                double d2;
                xY.y = d2 = this.beg + (double)n4 * d;
                point = graphXY.XY2Point(xY);
                if (n4 > 0) {
                    if (this.ticksNet) {
                        graphics.drawLine(0, point.y, n, point.y);
                    } else {
                        if (this.ticksBeg) {
                            graphics.drawLine(0, point.y, n3, point.y);
                        }
                        if (this.ticksEnd) {
                            graphics.drawLine(n, point.y, n - n3, point.y);
                        }
                        if (this.axes && this.ticksAxes && graphXY.xAxes.beg * graphXY.xAxes.end < 0.0) {
                            graphics.drawLine(point.x - n3, point.y, point.x, point.y);
                        }
                    }
                    String string = TypeConverter.double2String(d2, 2, false, false, false, true);
                    graphics.setFont(font2);
                    if (this.ticksBeg && this.ticksDigBeg) {
                        graphics.drawString(string, n3 / 3 + 2, point.y - 2);
                    }
                    if (this.ticksEnd && this.ticksDigEnd && (!graphXY.xAxes.arrow || graphXY.xAxes.arrowWidth == 0 || Math.abs(d2) > 1.0E-5)) {
                        graphics.drawString(string, n - graphics.getFontMetrics().stringWidth(string) - n3 / 3 - 2, point.y - 2);
                    }
                    if (this.axes && this.ticksAxes && this.ticksDigAxes && graphXY.xAxes.beg * graphXY.xAxes.end < 0.0 && (Math.abs(d2) > 1.0E-5 || this.beg * this.end >= 0.0)) {
                        graphics.drawString(string, point.x - graphics.getFontMetrics().stringWidth(string) - n3 / 3 - 2, point.y - 2);
                    }
                }
                if (this.ticks2 > 1) {
                    double d3 = d / (double)this.ticks2;
                    int n5 = 0;
                    while (n5 < this.ticks2) {
                        double d4;
                        xY.y = d4 = d2 + (double)n5 * d3;
                        point = graphXY.XY2Point(xY);
                        if (n5 > 0) {
                            if (this.ticksBeg) {
                                graphics.drawLine(0, point.y, 2 * n3 / 3, point.y);
                            }
                            if (this.ticksEnd) {
                                graphics.drawLine(n, point.y, n - 2 * n3 / 3, point.y);
                            }
                            if (this.axes && this.ticksAxes && graphXY.xAxes.beg * graphXY.xAxes.end < 0.0) {
                                graphics.drawLine(point.x - 2 * n3 / 3, point.y, point.x, point.y);
                            }
                        }
                        if (this.ticks3 > 1) {
                            double d5 = d3 / (double)this.ticks3;
                            int n6 = 0;
                            while (n6 < this.ticks3) {
                                double d6;
                                xY.y = d6 = d4 + (double)n6 * d5;
                                point = graphXY.XY2Point(xY);
                                if (n6 > 0) {
                                    if (this.ticksBeg) {
                                        graphics.drawLine(0, point.y, n3 / 3, point.y);
                                    }
                                    if (this.ticksEnd) {
                                        graphics.drawLine(n, point.y, n - n3 / 3, point.y);
                                    }
                                    if (this.axes && this.ticksAxes && graphXY.xAxes.beg * graphXY.xAxes.end < 0.0) {
                                        graphics.drawLine(point.x - n3 / 3, point.y, point.x, point.y);
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
        }
        graphics.setFont(font);
    }
}

