      SUBROUTINE MNDLHELP(XY)
      USE MSFLIB
      IMPLICIT NONE
C
C  Output a help page for MndlZoom (graphics text mode).
C
C  P. A. Seeger, May 29, 1996
C
      TYPE (xycoord) XY
      INTEGER ISTAT
C  
C     Display the 'help' screen, wait for keystroke
      ISTAT = FOCUSQQ(0)
      ISTAT = SETBKCOLORRGB(#A0A0A0)
      CALL CLEARSCREEN($GCLEARSCREEN)
      ISTAT = INITIALIZEFONTS()
      ISTAT = SETFONT('t''Times New Roman''h48pe')
      CALL MOVETO(190, 0, XY)
      ISTAT = SETCOLORRGB(#2000FF)
      CALL OUTGTEXT('MNDLZOOM')
      ISTAT = SETFONT('t''Times New Roman''h32pe')
      ISTAT = SETCOLORRGB(#FFFF00)
      CALL MOVETO(22, 50, XY)
      CALL OUTGTEXT('High-Resolution rendition of the Mandelbrot Set')
C
      ISTAT = SETFONT('t''Arial''h18pe')
      ISTAT = SETCOLOR(0)
      CALL MOVETO(60, 95, XY)
      CALL OUTGTEXT('Reference: H.-O. Peitgen and P. H. Richter, '//    &
     &              '"The Beauty of Fractals"')
      CALL MOVETO(140, 114, XY)
      CALL OUTGTEXT('(Springer-Verlag, New York, 1986)')
      CALL MOVETO(60, 144, XY)
      CALL OUTGTEXT('Program ()Copyright  P. A. Seeger  1988, '//      &
     &              '1989, 1991, 1992, 1994, 1996')
      CALL MOVETO(60, 165, XY)
      CALL OUTGTEXT('Win32 BETA version: June 12, 1996')
      CALL MOVETO(60, 186, XY)
      CALL OUTGTEXT('Comments and suggestions to:  PASeeger@aol.com')
C
      ISTAT = SETFONT('t''Arial''h16pe')
      CALL MOVETO(0, 216, XY)
      CALL OUTGTEXT('The Mandelbrot set: stability of iterations of  '//&
     &  'z := z + c')
      ISTAT = SETFONT('t''Arial''h16p')
      CALL MOVETO(0, 234, XY)
      CALL OUTGTEXT('Computes and displays a portion of the Mandelbro'//&
     &  't set in color, with high resolution and high numerical')
      CALL MOVETO(0, 252, XY)
      CALL OUTGTEXT('precision.  Color 0 (black) is used for values o'//&
     &  'f the complex number c for which z := z + c does not diverge')
      CALL MOVETO(0, 270, XY)
      CALL OUTGTEXT('within some maximum number of iterations startin'//&
     &  'g from z = 0 + 0 i.  For values of c which do lead to diver-')
      CALL MOVETO(0, 288, XY)
      CALL OUTGTEXT('gence, colors 1234 (or 114) are assigned by va'//&
     &  'rious algorithms.')
C
      ISTAT = SETFONT('t''Arial''h16pe')
      CALL MOVETO(0, 316, XY)
      CALL OUTGTEXT('The "State" Menu.  ')
      ISTAT = SETFONT('t''Arial''h16p')
      CALL OUTGTEXT('To stop the computation of a picture and draw a '//&
     &  'zoom box, use the State Menu or the')
      CALL MOVETO(0, 334, XY)
      CALL OUTGTEXT('Left mouse button.  Dragging or clicking the Lef'//&
     &  't button will position the box and the Right button will res'//&
     &  'ize')
      CALL MOVETO(0, 352, XY)
      CALL OUTGTEXT('it.  The State Menu is used to set rotation of t'//&
     &  'he color palette, and to return to the dialog box for a new '//&
     &  'case.')
C
      ISTAT = SETFONT('t''Arial''h16pe')
      CALL MOVETO(0, 380, XY)
      CALL OUTGTEXT('The Dialog Box.  ')
      ISTAT = SETFONT('t''Arial''h16p')
      CALL OUTGTEXT('Enter the directory for saving output files.  Ch'//&
     &  'oose resolution from 640x480 to 1280x1024,')
      CALL MOVETO(0, 398, XY)
      CALL OUTGTEXT('and 16 or 236 colors.  Parameters of the zoom wi'//&
     &  'ndow may be modified.  Color algorithms are: computed')
      CALL MOVETO(0, 416, XY)
      CALL OUTGTEXT('"Escape" time, integer number of iterations to r'//&
     &  'each 1000, or the azimuth of the last computed point.  Points')
      CALL MOVETO(0, 434, XY)
      CALL OUTGTEXT('closer than some limit to the boundary of the se'//&
     &  't may be colored white to demonstrate connectedness.')
C
      ISTAT = SETFONT('t''Arial''h16pe')
      CALL MOVETO(220, 462, XY)
      CALL OUTGTEXT('STRIKE ANY KEY TO CONTINUE')
      ISTAT = INCHARQQ()
C
      RETURN
      END

