/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.net.URL;
import java.util.Vector;
import tools.BaseApplet;
import tools.ImageFilterBright;
import tools.ImageFilterContour;
import tools.PngImageProducer;

public final class ImageFamily {
    private Image source;
    private Image bright;
    private Image contour;
    BaseApplet a;
    MediaTracker mt;
    Color back = Color.lightGray;
    private static final int len = 30;
    private static Vector urls = new Vector(30);
    private static Vector imgs = new Vector(30);

    public ImageFamily(String string, BaseApplet baseApplet) {
        if (baseApplet == null || string == null || string.trim().length() == 0) {
            return;
        }
        URL uRL = baseApplet._makeURL(string);
        if (uRL == null) {
            return;
        }
        this.a = baseApplet;
        if (string.toLowerCase().endsWith(".png")) {
            try {
                this.source = ImageFamily.getImageFromCacheOrCreate(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        } else {
            this.source = baseApplet.getImage(uRL);
        }
        if (this.source != null) {
            this.mt = new MediaTracker(baseApplet);
            this.mt.addImage(this.source, 0);
        }
    }

    public boolean isLoaded() {
        return this.mt == null || this.mt.checkID(0, true);
    }

    public void setBack(Color color) {
        if (color == null || color == this.back) {
            return;
        }
        this.back = color;
        this.contour = null;
    }

    public Image getSource() {
        return this.source;
    }

    public Image getBright() {
        if (this.bright != null) {
            return this.bright;
        }
        if (this.source == null) {
            return null;
        }
        this.bright = this.a.createImage(new FilteredImageSource(this.source.getSource(), new ImageFilterBright()));
        return this.bright;
    }

    public Image getContour() {
        if (this.contour != null) {
            return this.contour;
        }
        if (this.source == null) {
            return null;
        }
        this.contour = this.a.createImage(new FilteredImageSource(this.source.getSource(), new ImageFilterContour(this.back)));
        return this.contour;
    }

    private static synchronized Image getImageFromCacheOrCreate(URL uRL) {
        Image image;
        int n = urls.lastIndexOf(uRL);
        if (n == -1) {
            image = Toolkit.getDefaultToolkit().createImage(new PngImageProducer(uRL));
            if (imgs.size() == 30) {
                urls.removeElementAt(0);
                imgs.removeElementAt(0);
            }
        } else {
            image = (Image)imgs.elementAt(n);
            urls.removeElementAt(n);
            imgs.removeElementAt(n);
        }
        urls.addElement(uRL);
        imgs.addElement(image);
        return image;
    }

    public static void touch(String string) {
        URL uRL = BaseApplet.makeURL(string);
        if (uRL == null) {
            return;
        }
        if (string.toLowerCase().endsWith(".png")) {
            ImageFamily.getImageFromCacheOrCreate(uRL).getSource().startProduction(null);
        }
    }
}

