/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.System.Packet.MediacontrolPacket;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10addressPacket;
import X10Gimli.System.Packet.X10functionPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueX10;
import X10Gimli.X10.X10Data;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class MR26AGateway
extends InputOutputGateway
implements SerialPortEventListener {
    private SerialPort port;
    private InputStream inputStream;
    private int byte1 = 0;
    private int byte2 = 0;
    private int lastbyte1 = 0;
    private int lastbyte2 = 0;
    private long lastinput;
    private int delay = 750;
    private int state = 0;
    private int repeat = 0;
    private boolean moreDebug = false;

    public MR26AGateway() {
        this.sSource = "MR26A";
    }

    public boolean initialize(Value portname) {
        if (portname instanceof ValueString) {
            String port = ((ValueString)portname).getString();
            try {
                if (CommPortIdentifier.getPortIdentifier((String)port) == null) {
                    Debug.log(1, "\"Unable to access port for MR26A.\"");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NoSuchPortException e) {
                Debug.log(1, "\"Portname not found to start MR26A.\"");
                boolean bl = false;
                return bl;
            }
            this.initPort(port);
            this.lastinput = System.currentTimeMillis();
            Debug.log(1, "\"Successfully activated MR26A.\"");
            return true;
        }
        Debug.log(1, "\"String portname required to activate MR26A.\"");
        return false;
    }

    protected void sendPacket(Packet packet) {
        if (packet.getType() == "MR26A" && packet.getValue("DEBUG") != null) {
            this.moreDebug = packet.getValue("DEBUG").getBoolean();
        }
    }

    private void initPort(String portName) {
        try {
            this.port = (SerialPort)CommPortIdentifier.getPortIdentifier((String)portName).open("MR26AGateway", 2000);
            this.port.setSerialPortParams(9600, 8, 1, 0);
            this.inputStream = this.port.getInputStream();
            this.port.addEventListener((SerialPortEventListener)this);
            this.port.notifyOnDataAvailable(true);
        }
        catch (NoSuchPortException noSuchPortException) {
        }
        catch (PortInUseException portInUseException) {
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
        }
        catch (IOException iOException) {
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        this.nextByte();
                    }
                    break;
                }
                catch (Exception e) {
                    Debug.printCallStack("Exception reading input stream.", e);
                }
            }
        }
    }

    private void nextByte() {
        char c = '\u0000';
        try {
            c = (char)this.inputStream.read();
            if (this.moreDebug) {
                Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("MR26A: Read [").append(Debug.hexByte((byte)c)).append("]."))));
            }
        }
        catch (Exception e) {
            Debug.printCallStack("Exception reading input stream.", e);
        }
        switch (this.state) {
            case 0: {
                if (c == '\u00d5') {
                    this.state = 1;
                    break;
                }
                this.state = 0;
                break;
            }
            case 1: {
                if (c == '\u00aa') {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                this.byte1 = c;
                this.state = 3;
                break;
            }
            case 3: {
                this.byte2 = c;
                this.state = 4;
                break;
            }
            case 4: {
                this.state = c == '\u00ad' ? 5 : 0;
                this.checkInput();
            }
        }
    }

    private void checkInput() {
        if (this.state == 5) {
            long current = System.currentTimeMillis();
            if (this.byte1 == this.lastbyte1 && this.byte2 == this.lastbyte2) {
                ++this.repeat;
            } else {
                if (this.moreDebug) {
                    Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("MR26A: New input after ").append(this.repeat).append(" repeats."))));
                }
                this.repeat = 1;
            }
            if (this.repeat == 1 || current > this.lastinput) {
                this.lastbyte1 = this.byte1;
                this.lastbyte2 = this.byte2;
                this.lastinput = System.currentTimeMillis() + (long)this.delay;
                int input = this.byte1 << 8 | this.byte2;
                if ((input & 0xA00) == 0) {
                    int hbyte = ((input & 0x8000) != 0 ? 1 : 0) | ((input & 0x4000) != 0 ? 2 : 0) | ((input & 0x2000) != 0 ? 4 : 0) | ((input & 0x1000) != 0 ? 8 : 0);
                    boolean flagfunc = (input & 0x80) != 0;
                    char housecode = X10Data.byteToHouseCode((byte)hbyte);
                    if (this.moreDebug) {
                        Debug.log(2, "MR26A: X10 input decoded.");
                    }
                    if (flagfunc) {
                        int fbyte;
                        int function = fbyte = ((input & 8) != 0 ? 1 : 0) | ((input & 0x10) != 0 ? 2 : 0);
                        switch (function) {
                            case 0: {
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("ALLUNITSOFF"), null));
                                break;
                            }
                            case 1: {
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("BRIGHT"), new ValueNumber(5)));
                                break;
                            }
                            case 2: {
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("ALLLIGHTSON"), null));
                                break;
                            }
                            case 3: {
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("DIM"), new ValueNumber(5)));
                            }
                        }
                    } else {
                        int dbyte = ((input & 0x10) != 0 ? 1 : 0) | ((input & 8) != 0 ? 2 : 0) | ((input & 0x40) != 0 ? 4 : 0) | ((input & 0x400) != 0 ? 8 : 0);
                        boolean flagoff = (input & 0x20) != 0;
                        int devicecode = dbyte + 1;
                        int function = flagoff ? 3 : 2;
                        switch (function) {
                            case 2: {
                                this.inputReceived(new X10addressPacket(new ValueX10(housecode, devicecode)));
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("ON"), null));
                                break;
                            }
                            case 3: {
                                this.inputReceived(new X10addressPacket(new ValueX10(housecode, devicecode)));
                                this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand("OFF"), null));
                            }
                        }
                    }
                } else if ((input & 0xE00) == 3584 && (input & 0xF000) == 57344) {
                    if (this.moreDebug) {
                        Debug.log(2, "MR26A: Multifunction remote input decoded.");
                    }
                    switch (input & 0xFF) {
                        case 130: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(1), null));
                            break;
                        }
                        case 66: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(2), null));
                            break;
                        }
                        case 194: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(3), null));
                            break;
                        }
                        case 34: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(4), null));
                            break;
                        }
                        case 162: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(5), null));
                            break;
                        }
                        case 98: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(6), null));
                            break;
                        }
                        case 226: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(7), null));
                            break;
                        }
                        case 18: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(8), null));
                            break;
                        }
                        case 146: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(9), null));
                            break;
                        }
                        case 2: {
                            this.inputReceived(new MediacontrolPacket(new ValueNumber(0), null));
                            break;
                        }
                        case 186: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("AB"), null));
                            break;
                        }
                        case 82: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("ENTER"), null));
                            break;
                        }
                        case 58: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("DISPLAY"), null));
                            break;
                        }
                        case 212: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("SUBTITLE"), null));
                            break;
                        }
                        case 214: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("TITLE"), null));
                            break;
                        }
                        case 216: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("RETURN"), null));
                            break;
                        }
                        case 201: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("EXIT"), null));
                            break;
                        }
                        case 240: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("POWER"), null));
                            break;
                        }
                        case 242: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("RECALL"), null));
                            break;
                        }
                        case 64: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("SKIPUP"), null));
                            break;
                        }
                        case 192: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("SKIPDOWN"), null));
                            break;
                        }
                        case 96: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("VOLUP"), new ValueNumber(5)));
                            break;
                        }
                        case 224: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("VOLDOWN"), new ValueNumber(5)));
                            break;
                        }
                        case 160: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("MUTE"), null));
                            break;
                        }
                        case 176: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("PLAY"), null));
                            break;
                        }
                        case 112: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("STOP"), null));
                            break;
                        }
                        case 114: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("PAUSE"), null));
                            break;
                        }
                        case 56: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("RW"), null));
                            break;
                        }
                        case 184: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("FF"), null));
                            break;
                        }
                        case 255: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("RECORD"), null));
                            break;
                        }
                        case 209: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("RIGHT"), null));
                            break;
                        }
                        case 210: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("LEFT"), null));
                            break;
                        }
                        case 211: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("DOWN"), null));
                            break;
                        }
                        case 213: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("UP"), null));
                            break;
                        }
                        case 182: {
                            this.inputReceived(new MediacontrolPacket(new ValueString("MENU"), null));
                        }
                    }
                }
            }
            try {
                while (this.inputStream.available() > 0) {
                    this.inputStream.read();
                }
            }
            catch (Exception e) {
                Debug.printCallStack("Exception flushing input.", e);
            }
            this.state = 0;
        }
    }
}

