/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceConsumer;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceListener;
import org.webmacro.broker.ResourceMap;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.util.InvalidArgumentException;
import org.webmacro.util.ThreadScheduler;

public final class ResourceManager
implements ResourceMap {
    private static final int _REVOKED_WORKER;
    private static final int _BACKGROUND_WORKER;
    private static final int _NORMAL_WORKER;
    private static final int _CRITICAL_WORKER;
    private static final long _REAPER_LONG_SLEEP = 1800000L;
    private boolean _shutdown = false;
    private final String _type;
    private int _expireTime = 0;
    int _threadPool = 0;
    private Thread _reaper;
    private final ResourceBroker _broker;
    private final Vector _consumers = new Vector();
    private final Vector _providers = new Vector();
    private final Hashtable _resources = new Hashtable();
    private final Hashtable _workers = new Hashtable();

    public final String toString() {
        return "ResourceManager(" + this._type + "," + this._expireTime + ")";
    }

    final void addListener(ResourceListener resourceListener) {
        if (resourceListener instanceof ResourceProvider) {
            ResourceProvider resourceProvider = (ResourceProvider)resourceListener;
            this.addListener(this._providers, resourceProvider);
            if (this._expireTime < resourceProvider.resourceExpireTime()) {
                this.setExpireTime(resourceProvider.resourceExpireTime());
            }
        }
        if (resourceListener instanceof ResourceConsumer) {
            this.addListener(this._consumers, resourceListener);
        }
    }

    public final long getExpireTime() {
        return this._expireTime;
    }

    public final void setExpireTime(int n) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            this._expireTime = n;
            this._resources.notify();
        }
    }

    final void removeListener(ResourceListener resourceListener) {
        if (resourceListener instanceof ResourceProvider) {
            this.removeListener(this._providers, resourceListener);
        }
        if (resourceListener instanceof ResourceListener) {
            this.removeListener(this._consumers, resourceListener);
        }
    }

    public final ResourceEvent get(String string) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, null, 0, true);
    }

    public final void remove(String string) throws InvalidArgumentException, ResourceUnavailableException {
        this.locate(string, null, 2, true);
    }

    public final ResourceEvent put(String string, Object object) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, object, 1, true);
    }

    final boolean isProvider() {
        return !this._providers.isEmpty();
    }

    final boolean isConsumer() {
        return !this._consumers.isEmpty();
    }

    final void announce(ResourceEvent resourceEvent) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            if (this._expireTime >= 0) {
                this._resources.put(resourceEvent.getName(), resourceEvent);
                this._resources.notify();
            }
        }
        this.notifyConsumers(resourceEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void notifyConsumers(ResourceEvent resourceEvent) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            if (this._shutdown) {
                return;
            }
        }
        int n = this._consumers.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                if (!resourceEvent.isAvailable()) {
                    return;
                }
                ((ResourceConsumer)this._consumers.elementAt(n2)).resourceAvailable(resourceEvent);
                ++n2;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
    }

    final ResourceEvent locate(String string, Object object, int n, boolean bl) throws InvalidArgumentException, ResourceUnavailableException {
        ResourceEvent resourceEvent;
        Object object2 = this._resources;
        synchronized (object2) {
            if (this._shutdown) {
                throw new InvalidArgumentException("Request follows shutdown");
            }
            ResourceEvent resourceEvent2 = (ResourceEvent)this._resources.get(string);
            if (resourceEvent2 == null) {
                switch (n) {
                    case 0: {
                        resourceEvent = new RequestResourceEvent(this._broker, this._type, string);
                        break;
                    }
                    case 1: {
                        resourceEvent = new CreateResourceEvent(this._broker, this._type, string, object);
                        break;
                    }
                    case 2: {
                        resourceEvent = new RequestResourceEvent(this._broker, this._type, string);
                        resourceEvent.deleted = true;
                        break;
                    }
                    default: {
                        throw new InvalidArgumentException("Unsupported method!");
                    }
                }
                if (this._expireTime != 0) {
                    this._resources.put(string, resourceEvent);
                    this._resources.notify();
                }
            } else {
                resourceEvent = resourceEvent2;
                switch (n) {
                    case 0: {
                        ResourceEvent resourceEvent3 = resourceEvent;
                        Object var7_9 = null;
                        return resourceEvent3;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("Resource exists.");
                    }
                    case 2: {
                        resourceEvent.deleted = true;
                        break;
                    }
                    default: {
                        throw new InvalidArgumentException("Unsupported method!");
                    }
                }
            }
        }
        if (bl && this._threadPool > 0) {
            ResourceManager resourceManager = this;
            if (resourceManager == null) {
                throw null;
            }
            object2 = new Thread(resourceManager, resourceEvent){
                private final /* synthetic */ ResourceManager this$0;
                private final /* synthetic */ ResourceEvent val$evt;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    try {
                        try {
                            this.this$0.access$4().put(this.val$evt, this);
                            this.setName("worker:" + this.val$evt);
                            this.setPriority(ResourceManager.access$5());
                            Thread.yield();
                            this.this$0.access$6(this.val$evt, true);
                            Object var2_1 = null;
                            this.this$0.access$4().remove(this.val$evt);
                            return;
                        }
                        catch (Exception exception) {
                            ResourceBroker.log_.exception(exception);
                            Object var2_2 = null;
                            this.this$0.access$4().remove(this.val$evt);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.this$0.access$4().remove(this.val$evt);
                        throw throwable;
                    }
                }
                {
                    this.val$evt = resourceEvent;
                    this.this$0 = resourceManager;
                    this.constructor$0(resourceManager);
                }

                public void constructor$0(ResourceManager resourceManager) {
                }
            };
            ((Thread)object2).start();
        } else {
            this.resolve(resourceEvent, false);
        }
        return resourceEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void resolve(ResourceEvent resourceEvent, boolean bl) {
        int n = this._providers.size();
        try {
            int n2 = 0;
            while (n2 < n && resourceEvent.isSettable()) {
                resourceEvent.providerSet((ResourceProvider)this._providers.elementAt(n2));
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        catch (Exception exception) {
            ResourceBroker.log_.exception(exception);
            ResourceBroker.log_.warning("Provider " + this._type + " threw an exception");
        }
        if (!resourceEvent.deleted && resourceEvent.isAvailable()) {
            if (bl) {
                Thread.currentThread().setPriority(_NORMAL_WORKER);
                Thread.yield();
            }
            this.notifyConsumers(resourceEvent);
            return;
        }
        if (resourceEvent.deleted || resourceEvent.isSettable()) {
            this.revoke(resourceEvent, "Unable to resolve requested resource");
            return;
        }
        if (resourceEvent.isRevoked()) {
            return;
        }
        ResourceBroker.log_.warning(this + " reached an unexpected state resolving " + resourceEvent);
    }

    final void revoke(ResourceEvent resourceEvent, String string) {
        Object object;
        Serializable serializable = resourceEvent;
        synchronized (serializable) {
            if (resourceEvent.isRevoked()) {
                Object var4_4 = null;
                return;
            }
            this.commit(resourceEvent);
            resourceEvent.revoke(string);
            object = (Thread)this._workers.remove(resourceEvent);
            if (object != null && object != Thread.currentThread()) {
                ((Thread)object).setPriority(_REVOKED_WORKER);
                ((Thread)object).interrupt();
            }
        }
        serializable = this._resources;
        synchronized (serializable) {
            object = (ResourceEvent)this._resources.remove(resourceEvent.getName());
            if (object != null && !((ResourceEvent)object).isRevoked()) {
                this._resources.put(((ResourceEvent)object).getName(), object);
                this._resources.notify();
            }
        }
    }

    final void blocked(ResourceEvent resourceEvent) throws ResourceUnavailableException {
        Thread thread;
        Thread thread2 = (Thread)this._workers.get(resourceEvent);
        if (thread2 == (thread = Thread.currentThread())) {
            ResourceBroker.log_.warning("Attempt to block self for: " + resourceEvent);
            throw new ResourceUnavailableException("Attempt to block self!");
        }
        if (thread2 != null) {
            int n = thread.getPriority();
            if (thread2.getPriority() < n) {
                thread2.setPriority(n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void commit(ResourceEvent resourceEvent) {
        int n = this._providers.size();
        boolean bl = false;
        if (resourceEvent.isAvailable() || resourceEvent.deleted) {
            try {
                int n2 = 0;
                while (n2 < n && !bl) {
                    ResourceProvider resourceProvider = (ResourceProvider)this._providers.elementAt(n2);
                    bl = resourceEvent.deleted ? resourceProvider.resourceDelete(resourceEvent) : resourceProvider.resourceSave(resourceEvent);
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            if (!bl) {
                ResourceBroker.log_.warning("Resource unsaved: " + resourceEvent);
            }
        }
    }

    final void shutdownResources() {
        Object object = this._resources;
        synchronized (object) {
            this._shutdown = true;
        }
        this._reaper.interrupt();
        object = this._resources.elements();
        while (object.hasMoreElements()) {
            ResourceEvent resourceEvent = (ResourceEvent)object.nextElement();
            this.revoke(resourceEvent, "shutting down");
        }
    }

    final void shutdownListeners(Hashtable hashtable) {
        this.destroy(this._consumers, hashtable);
        this.destroy(this._providers, hashtable);
    }

    private final void destroy(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResourceListener resourceListener = (ResourceListener)enumeration.nextElement();
            if (hashtable.get(resourceListener) != null) continue;
            hashtable.put(resourceListener, resourceListener);
            resourceListener.destroy();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean reap() throws InterruptedException {
        boolean bl = false;
        try {
            Enumeration enumeration = this._resources.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return bl;
                }
                ResourceEvent resourceEvent = (ResourceEvent)enumeration.nextElement();
                if (!resourceEvent.isSettable()) {
                    if (resourceEvent.accessed) {
                        resourceEvent.accessed = false;
                    } else {
                        Object var5_5;
                        try {
                            this._reaper.setPriority(_CRITICAL_WORKER);
                            this.revoke(resourceEvent, "Expired from cache");
                            var5_5 = null;
                            this._reaper.setPriority(_NORMAL_WORKER);
                        }
                        catch (Throwable throwable) {
                            var5_5 = null;
                            this._reaper.setPriority(_NORMAL_WORKER);
                            throw throwable;
                        }
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            ResourceBroker.log_.exception(exception);
            ResourceBroker.log_.warning("Reaper caught exception in " + this + " (continuing anyway)");
        }
        return bl;
    }

    private final void addListener(Vector vector, ResourceListener resourceListener) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            if (this._shutdown) {
                Object var4_4 = null;
                return;
            }
            if (!vector.contains(resourceListener)) {
                vector.addElement(resourceListener);
            }
        }
    }

    private final void removeListener(Vector vector, ResourceListener resourceListener) {
        Hashtable hashtable = this._resources;
        synchronized (hashtable) {
            while (vector.removeElement(resourceListener)) {
            }
        }
    }

    /* synthetic */ int access$0() {
        return this._expireTime;
    }

    /* synthetic */ boolean access$1() throws InterruptedException {
        return this.reap();
    }

    /* synthetic */ Hashtable access$2() {
        return this._resources;
    }

    static /* synthetic */ long access$3() {
        return _REAPER_LONG_SLEEP;
    }

    /* synthetic */ Hashtable access$4() {
        return this._workers;
    }

    static /* synthetic */ int access$5() {
        return _BACKGROUND_WORKER;
    }

    /* synthetic */ void access$6(ResourceEvent resourceEvent, boolean bl) {
        this.resolve(resourceEvent, bl);
    }

    ResourceManager(ResourceBroker resourceBroker, String string) {
        this._broker = resourceBroker;
        this._type = string.intern();
        ResourceManager resourceManager = this;
        if (resourceManager == null) {
            throw null;
        }
        this._reaper = new Thread(resourceManager, string){
            private final /* synthetic */ ResourceManager this$0;
            private final /* synthetic */ String val$type;

            /*
             * Exception decompiling
             */
            public final void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
            {
                this.val$type = string;
                this.this$0 = resourceManager;
                this.constructor$0(resourceManager);
            }

            public void constructor$0(ResourceManager resourceManager) {
            }
        };
        this._reaper.setName("reaper:" + string);
        this._reaper.setDaemon(true);
        this._reaper.setPriority(_NORMAL_WORKER);
        this._reaper.start();
    }

    static {
        int n = Thread.currentThread().getPriority();
        _REVOKED_WORKER = n - 2;
        _BACKGROUND_WORKER = n - 1;
        _NORMAL_WORKER = n;
        _CRITICAL_WORKER = n + 1;
        ThreadScheduler.start(1000L);
    }
}

