/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.Base64Encoder;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class HttpMessage {
    URL servlet = null;
    Hashtable headers = null;

    public HttpMessage(URL uRL) {
        this.servlet = uRL;
    }

    public InputStream sendGetMessage() throws IOException {
        return this.sendGetMessage(null);
    }

    public InputStream sendGetMessage(Properties properties) throws IOException {
        String string = "";
        if (properties != null) {
            string = "?" + this.toEncodedString(properties);
        }
        URL uRL = new URL(this.servlet.toExternalForm() + string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        this.sendHeaders(uRLConnection);
        return uRLConnection.getInputStream();
    }

    public InputStream sendPostMessage() throws IOException {
        return this.sendPostMessage(null);
    }

    public InputStream sendPostMessage(Properties properties) throws IOException {
        String string = "";
        if (properties != null) {
            string = this.toEncodedString(properties);
        }
        URLConnection uRLConnection = this.servlet.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.sendHeaders(uRLConnection);
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        dataOutputStream.writeBytes(string);
        dataOutputStream.flush();
        dataOutputStream.close();
        return uRLConnection.getInputStream();
    }

    public InputStream sendPostMessage(Serializable serializable) throws IOException {
        URLConnection uRLConnection = this.servlet.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        this.sendHeaders(uRLConnection);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        return uRLConnection.getInputStream();
    }

    public void setHeader(String string, String string2) {
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(string, string2);
    }

    private void sendHeaders(URLConnection uRLConnection) {
        if (this.headers != null) {
            Enumeration enumeration = this.headers.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.headers.get(string);
                uRLConnection.setRequestProperty(string, string2);
            }
        }
    }

    public void setCookie(String string, String string2) {
        String string3;
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        if ((string3 = (String)this.headers.get("Cookie")) == null) {
            this.setHeader("Cookie", string + "=" + string2);
        } else {
            this.setHeader("Cookie", string3 + "; " + string + "=" + string2);
        }
    }

    public void setAuthorization(String string, String string2) {
        String string3 = Base64Encoder.encode(string + ":" + string2);
        this.setHeader("Authorization", "Basic " + string3);
    }

    private String toEncodedString(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            stringBuffer.append(URLEncoder.encode(string) + "=" + URLEncoder.encode(string2));
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }
}

