package tester;

/**
 * @(#)StartEngine.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

/**
 * StartEngine is the main entry point of the application that
 * loads and starts the test engine.
 *
 * @author Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://www30.brinkster.com/panos69/JProjects.aspx
 */
public class StartEngine {
    public static void main(String[]args) {
        String icon = "tester" + File.separator + "neb2.jpg";
        new SplashScreen(icon, 6000);
		TestLoader load = new TestLoader();
		final File f = new File(load.path + File.separator + "grade.html");
        final ExamFrame exam = new ExamFrame("Java 2 Certification Test Engine v 2.0  " +
                "by P.Plevrakis   @2002", load);
        exam.setLocation(1, 1);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        exam.setSize(Math.min(dim.width - 5, 800), Math.min(dim.height - 40, 600));
        exam.setResizable(false);
        exam.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent evt) {
					if (f.exists()) f.delete();
                    exam.setVisible(false);
                    exam.dispose();
                    System.exit(0);
                }
            }
        );
        exam.show();
    }
} // end class

