package tester;

/**
 * SplashScreen
 * ---------------------------------------------------------------------------
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * SplashScreen.
 * This class creates the splash screen used by the StartEngine
 *
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class SplashScreen extends JWindow {

    public SplashScreen(String filename, Frame f, int waitTime) {
        super(f);
        JLabel l = new JLabel(new ImageIcon(filename));

        getContentPane().add(l, BorderLayout.CENTER);
        pack();
        Dimension screenSize =
            Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();

        setLocation(screenSize.width / 2 - (labelSize.width / 2),
            screenSize.height / 2 - (labelSize.height / 2));
        addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent e) {
                    setVisible(false);
                    dispose();
                }
            }
        );
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable() {
                public void run() {
                    setVisible(false);
                    dispose();
                }
            };
        Runnable waitRunner = new Runnable() {
                public void run() {
                    try {
                        Thread.sleep(pause);
                        SwingUtilities.invokeAndWait(closerRunner);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };

        setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");

        splashThread.start();
    }
}
