package cern.lhcias.csgui.interfaces;

/**
 A tagHistory object stores the history of a tag.
 The value taken by the tag and the date for each of
 these values are stored together with a validity flag.
 This flag tells if the value,at that date, was considered 
 valid or not.
*/
public interface tagHistory {
    /** 
    reset depth to 0 
    */
    public void initHistory();                       
    /** 
    returns the maximum depth in history 
    */
	int			getMaximumDepth();                   
	/**
	gets the current depth
	*/
	int			getHistoryDepth();                   
    /**
    gets the stored values as doubles
    */
	double[]	getDoubleValues();                   
    /**
    gets the stored values as intergers
    */
	int[]	    getIntValues();                      
	long[]		getDates();                          
	boolean[]   getValidities();
	public String toString();
	public void insertValue(double val);
	public void insertValue(int val);
	public void insertValue(int val, long date);
	public void insertValue(double val, long date);
	public void insertInvalidValue();
	public void insertInvalidValue(long date);
}

