package cern.lhcias.csgui.interfaces;

import java.util.*;
import cern.lhcias.csgui.WinMgr.*;

/** 
*    This interface describes a driver used to access the value of the Tags.
*<br>    The case when the way to send the tags' values is different than the one to read
*<br>    the values has been taken into account (setReadHost and setWriteHost,...).
*<br>    
*<br>    If the driver works in a pooling way (or if it has been set to pooling via setType
*<br>    for example, then a call to enable() will launch the pooling mechanism
*<br>    (if pooling_interval is set to a value different from -1).
*<br>    In that case, the driver must know about the TagArrays where to send the data.
*<br>
*<br>	DataServer may be used without TagArrays: the following methods can be used without 
*<br>	setting TagArrays:
*<br>	    public void		write(String name, String stringValue);
*<br>	    public String	read(String name);
*<br>	    
*<br>	Each instance of the driver is named using a "Process Name". So the user may indicates
*<br>	to which process corresponds a Tag.
*<br>	
*<br>	The config which is returned by toString and that can be sent to setConfig has the
*<br>	following format:
*<br>	    ProcessName;Protocol;Type;ReadHost;ReadPort;WriteHost;WritePort;PoolFrequency;subscriptionMode[;param1=val1[;...]]
*<br>	ex: String;Socket;OnChange;myHost;3000;;;-1;true
*/
public interface DataServer {
    public void     setReadHost(String host);                 // host name or URL used to fetch Tags' value
    public String   getReadHost();
    public void     setReadPort(int communicationReadPort);   // port number
    public int      getReadPort();
    public void     setWriteHost(String host);                // host name or URL used to send Tags' value
    public String   getWriteHost();
    public void     setWritePort(int communicationWritePort); // port number
    public int      getWritePort();
    public void     setPoolingInterval(long poolingInterval); // for pooling, if necessary
                                                              // if pooling_interval == -1 or hasn't been set, then no pooling
    public long     getPoolingInterval();
    public void     setType(String communication_type);       // ex: pooling, onChange, ...
	public String	getType();
    public void     setMask(boolean mask);
    public boolean  getMask();
    public void     setUser(String user);
    public void     setPassword(String password);
    public String   getUser();
    public String   getPassword();
	public void     setTagArrays(TagArrays tc);
    public void     setParameter(String parameter, String value); // ex: ("tagsNamesinURL","true")
    public String   getParameter(String parameter);
    public void     setTagsSubscription(boolean subMode);
    public boolean  getTagsSubscription();
    public void     setProcessName(String processName);
    public String   getProcessName();

    public void     setConfig(String config);
    public String   toString();

	public void		enable();		    
	public void		disable();
	public boolean  isActive();
	public void		write(String name, String stringValue);
	public String	read(String name);
	public boolean	read(Vector names);                       // values are sent to TagArrays
	public void		closeConnection();
    public String   getDriverProtocol();
    Vector          getPossibleProtocols();
	boolean         doYouImplement(String protocol);
	// public void     setCentralManager(CentralManager gstatus);
    public void     addAlarmListener(AlarmListener listener);
    public void     removeAlarmListener(AlarmListener listener);
}
