/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Component;
import java.awt.Frame;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.chart.ChartDataView;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.customizer.AxisOrientPage;
import jclass.chart.customizer.JCOptionEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;

public class ViewAxisPage
extends JCPropertyPage
implements JCItemListener {
    JCOptionEditor viewCombo;
    JCLabel viewLabel;
    JCCheckboxGroup xyGroup;
    JCCheckbox xCheck;
    JCCheckbox yCheck;
    JCAxis target;

    public void init() {
        this.setLayout(new JCAlignerLayout(2, 3, 3));
        this.viewLabel = new JCLabel("");
        this.viewLabel.setLabel(AxisOrientPage.getEnabledOrientationImage((Component)this, 0));
        this.add(this.viewLabel);
        this.xyGroup = new JCCheckboxGroup("");
        this.xyGroup.setLayout(new JCGridLayout(2, 1));
        this.xCheck = new JCCheckbox((Object)"X Axis", 0, this.xyGroup);
        this.yCheck = new JCCheckbox((Object)"Y Axis", 0, this.xyGroup);
        this.add(this.xyGroup);
        this.add(new JCLabel("View:"));
        this.viewCombo = new JCOptionEditor();
        this.viewCombo.getTextField().setColumns(8);
        this.viewCombo.getTextField().setBackground(JCPropertyPage.textBG);
        this.viewCombo.addPropertyChangeListener(this);
        this.add(this.viewCombo);
    }

    private void setViewList(JCChart jCChart) {
        Object[] objectArray = jCChart.getDataView();
        if (objectArray != null) {
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                ChartDataView chartDataView = objectArray[n];
                stringArray[n] = new String(n + ": " + chartDataView.getName());
                ++n;
            }
            this.viewCombo.setItems(stringArray, objectArray);
        }
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.setViewList((JCChart)object);
            this.viewCombo.enable();
            this.xyGroup.enable();
            return;
        }
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            JCChart jCChart = this.target.getParent();
            if (jCChart == null) {
                return;
            }
            ChartDataView[] chartDataViewArray = jCChart.getDataView();
            if (chartDataViewArray == null) {
                return;
            }
            JCAxis jCAxis = this.target.getFormula().getOriginator();
            JCAxis jCAxis2 = jCAxis != null ? jCAxis : this.target;
            this.setViewList(jCChart);
            String[] stringArray = new String[chartDataViewArray.length];
            int n = -1;
            int n2 = 0;
            while (n2 < chartDataViewArray.length) {
                ChartDataView chartDataView = chartDataViewArray[n2];
                stringArray[n2] = new String(n2 + ": " + chartDataView.getName());
                if (jCAxis2 == chartDataView.getXAxis() || jCAxis2 == chartDataView.getYAxis()) {
                    n = n2;
                }
                ++n2;
            }
            if (n >= 0) {
                this.viewCombo.setValue(chartDataViewArray[n]);
                this.viewLabel.setLabel(AxisOrientPage.getEnabledOrientationImage((Component)this, chartDataViewArray[n]));
                if (jCAxis2 == chartDataViewArray[n].getXAxis()) {
                    this.xyGroup.setCurrent(this.xCheck);
                } else {
                    this.xyGroup.setCurrent(this.yCheck);
                }
                this.viewCombo.disable();
                this.xyGroup.disable();
            }
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null) {
            return;
        }
        if (object2 instanceof ChartDataView) {
            ChartDataView chartDataView = (ChartDataView)object2;
            this.viewLabel.setLabel(AxisOrientPage.getEnabledOrientationImage((Component)this, chartDataView));
            if (this.target == chartDataView.getXAxis()) {
                this.xyGroup.setCurrent(this.xCheck);
                return;
            }
            if (this.target == chartDataView.getYAxis()) {
                this.xyGroup.setCurrent(this.yCheck);
            }
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null || this.target == null) {
                return;
            }
            boolean bl = jCCheckbox.getState() != 0;
            this.setObject(this.target);
        }
    }

    public static void main(String[] stringArray) {
        String string = ViewAxisPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(ViewAxisPage.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public static String getPageTitle() {
        return "View Axis Property Page";
    }

    public static String getPageName() {
        return "ViewAxisPage";
    }
}

