/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Frame;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.chart.JCChartStyle;
import jclass.chart.JCSymbolStyle;
import jclass.chart.customizer.JCColorEditor;
import jclass.chart.customizer.JCEnumEditor;
import jclass.chart.customizer.JCIntegerEditor;
import jclass.chart.customizer.JCPropertyPage;

public class SymbolStylePage
extends JCPropertyPage {
    JCColorEditor pointColor;
    JCIntegerEditor pointWidth;
    JCEnumEditor symbolShape;
    JCChartStyle chartStyle;

    public void init() {
        super.init();
        this.setLayout(new JCAlignerLayout(2, 0, 3));
        this.add(new JCLabel("Color:"));
        this.pointColor = new JCColorEditor();
        this.pointColor.setBackground(JCPropertyPage.textBG);
        this.pointColor.addPropertyChangeListener(this);
        this.add(this.pointColor);
        this.add(new JCLabel("Size:"));
        this.pointWidth = new JCIntegerEditor();
        this.pointWidth.setBackground(JCPropertyPage.textBG);
        this.pointWidth.addPropertyChangeListener(this);
        this.add(this.pointWidth);
        this.add(new JCLabel("Shape:"));
        this.symbolShape = new JCEnumEditor(JCSymbolStyle.shape_strings, JCSymbolStyle.shape_values, "pointStyleEditor");
        this.symbolShape.getTextField().setColumns(10);
        this.symbolShape.getTextField().setBackground(JCPropertyPage.textBG);
        this.symbolShape.addPropertyChangeListener(this);
        this.add(this.symbolShape);
    }

    public void setObject(Object object) {
        if (object instanceof JCChartStyle) {
            this.chartStyle = (JCChartStyle)object;
            this.pointColor.setValue(this.chartStyle.getSymbolColor());
            this.pointWidth.setValue(new Integer(this.chartStyle.getSymbolSize()));
            this.symbolShape.setValue(new Integer(this.chartStyle.getSymbolShape()));
        }
    }

    public Object getObject() {
        return this.chartStyle;
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (object == this.pointColor) {
            if (this.chartStyle != null) {
                this.chartStyle.setSymbolColor((Color)object2);
                return;
            }
        } else if (object == this.pointWidth) {
            if (this.chartStyle != null) {
                this.chartStyle.setSymbolSize((Integer)object2);
                return;
            }
        } else if (object == this.symbolShape && this.chartStyle != null) {
            this.chartStyle.setSymbolShape((Integer)object2);
        }
    }

    public static void main(String[] stringArray) {
        String string = SymbolStylePage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(SymbolStylePage.getPageTitle());
    }

    public static String getPageTitle() {
        return "Chart Symbol Style Page";
    }

    public static String getPageName() {
        return "SymbolStylePage";
    }
}

