/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import jclass.chart.ChartDataView;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCStyle;
import jclass.util.JCUtilConverter;

public class JCFillStyle
extends JCStyle
implements HTMLHandler {
    Color color;
    int pattern = 1;
    int colorIndex;
    Image image;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int PER_25 = 2;
    public static final int PER_50 = 3;
    public static final int PER_75 = 4;
    public static final int HORIZ_STRIPE = 5;
    public static final int VERT_STRIPE = 6;
    public static final int STRIPE_45 = 7;
    public static final int STRIPE_135 = 8;
    public static final int DIAG_HATCHED = 9;
    public static final int CROSS_HATCHED = 10;
    public static final String[] fillPattern_strings = new String[]{"None", "Solid", "Per_25", "Per_50", "Per_75", "Horiz_Stripe", "Vert_Stripe", "Stripe_45", "Stripe_135", "Diag_Hatched", "Cross_Hatched"};
    public static final int[] fillPattern_values;

    public JCFillStyle(Color color, int n) {
        this.color = color;
        this.pattern = n;
    }

    public static JCFillStyle makeDefault(JCChart jCChart) {
        return JCFillStyle.makeDefault(jCChart, false);
    }

    public static JCFillStyle makeDefault(JCChart jCChart, boolean bl) {
        JCFillStyle jCFillStyle = new JCFillStyle(JCFillStyle.getDefaultColor(jCChart, bl), JCFillStyle.getDefaultPattern(jCChart));
        int n = 0;
        if (jCChart != null) {
            n = jCChart.getFillColorIndex();
            n = n == 0 ? JCStyle.defaultColors.length - 1 : --n;
        }
        jCFillStyle.colorIndex = n;
        return jCFillStyle;
    }

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.drawRect(n, n2, n3, n4);
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillRect(n, n2, n3, n4);
    }

    public void fillImageRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.image == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(n, n2, n3, n4);
        int n5 = this.image.getHeight(null);
        int n6 = this.image.getWidth(null);
        if (!bl2) {
            int n7 = n + (n3 - n6) / 2;
            if (bl) {
                int n8 = n2 + n4 - n5;
                while (n8 > n2) {
                    graphics2.drawImage(this.image, n7, n8, null);
                    n8 -= n5;
                }
                graphics2.drawImage(this.image, n7, n8, null);
            } else {
                int n9 = n2 + 1;
                while (n9 < n2 + n4) {
                    graphics2.drawImage(this.image, n7, n9, null);
                    n9 += n5;
                }
            }
        } else {
            int n10 = n2 + (n4 - n5) / 2;
            if (bl) {
                int n11 = n + 1;
                while (n11 < n + n3) {
                    graphics2.drawImage(this.image, n11, n10, null);
                    n11 += n6;
                }
            } else {
                int n12 = n + n3 - n6;
                while (n12 > n) {
                    graphics2.drawImage(this.image, n12, n10, null);
                    n12 -= n6;
                }
                graphics2.drawImage(this.image, n12, n10, null);
            }
        }
        graphics2.dispose();
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillOutlineRect(graphics, n, n2, n3, n4, null);
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        this.fillRect(graphics, n, n2, n3, n4);
        this.drawOutlineRect(graphics, n, n2, n3, n4, color);
    }

    public void drawOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawRect(n, n2, n3, n4);
    }

    public void fillPolygon(Graphics graphics, Polygon polygon) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygon(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.drawPolygon(polygon);
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n, int n2, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        int n3 = n;
        while (n3 < n2) {
            graphics.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
            ++n3;
        }
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygon(graphics, polygon);
        graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        int n = 0;
        while (n < polygon.npoints - 1) {
            graphics.drawLine(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n + 1], polygon.ypoints[n + 1]);
            ++n;
        }
    }

    public void fillPolygonShadow(Graphics graphics, Polygon polygon) {
        Color color = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillPolygonHighlight(Graphics graphics, Polygon polygon) {
        Color color = JCChartUtil.brighter(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillPolygon(polygon);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonShadow(graphics, polygon, null);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color) {
        Color color2 = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonHighlight(graphics, polygon, null);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color) {
        Color color2 = JCChartUtil.brighter(this.color);
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        graphics.fillPolygon(polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    Color calcOutlineColor() {
        Color color = JCChartUtil.darker(this.color);
        if (color == this.color) {
            color = JCChartUtil.brighter(this.color);
        }
        return color;
    }

    public void fillArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArcShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = JCChartUtil.darker(this.color);
        if (graphics.getColor() != color) {
            graphics.setColor(color);
        }
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        JCFillStyle jCFillStyle = this;
        synchronized (jCFillStyle) {
            this.color = color;
        }
        this.setChanged(true, 17);
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n) {
        JCFillStyle jCFillStyle = this;
        synchronized (jCFillStyle) {
            if (n == this.pattern) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.pattern = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key74"));
                }
            }
        }
        this.setChanged(true, 17);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        JCFillStyle jCFillStyle = this;
        synchronized (jCFillStyle) {
            this.image = image;
        }
        this.setChanged(true, 33);
    }

    public void setImage(Component component, String string) {
        JCFillStyle jCFillStyle = this;
        synchronized (jCFillStyle) {
            this.image = JCUtilConverter.toImage(component, string);
        }
        this.setChanged(true, 33);
    }

    static Color getDefaultColor(JCChart jCChart) {
        return JCFillStyle.getDefaultColor(jCChart, false);
    }

    static Color getDefaultColor(JCChart jCChart, boolean bl) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            color = JCStyle.defaultColors[jCChart.fillColorIndex++];
            if (jCChart.fillColorIndex >= JCStyle.defaultColors.length) {
                jCChart.fillColorIndex = 0;
            }
        }
        if (jCChart != null && jCChart.chartArea != null) {
            ChartDataView chartDataView = jCChart.getDataView(0);
            int n = jCChart.fillColorIndex;
            while (!bl && chartDataView != null && chartDataView.getChartType() == 11 && color == chartDataView.getPieChartFormat().getOtherStyle().getFillColor() || color == jCChart.chartArea.getPlotArea().getBackground()) {
                color = JCStyle.defaultColors[jCChart.fillColorIndex++];
                if (jCChart.fillColorIndex >= JCStyle.defaultColors.length) {
                    jCChart.fillColorIndex = 0;
                }
                if (jCChart.fillColorIndex == n) break;
            }
        }
        return color;
    }

    static int getDefaultPattern(JCChart jCChart) {
        return 1;
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        JCFillStyle jCFillStyle = JCFillStyle.makeDefault(null);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".colorIndex", jCFillStyle.colorIndex, this.colorIndex);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".color", JCStyle.defaultColors[jCFillStyle.colorIndex], this.color);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".pattern", JCUtilConverter.fromEnum(jCFillStyle.pattern, fillPattern_strings, fillPattern_values), JCUtilConverter.fromEnum(this.pattern, fillPattern_strings, fillPattern_values));
    }

    public void loadParams(String string, JCChart jCChart) {
        String string2 = jCChart.getParam(String.valueOf(string) + ".color");
        if (string2 != null) {
            this.setColor(JCChart.getConverter().toColor(string2));
        } else {
            int n = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".colorIndex"), this.colorIndex);
            if (n != this.colorIndex) {
                this.setColor(JCStyle.defaultColors[n]);
            }
        }
        this.setPattern(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".pattern"), "fillPattern", fillPattern_strings, fillPattern_values, this.getPattern()));
        this.setImage(JCChart.getConverter().toImage(jCChart, jCChart.getParam(String.valueOf(string) + ".image"), this.getImage()));
    }

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        fillPattern_values = nArray;
    }
}

