package com.java4less.rmaxicode;
//  RMaxiCode
//  Copyright (C)
//
//  RReport@Confluencia.net
//  All rights reservedse
//
// Adquisition , use and distribution of this code is subject to restriction:
//  - You may modify the source code in order to adapt it to your needs.
//  - You may not copy and paste any code into external files.
//  - Redistribution of this ( or a modified version) source code is prohibited. You may only redistribute compiled versions.
//  - You may redistribute the compiled version as part of your application, not a new java component with the same purpose as this one.
//  - You may not remove this notice from the source code
//  - This notice disclaim all warranties of all material


import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.awt.Graphics2D.*;
import java.awt.*;

	public class RMaxicodeServlet  extends HttpServlet
    {


  public static void main(String[] a) {

  }

        /**
         * Handle the HTTP POST method by sending an e-mail
         *
         *
         */

	    public void init() throws ServletException  {

	    }

       // read paramters form request an create barcode
       // http://localhost:8080/examples/servlet/RMaxicodeServlet?ZIPCODE=B1050&SERVICE=999&COUNTRY=056&DATA=AAADDEEE
       public RMaxiCode getBarcode (HttpServletRequest request) {

       	  RMaxiCode cb=new RMaxiCode();

          // READ MODE
          cb.setMode(2);
          cb.setZipCode("B1050");
          cb.setServiceClass("999");
          cb.setCountry("056");
          cb.setData("DEMO");

          if (request==null) return cb;

          // READ DATA
          String dataStr=request.getParameter("DATA");
          if (dataStr!=null) cb.setData(dataStr);



          String mode=request.getParameter("MODE");
          if (mode!=null) {
             if (mode.compareTo("3")==0) cb.setMode(3);
             if (mode.compareTo("4")==0) cb.setMode(4);
             if (mode.compareTo("5")==0) cb.setMode(5);
             if (mode.compareTo("6")==0) cb.setMode(6);
          }



          // ROTATION
          String rot=request.getParameter("ROTATION");
          cb.setRotation(0);
          if (rot!=null) {
             if (rot.compareTo("90")==0) cb.setRotation(90);
             if (rot.compareTo("180")==0) cb.setRotation(180);
             if (rot.compareTo("270")==0) cb.setRotation(270);

          }

          // RESOLUTION
          String res=request.getParameter("RESOLUTION");
          if (res!=null) {
             int resInt=0;
             try {
               resInt=Integer.parseInt(res);
             } catch (Exception e) {};

             if ((resInt>=72) && (resInt<=600)) cb.setResolution(resInt);

          }

          // READ PRIMARY MESSAGE DATA
          String PC=request.getParameter("POSTALCODE");
          if (PC!=null) cb.setZipCode(PC);

          String Service=request.getParameter("SERVICE");
          if (Service!=null) cb.setServiceClass(Service);

          String country=request.getParameter("COUNTRY");
          if (country!=null) cb.setCountry(country);

          // STRUCTURED APPEND DATA
          String symbols=request.getParameter("NUMBER");
          if (symbols!=null) {
             if (symbols.compareTo("2")==0) cb.setNumberOfCodes(2);
             if (symbols.compareTo("3")==0) cb.setNumberOfCodes(3);
             if (symbols.compareTo("4")==0) cb.setNumberOfCodes(4);
             if (symbols.compareTo("5")==0) cb.setNumberOfCodes(5);
             if (symbols.compareTo("6")==0) cb.setNumberOfCodes(6);
             if (symbols.compareTo("7")==0) cb.setNumberOfCodes(7);
             if (symbols.compareTo("8")==0) cb.setNumberOfCodes(8);
          }

          String symbol=request.getParameter("POSITION");
          if (symbol!=null) {
             if (symbol.compareTo("2")==0) cb.setPositionOfCode(2);
             if (symbol.compareTo("3")==0) cb.setPositionOfCode(3);
             if (symbol.compareTo("4")==0) cb.setPositionOfCode(4);
             if (symbol.compareTo("5")==0) cb.setPositionOfCode(5);
             if (symbol.compareTo("6")==0) cb.setPositionOfCode(6);
             if (symbol.compareTo("7")==0) cb.setPositionOfCode(7);
             if (symbol.compareTo("8")==0) cb.setPositionOfCode(8);

          }

          return cb;


       }

       // Handle a request
       // 1. create barcode
       // 2. draw barcode in a Buffered Image
       // 3. encode image as GIF or JPEG and send it to the browser
        public void doGet (HttpServletRequest request,
                	   HttpServletResponse response)
        throws ServletException, IOException
        {
               PrintWriter		out;
               ServletOutputStream outb;

               response.setContentType("image/jpeg");

		//out=response.getWriter();
		outb=response.getOutputStream();

                // avoid caching in browser
		response.setHeader ("Pragma", "no-cache");
		response.setHeader ("Cache-Control", "no-cache");
		response.setDateHeader ("Expires",0);

                // get BarCode
                RMaxiCode cb=getBarcode(request);

               try { // Create buffer

		java.awt.image.BufferedImage BarImage=new java.awt.image.BufferedImage(cb.getPreferredSize().width,cb.getPreferredSize().height,java.awt.image.BufferedImage.TYPE_INT_RGB);
		java.awt.Graphics2D BarGraphics=BarImage.createGraphics();

                cb.setSize(cb.getPreferredSize());

                cb.paint(BarGraphics);


                // create JPEG image
                com.sun.image.codec.jpeg.JPEGImageEncoder encoder = com.sun.image.codec.jpeg.JPEGCodec.createJPEGEncoder(outb );
                encoder.encode( BarImage );

                // use this to create a gif image
                //GifEncoder encoder = new GifEncoder(BarImage,outb);
                //encoder.encode();


		} catch (Exception e) { e.printStackTrace();}

               //outb.close();

		}


        public void doPost (HttpServletRequest request,
                	   HttpServletResponse response)
        throws ServletException
        {
        try {
            doGet(request,response);
            } catch (Exception e) { e.printStackTrace();}
	}

    }


